/*
 * indicator-network - user interface for connman
 * Copyright 2011 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONNMAN_IPV4_H_
#define _CONNMAN_IPV4_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CONNMAN_TYPE_IPV4 connman_ipv4_get_type()

#define CONNMAN_IPV4(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), CONNMAN_TYPE_IPV4, \
			      ConnmanIPv4))

#define CONNMAN_IPV4_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), CONNMAN_TYPE_IPV4, \
			   ConnmanIPv4Class))

#define CONNMAN_IS_IPV4(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), CONNMAN_TYPE_IPV4))

#define CONNMAN_IS_IPV4_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), CONNMAN_TYPE_IPV4))

#define CONNMAN_IPV4_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), CONNMAN_TYPE_IPV4, \
			     ConnmanIPv4Class))

typedef struct {
  GObject parent;
} ConnmanIPv4;

typedef struct {
  GObjectClass parent_class;
} ConnmanIPv4Class;

#define CONNMAN_IPV4_ERROR connman_ipv4_error_quark()

static inline GQuark connman_ipv4_error_quark(void)
{
  return g_quark_from_static_string ("connman-ipv4-error-quark");
}

typedef enum {
  CONNMAN_IPV4_ERROR_INVALID_METHOD,
  CONNMAN_IPV4_ERROR_INVALID_SETTINGS,
} ConnmanIPv4Error;

typedef enum {
  CONNMAN_IPV4_METHOD_OFF,
  CONNMAN_IPV4_METHOD_MANUAL,
  CONNMAN_IPV4_METHOD_FIXED,
  CONNMAN_IPV4_METHOD_DHCP,
} ConnmanIPv4Method;

GType connman_ipv4_get_type(void);

ConnmanIPv4Method connman_ipv4_get_method(ConnmanIPv4 *self);
const gchar *connman_ipv4_get_method_as_string(ConnmanIPv4 *self);
const gchar *connman_ipv4_get_address(ConnmanIPv4 *self);
const gchar *connman_ipv4_get_netmask(ConnmanIPv4 *self);
const gchar *connman_ipv4_get_gateway(ConnmanIPv4 *self);
ConnmanIPv4 *connman_ipv4_new(ConnmanIPv4Method method,
			      const gchar *address,
			      const gchar *netmask,
			      const gchar *gateway,
			      GError **error);
ConnmanIPv4 *connman_ipv4_new_with_strings(const gchar *method,
					   const gchar *address,
					   const gchar *netmask,
					   const gchar *gateway,
					   GError **error);

#endif
