<?php
/*
 * $Horde: imp/menu.php,v 2.79.2.6 2005/01/03 11:25:48 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

require_once HORDE_BASE . '/lib/Menu.php';

/* Get the folder listing for the <select> widget. */
if ($conf['user']['allow_folders']) {
    $menu_folders = IMP::flistSelect('', true, false, $imp['mailbox']);
}

/* Check for additional site-specific menu items (in config/menu.php). */
$additional_items = '';
if (@is_readable(IMP_BASE . '/config/menu.php')) {
    include_once IMP_BASE . '/config/menu.php';
    if (isset($_menu) && is_array($_menu)) {
        foreach ($_menu as $item) {
            $additional_items .= Menu::customItem($item);
        }
    }
}

require IMP_TEMPLATES . '/menu/menu.inc';

/* Include the JavaScript for the help system (if enabled). */
if ($conf['user']['online_help'] && $browser->hasFeature('javascript')) {
    Help::javascript();
}

?>
