#include <iostream>
#include <iomanip>
#include <sstream>
#include <vector>
#include <map>
#include <stdlib.h>

using namespace std;

#define Vth     16.0
#define Vrs     0
#define Rin     100.0
#define C       (10.0/Rin)
#define Dt      0.1
#define Iv      1.0
#define Tr      (Dt * 30)

map<string, int> artists;

struct INFNeuron
{
    INFNeuron() : v(0), mod(0) { }
    bool step()
    {
        if (recharge > 0)
        {
            recharge -= Dt;
            mod = 0;
            return false;
        }
        float scale = 1; // + 0.1 * random() / (float)RAND_MAX;
        v = (1 - Dt/(C*Rin))*v + Dt*(Iv * scale + mod)/C;
        if (v < 0)
            v = 0;
        mod = 0;
        if (v > Vth)
        {
            v = Vrs;
            recharge = Tr;
            return true;
        }
        return false;
    }
    float getv() { return v; }
    void influence(float infl) { mod += infl; }
private:
    float v, mod, recharge;
};

class NeuronField
{
public:
    NeuronField(int size, float *dmatrix, float *outdm) : 
        size(size), dmatrix(dmatrix), outdm(outdm)
    {
        neurons = new INFNeuron[size];
    }

    ~NeuronField() { delete[] neurons; }

    void step()
    {
        float total = 0;
        for (int i = 0; i < size; ++i)
            total += neurons[i].getv();

        for (int i = 0; i < size; ++i)
        {
            //neurons[i].influence( - total * 0.6);
            for (int j = 0; j < size; ++j)
                neurons[i].influence(neurons[j].getv() * dmatrix[i * size + j]);
        }
        
        vector<int> fired;
        for (int i = 0; i < size; ++i)
            if (neurons[i].step())
            {
                fired.push_back(i);
                cout << setw(3) << i << " ";
            }

        if (!fired.empty())
            cout << endl;

        for (vector<int>::iterator i = fired.begin();
                i != fired.end(); ++i)
        {
            if (outdm)
                for (vector<int>::iterator j = i; j != fired.end(); ++j)
                {
                    ++outdm[*i * size + *j];
                    ++outdm[*j * size + *i];
                };

            for (map<string, int>::iterator j = artists.begin();
                    j != artists.end(); ++j)
                if (j->second == *i)
                    cout << j->first << " ";
        }

        if (!fired.empty())
            cout << endl;
    };

protected:
    int size, numfired;
    float *dmatrix, *outdm;
    INFNeuron *neurons;
};

int main()
{
    float total = 0;
    int counter = 0;
    int weight;
    string a1, a2;
    stringstream ss;
    map<pair<int, int>, float> weights;
    int curart = 0;


    while (cin >> weight)
    {
        ++counter;
        total += weight;
        cin.get();
        getline(cin, a1, '|');
        getline(cin, a2);

        if (artists.find(a1) == artists.end())
            artists[a1] = curart++;

        if (artists.find(a2) == artists.end())
            artists[a2] = curart++;

        weights[pair<int, int>(artists[a1], artists[a2])]
            = std::min(1.0, weight / 200.0);
    }

    const int size = artists.size();
    cout <<  "processed " << counter << " lines" << endl;
    cout << size << " unique artists" << endl;

    float *dm = new float[size * size];
    memset(dm, 0, sizeof(size * size * sizeof(float)));

    float *dm2 = new float[size * size];
    memset(dm2, 0, sizeof(size * size * sizeof(float)));

    for (map<pair<int, int>, float>::iterator i = weights.begin();
            i != weights.end(); ++i)
    {
        dm[i->first.first * size + i->first.second] = i->second;
        dm[i->first.second * size + i->first.first] = i->second;
    }

    NeuronField nf(size, dm, dm2);

    for (int i = 0; i < 1000; ++i)
        nf.step();

    cout << endl << endl << endl;
    cout << "***************************************" << endl;
    cout << endl << endl << endl;

    NeuronField nf2(size, dm2, 0);

    for (int i = 0; i < size; ++i)
        for (int j = 0; j < size; ++j)
            dm2[i * size + j] = std::min(2.0f, dm2[i * size + j] / 30);

    for (int i = 0; i < 300; ++i)
        nf2.step();

}
