#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <sys/stat.h>
#include <locale.h>

#include "imapfilter.h"
#include "session.h"
#include "queue.h"
#include "version.h"
#include "buffer.h"
#include "pathnames.h"


extern buffer_t ibuf, obuf, nbuf;

options_t opts;			/* Program options. */

struct sessionhead sessions = XLIST_HEAD_INITIALIZER(sessions);	/* Active IMAP sessions. */


void usage(void);
void version(void);


/*
 * IMAPFilter: an IMAP mail filtering utility.
 */
int
main(int argc, char *argv[])
{
	int c;

	setlocale(LC_CTYPE, "");

	opts.debug = 0;
	opts.verbose = 0;
	opts.log = NULL;
	opts.config = NULL;
	opts.home = getenv("HOME");

	while ((c = getopt(argc, argv, "Vc:dl:v?")) != -1) {
		switch (c) {
		case 'V':
			version();
			/* NOTREACHED */
		case 'c':
			opts.config = optarg;
			break;
		case 'd':
			if (opts.debug < 2)
				opts.debug++;
			break;
		case 'l':
			opts.log = optarg;
			break;
		case 'v':
			opts.verbose = 1;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	}

	open_debug();

	create_homedir();

	catch_signals();

	open_log();

	buffer_init(&ibuf, RESPONSE_BUF);
	buffer_init(&obuf, REQUEST_BUF);
	buffer_init(&nbuf, NAMESPACE_BUF);

	if (opts.config == NULL) {
		opts.config = (char *)xmalloc(PATH_MAX * sizeof(char));
		snprintf(opts.config, PATH_MAX, "%s/%s", opts.home,
		    PATHNAME_CONFIG);
	}
	start_lua();

	{
		session_t *s, *t;

		XLIST_FOREACH_SAFE(s, &sessions, links, t) {
			response_generic(s, imap_logout(s));
			close_connection(s);
			session_destroy(s);
		}
	}

	stop_lua();

	buffer_free(&ibuf);
	buffer_free(&obuf);
	buffer_free(&nbuf);

	close_log();
	close_debug();

	exit(0);
}


/*
 * Print a very brief usage message.
 */
void
usage(void)
{

	fprintf(stderr, "usage: imapfilter [-Vdv] [-c configfile] "
	    "[-l logfile]\n");

	exit(0);
}


/*
 * Print program's version and copyright.
 */
void
version(void)
{

	fprintf(stderr, "IMAPFilter %s  %s\n", IMAPFILTER_VERSION,
	    IMAPFILTER_COPYRIGHT);

	exit(0);
}
