/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include "unit_input.h"

IMKeyEventStruct *parseKey(xmlDocPtr, xmlNodePtr);
IMHotkeyStruct *parseHotkey(xmlDocPtr, xmlNodePtr);
IMHotkeyProfileStruct *parseHotkeyProfile(xmlDocPtr, xmlNodePtr);
IMHotkeyManagerStruct *parse_hotkey_config_file(IMLEName *, char *);
void printHotkeyManager(IMHotkeyManagerStruct *);

extern int get_key_value(char *);

IMKeyEventStruct * 
parseKey(
    xmlDocPtr doc,
    xmlNodePtr cur
)
{
   IMKeyEventStruct *key;

   key = (IMKeyEventStruct *) calloc (1, sizeof(IMKeyEventStruct));
   if (key == NULL) {
     printf("parseKey: calloc error \n");
     return (NULL);
   }

   cur = cur->xmlChildrenNode;
   while (cur != NULL) {
     if (!xmlStrcmp(cur->name, (const xmlChar *)"text") || 
                   !xmlStrcmp(cur->name, (const xmlChar *)"comment")) {
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"keycode")) {
       char *kc = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
       if (kc && strstr(kc, "IM_")) {
         key->keyCode  = get_key_value(kc);
       } else {
         key->keyCode  = atoi(kc);
       }
       free(kc);
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"modifier")) {
       char *mo = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
       int modifier = 0;
       if (mo && strstr(mo, "IM_")) {
         if (strstr(mo, "IM_SHIFT_MASK")) {
           modifier += 1;
         } 
         if (strstr(mo, "IM_CTRL_MASK")) {
           modifier += 2;
         }  
         if (strstr(mo, "IM_META_MASK")) {
           modifier += 4;
         } 
         if (strstr(mo, "IM_ALT_MASK")) {
           modifier += 8;
         }
         if (strstr(mo, "IM_ALT_GRAPH_MASK")) {
           modifier += 32;
         }
         key->modifier = modifier;
       } else { 
          key->modifier = atoi(mo);
       }
       free(mo); 
       cur = cur->next;
     }
   }
   return key;
}

IMHotkeyStruct *
parseHotkey(
   xmlDocPtr doc,
   xmlNodePtr cur
)
{
   IMHotkeyStruct *hk = NULL;
   IMKeyEventStruct *keys = NULL;
   int i;

   hk = (IMHotkeyStruct *) calloc (1, sizeof(IMHotkeyStruct));
   if (hk == NULL) {
     printf("parseHotkey: calloc error \n");
     return (NULL);
   }

   cur = cur->xmlChildrenNode;
   while (cur != NULL) {
     if (!xmlStrcmp(cur->name, (const xmlChar *)"text") || 
                   !xmlStrcmp(cur->name, (const xmlChar *)"comment")) {
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"id")) {
       /*
       int hk_id = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       */
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"state_flag")) {
       hk->state_flag = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"action_flag")) {
       hk->action_flag = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"label")) {
       hk->label = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"num_keys")) {
       hk->nkeys = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       hk->keys = (IMKeyEventStruct *) calloc(hk->nkeys, sizeof(IMKeyEventStruct));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"key")) {
       for (i=0; i<hk->nkeys; i++) {
         keys = parseKey(doc, cur);
         hk->keys[i].keyCode = keys->keyCode;
         hk->keys[i].modifier = keys->modifier;
         if (cur)
           cur = cur->next;
       }
     }
   }
   return hk;
}

IMHotkeyProfileStruct *
parseHotkeyProfile(
   xmlDocPtr doc,
   xmlNodePtr cur
)
{
   IMHotkeyProfileStruct *hkp = NULL;
   IMHotkeyStruct *hk = NULL;
   int i;

   hkp = (IMHotkeyProfileStruct *) calloc (1, sizeof(IMHotkeyProfileStruct));
   if (hkp == NULL) {
     printf("parseHotkeyProfile: calloc error \n");
     return (NULL);
   }

   cur = cur->xmlChildrenNode;

   while (cur != NULL) {
     if (!xmlStrcmp(cur->name, (const xmlChar *)"id")) {
       hkp->profile_id = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"text") || 
                   !xmlStrcmp(cur->name, (const xmlChar *)"comment")) {
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"scope")) {
       char *scope = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
       if (scope && strstr(scope, "SESSION_SPECIFIC_HOTKEY")) {
         hkp->scope = 1;
       } else if (scope && strstr(scope, "GLOBAL_HOTKEY")) {
         hkp->scope = 0;
       } else
          hkp->scope  = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       free(scope);
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"num_hotkeys")) {
       hkp->num_hotkeys = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       hkp->hks = (IMHotkeyStruct *) calloc(hkp->num_hotkeys, sizeof(IMHotkeyStruct));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"hotkey")) {
       for (i=0; i<hkp->num_hotkeys; i++) {
         hk = parseHotkey(doc, cur);
         hkp->hks[i].label = hk->label;
         hkp->hks[i].state_flag = hk->state_flag;
         hkp->hks[i].action_flag = hk->action_flag;
         hkp->hks[i].nkeys = hk->nkeys;
         hkp->hks[i].keys = hk->keys;
         if (cur)
           cur = cur->next;
       }
     }
   }
   return hkp;
}

IMHotkeyManagerStruct *
parse_hotkey_config_file(
   IMLEName *le_name,
   char *filename
) 
{
   IMHotkeyManagerStruct *hkm;
   IMHotkeyProfileStruct *hkp;
   xmlDocPtr doc;
   xmlNodePtr cur;
   int i;

   LIBXML_TEST_VERSION

   xmlKeepBlanksDefault(0);

   /*
    * build an XML tree from the configuration file
    */

   doc = xmlParseFile(filename);
   if (doc == NULL) return(NULL);

   /*
    * Check if the document is of the right kind
    */
   
   cur = xmlDocGetRootElement(doc);
   if (cur == NULL) {
     printf("Empty document ..\n");
     xmlFreeDoc(doc);
     return(NULL);
   }

   /*
    * Allocate the structure to be returned.
    */

   hkm = (IMHotkeyManagerStruct *) calloc(1, sizeof(IMHotkeyManagerStruct));
   if (hkm == NULL) {
     printf("parse_hotkey_config_file: calloc error \n");
     xmlFreeDoc(doc);
     return(NULL);
   }

   /*
    * Now, walk the tree.
    */

   /* First level we expect just le */
   if (!xmlStrcmp(cur->name, (const xmlChar *)"le")) {
     cur = cur->xmlChildrenNode;
   } else {
     printf("Invalid configuration file ..\n");
     xmlFreeDoc(doc);
     return(NULL);
   }
   
   while (cur != NULL) {
     if (!xmlStrcmp(cur->name, (const xmlChar *)"name")) {
       char *le_name = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"text") || !xmlStrcmp(cur->name, (const xmlChar *)"comment")) {
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"num_hotkey_profiles")) {
       hkm->num_hotkey_profiles = atoi(xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
       hkm->hkps = (IMHotkeyProfileStruct *)calloc(hkm->num_hotkey_profiles, sizeof(IMHotkeyProfileStruct));
       cur = cur->next;
     }
     if (!xmlStrcmp(cur->name, (const xmlChar *)"hotkey_profile")) {
       for (i=0; i<hkm->num_hotkey_profiles; i++) {
         /*
         hkm->hkps[i] = (IMHotkeyProfileStruct *)parseHotkeyProfile(doc, cur);
         */
         hkp = parseHotkeyProfile(doc, cur);
         hkm->hkps[i].profile_id = hkp->profile_id;
         hkm->hkps[i].scope = hkp->scope;
         hkm->hkps[i].name = le_name;
         hkm->hkps[i].num_hotkeys = hkp->num_hotkeys;
         hkm->hkps[i].hks = hkp->hks;
         if (cur)
           cur = cur->next;
       }
     }
   }
  
   return hkm;
}

void
printHotkeyManager(
   IMHotkeyManagerStruct *hkm
)
{
   int i, j, k;

   printf("\nprintHotkeyManager: num_hotkey_profiles [%d]\n", hkm->num_hotkey_profiles);
   for (i=0; i<hkm->num_hotkey_profiles; i++) {
     printf("\n++++ HOTKEY PROFILE: id [%d]\n", hkm->hkps[i].profile_id);
     printf("++++ scope [%d]\n", hkm->hkps[i].scope);
     printf("++++ num_hotkeys [%d]\n", hkm->hkps[i].num_hotkeys);
     for (j=0; j<hkm->hkps[i].num_hotkeys; j++) {
       printf("\n++++++ HOTKEY: state_flag [%d]\n", hkm->hkps[i].hks[j].state_flag);
       printf("++++++ HOTKEY: action_flag [%d]\n", hkm->hkps[i].hks[j].action_flag);
       printf("++++++ HOTKEY: label [%s]\n", hkm->hkps[i].hks[j].label);
       printf("++++++ HOTKEY: nkeys [%d]\n", hkm->hkps[i].hks[j].nkeys);
       for (k=0; k<hkm->hkps[i].hks[j].nkeys; k++) {
         printf("\n++++++++ KEYS: keyCode [%d]\n", hkm->hkps[i].hks[j].keys[k].keyCode);
         printf("++++++++ KEYS: modifier [%d]\n", hkm->hkps[i].hks[j].keys[k].modifier);
       }
     }
   }
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
