/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include "codetable.h"

#define MAX_SEARCH_NUM	32	
#define MAX_CHAR_LEN	128

CodeTableStruct hzCodeTable;

int main(int argc, char *argv[])
{
  char inbuf[64];
  unsigned char *outbuf[MAX_SEARCH_NUM]; 
  unsigned char *attrbuf[MAX_SEARCH_NUM]; 
  int i, again, ret, search_pos, search_num, num, in;
  char *filename = "wubi.data";

  if (argc == 2)
    filename = argv[1];

  ret = LoadCodeTable(filename, &hzCodeTable);

  if (ret == -1)
    {
      UnloadCodeTable(&hzCodeTable);
      exit(1);
    }

  for (i=0; i<MAX_SEARCH_NUM; i++)
    {
      outbuf[i] = (unsigned char *)malloc(MAX_CHAR_LEN);
      attrbuf[i] = (unsigned char *)malloc(MAX_CHAR_LEN);
    }

  search_pos = 0;
  search_num = 6;

  again = 1;
  while (again) {
    printf("input code = ");
    scanf("%s", inbuf);
    if (inbuf[0] == 'Q') break;
    in = atoi(inbuf);
    num = codetable_search(&hzCodeTable, &in, 1, outbuf, attrbuf, search_pos, search_num);
    if (num>0)
      {
	printf("search result:\n");
	/*
	  for (i=0; i<num; i++)
	  printf("\t%d: %s\n", i, outbuf[i]);
	*/
	for (i=0; i<num; i++)
	  printf("\t%d: %s %s\n", i, outbuf[i], attrbuf[i]);
      }
    else 
      printf("no matched phrase\n");

  }

  UnloadCodeTable(&hzCodeTable);
  exit(0);
}

