/* translators: 
 * This means ASCII character input only, so in some locales,
 * translations for "NO Conversion" may be more proper.
 */
#define DEFAULT_LANG N_("ASCII")

typedef enum
{
  ASCII,

  LATIN,
  CYRILLIC,
  GREEK,
  THAI,
  ARABIC,
  HEBREW,
  VIETNAMESE,
  ERITREAN,
  AMHARIC,
  TAMIL,
  BENGALI,
  KANNADA,
  GUJIRATI,
  GURMUKHI,
  HINDI,
  MALAYALAM,
  TELUGU,

  /* m17n language list */
  ASSAMESE,
  TIBETAN,
  DHIVEHI,
  FARSI,
  CROATIAN,
  ARMENIAN,
  GEORGIAN,
  KAZAKH,
  CAMBODIAN,
  LAOTHIAN,
  BURMESE,
  ORIYA,
  SINHALESE,
  SLOVAK,
  SERBIAN,

  KO_KR,
  JA_JP,
  ZH_CN,
  ZH_HK,
  ZH_TW,

  UNICODE,

  LAST_LANGUAGE
} GimletLanguageIndex;

struct _GimletLanguage
{
  GimletLanguageIndex idx;
  gboolean valid;
  gboolean conversion_on;
  char     *description;
  gchar	   *name;
  gchar	   *iiim_lang_name;
};

static GimletLanguage g_languages[] = {
  { ASCII, TRUE, FALSE,
    DEFAULT_LANG, "ASCII", "ASCII", },

  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "en"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "de"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "fr"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "pl"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "es"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "it"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "pt_BR"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "sv"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "cs"},
  {LATIN, FALSE, TRUE,
   N_("Latin"), "Latin", "hu"},

  {CYRILLIC, FALSE, TRUE,
   N_("Cyrillic"), "русский", "ru_RU"},
  {GREEK, FALSE, TRUE, 
   N_("Greek"), "Greek", "el_GR"},
  {THAI, FALSE, TRUE,
   N_("Thai"), "ไทย", "th_TH"},
  {ARABIC, FALSE, TRUE,
   N_("Arabic"), "Arabic", "ar"},
  {HEBREW, FALSE, TRUE,
   N_("Hebrew"), "עברית", "he"},
  {VIETNAMESE, FALSE, TRUE,
   N_("Vietnamese"), "Việt Nam", "vi_VN"},
  {ERITREAN, FALSE, TRUE,
   N_("Eritrean"), "Eritrean", "ti_ER"},
  {AMHARIC, FALSE, TRUE,
   N_("Amharic"), "Amharic", "am_ET"},

  /* translators: Tamil is a name of Indic language. */
  {TAMIL, FALSE, TRUE,
   N_("Indic-Tamil"), "தமிழ்", "ta_IN"},
  /* translators: Bengali is a name of Indic language. */
  {BENGALI, FALSE, TRUE,
   N_("Indic-Bengali"), "বাংলা", "bn"},
  /* translators: Kannada is a name of Indic language. */
  {KANNADA, FALSE, TRUE,
   N_("Indic-Kannada"), "ಕನ್ನಡ", "kn_IN"},
  /* translators: Gujarati is a name of Indic language. */
  {GUJIRATI, FALSE, TRUE,
   N_("Indic-Gujarati"), "ગુજરાતી", "gu_IN"},
  /* translators: Pubjabi is a name of Indic language. */
  {GURMUKHI, FALSE, TRUE,
   N_("Indic-Punjabi"), "ਪੰਜਾਬੀ", "pa_IN"},
  /* translators: Hindi is a name of Indic language. */
  {HINDI, FALSE, TRUE,
   N_("Indic-Hindi"), "हिंदी", "hi_IN"},
  /* translators: Malayalam is a name of Indic language. */
  {MALAYALAM, FALSE, TRUE,
   N_("Indic-Malayalam"), "മലയാളം", "ml_IN"},
  /* translators: Telugu is a name of Indic language. */
  {TELUGU, FALSE, TRUE,
   N_("Indic-Telugu"), "Telugu", "te_IN"},

  /* m17n languages */
  {ASSAMESE, FALSE, TRUE,
   N_("Assamese"), "Assamese", "as"},
  {TIBETAN, FALSE, TRUE,
   N_("Tibetan"), "Tibetan", "bo"},
  {DHIVEHI, FALSE, TRUE,
   N_("Dhivehi"), "Dhivehi", "dv"},
  {FARSI, FALSE, TRUE,
   N_("Farsi"), "Farsi", "fa"},
  {CROATIAN, FALSE, TRUE,
   N_("Croatian"), "Croatian", "hr"},
  {ARMENIAN, FALSE, TRUE,
   N_("Armenian"), "Armenian", "hy"},
  {GEORGIAN, FALSE, TRUE,
   N_("Georgian"), "Georgian", "ka"},
  {KAZAKH, FALSE, TRUE,
   N_("Kazakh"), "Kazakh", "kk"},
  {CAMBODIAN, FALSE, TRUE,
   N_("Cambodian"), "Cambodian", "km"},
  {LAOTHIAN, FALSE, TRUE,
   N_("Laothian"), "Laothian", "lo"},
  {BURMESE, FALSE, TRUE,
   N_("Burmese"), "Burmese", "my"},
  {ORIYA, FALSE, TRUE,
   N_("Oriya"), "Oriya", "or"},
  {SINHALESE, FALSE, TRUE,
   N_("Sinhalese"), "Sinhalese", "si"},
  {SLOVAK, FALSE, TRUE,
   N_("Slovak"), "Slovak", "sk"},
  {SERBIAN, FALSE, TRUE,
   N_("Serbian"), "Serbian", "sr"},

  { KO_KR, FALSE, TRUE,
    N_("Korean"), "한국어", "ko"},
  { JA_JP, FALSE, TRUE,
    N_("Japanese"), "日本語", "ja"},

  { ZH_CN, FALSE, TRUE,
    N_("S-Chinese"), "中文 (简体)", "zh_CN"},
  { ZH_HK, FALSE, TRUE,
    N_("T-Chinese (Hong Kong)"), "中文 (繁體) (香港)", "zh_HK"},
  { ZH_TW, FALSE, TRUE,
    N_("T-Chinese"), "中文 (繁體)", "zh_TW"},

  { UNICODE, FALSE, TRUE,
     N_("Unicode"), "Unicode",  "UNICODE-HEX"}
};

