/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "PYIM.h"
#include "ZyBasic.h"
#include "PyBig5.h"

#define ZHUYIN_MODE 0
#define PINYIN_MODE 1

#define EDIT_KEY    0
#define SEARCH_KEY  1

#define ALTMASK		8

ImToXSun* ConvertPreeditLookup(JINT nSesID);
extern VOID FilterCandiForward(JINT nSesID, ImToXSun* to);
extern VOID FilterCandiBackward(JINT nSesID, ImToXSun* to, JINT EndBak);
extern ImToXSun* CommitCandidate(int nSesID, ImToXSun* to, int index);

static int Mode = ZHUYIN_MODE;
static ImToXSun dummy[512];

JINT KeySeq[10];
JINT KeySeqLen;

VOID InitKeySeq() {
    KeySeqLen = 0;
}

VOID AppendKey(JINT Key) {
    KeySeq[KeySeqLen] = Key;
    KeySeqLen ++;
}

JINT GetKeySeqLen() {
    return KeySeqLen;
}

JINT GetKey(JINT Pos) {
    return KeySeq[Pos];
}

JINT IsTone (int tone) {
    if( (tone >= CY_TONE1) && (tone <= CY_TONE5) ) return TRUE;
    else return FALSE;
}

JINT GetToneSymbol( int tone ){
    if(tone == CY_TONE1) return CY_TONE1_SYMBOL;
    else if(tone == CY_TONE2) return CY_TONE2_SYMBOL;
    else if(tone == CY_TONE3) return CY_TONE3_SYMBOL;
    else if(tone == CY_TONE4) return CY_TONE4_SYMBOL;
    else if(tone == CY_TONE5) return CY_TONE5_SYMBOL;
    else return -1;
}

JINT IsShengMu (int yinJie) {
    if((yinJie >= CY_B) && (yinJie <= CY_S)) return TRUE;
    else return FALSE;
}

JINT IsIUV (int yinJie) {
    if((yinJie >= CY_I) && (yinJie <= CY_V)) return TRUE;
    else return FALSE;
}

JINT IsUpperIUV(int yinJie) {
    if((yinJie >= CY_YI) && (yinJie <= CY_YU)) return TRUE;
    return FALSE;
}

JINT IsUpperYi (int yinJie) {
    if(yinJie == CY_YI) return TRUE;
    else return FALSE;
}

JINT IsUpperWu (int yinJie) {
    if(yinJie >= CY_WU) return TRUE;
    else return FALSE;
}

JINT IsUpperYu (int yinJie) {
    if(yinJie >= CY_YU) return TRUE;
    else return FALSE;
}

JINT IsYunMu (int yinJie) {
    if((yinJie >= CY_A) && (yinJie <= CY_OU)) return TRUE;
    else return FALSE;
}

JINT IsZCS (int yinJie) {
    if((yinJie >= CY_ZH) && (yinJie <= CY_S)) return TRUE;
    else return FALSE;
}

JINT IsUpperZCS (int yinJie) {
    if((yinJie >= CY_ZHI) && (yinJie <= CY_SI)) return TRUE;
    else return FALSE;
}

JINT IsJQX (int yinJie) {
    if((yinJie >= CY_J) && (yinJie <= CY_X)) return TRUE;
    else return FALSE;
}

JINT IsNL (int yinJie) {
    if((yinJie == CY_N) || (yinJie == CY_L)) return TRUE;
    else return FALSE;
}

JINT IsGKH (int yinJie) {
    if((yinJie >= CY_G) && (yinJie <= CY_H)) return TRUE;
    else return FALSE;
}

JINT IsCompressedYunMu(CHAR *str) {
    if(!strcmp(str,  "ien") ||
       !strcmp(str,  "ieng") ||
       !strcmp(str,  "iou") ||
       !strcmp(str,  "uei") ||
       !strcmp(str,  "uen") ||
       !strcmp(str,  "ueng")) return TRUE;
    else return FALSE;
}

JINT IsValidYinJie(CHAR *str, int yunmu_start, CHAR *yunmu) {
    JINT i, flag = 0;
    CHAR tmp[10] = "";

    yunmu[0] = 0;
    
    if(strcmp(str + yunmu_start, "ie") == 0)  { 
        if(str[0] == 'y') strcpy(yunmu, "e");
        else strcpy(yunmu, "ie"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "ien"))  { 
        strcpy(yunmu, "in"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "ieng")) { 
        strcpy(yunmu, "ing"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "iou")) {
        if(str[0] == 'y') strcpy(yunmu, "ou");
        else strcpy(yunmu, "iu"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "uei") && (str[0] != 'w')) {
        strcpy(yunmu, "ui"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "ue") ||
	    !strcmp(str + yunmu_start, "ve") ) {
        if( str[0] == 'l' || str[0] == 'n' ||
            str[0] == 'y' || str[0] == 'j' ||
            str[0] == 'q' || str[0] == 'x' ) { 
            strcpy(yunmu, "ue"); 
	    flag = 1;
        }
    }
    else if(!strcmp(str + yunmu_start, "uen") && (str[0] != 'w')) {
        strcpy(yunmu, "un"); 
	flag = 1;
    }
    else if(!strcmp(str + yunmu_start, "ueng")) {
        if ((str[0] == 'j') || (str[0] == 'q') || (str[0] == 'x')) { 
            strcpy(yunmu, "iong"); 
	    flag = 1;
        }
        else if(str[0] != 'w') {
            strcpy(yunmu, "ong");
	    flag = 1;
        }
    } 
    else if(!strcmp(str + yunmu_start, "uo") && (str[0] == 'w')) { 
        strcpy(yunmu, "o"); 
	flag = 1;
    } 
    if(flag == 1) {
	strncpy(tmp, str, yunmu_start);
	tmp[yunmu_start] = 0;
	strcat(tmp, yunmu);
    }
    else {
	if((str[0] == 'y') && (str[1] == 'i')) {
            tmp[0] = str[0];
	    tmp[1] = 0;
            strcat(tmp + 1, str + 2);
        }
        else if((str[0] == 'w') && (str[1] == 'u')) {
            tmp[0] = str[0];
	    tmp[1] = 0;
            strcat(tmp + 1, str + 2);
        }
        else strcpy(tmp, str);
    }

    for(i = 0; i < NUM_YINJIE; i ++) {
        if(strcmp(tmp, YINJIESTR_CSZ[i]) == 0) {
            return TRUE;
        }
    }
    return FALSE;
}

JINT GetCurrentLen(CHAR *raw, JINT caret, JINT length, JINT dir) {
    JINT len, yj;
    CHAR tmp[10], tmp1[10];

    if((caret == 0) && (dir == 0)) return 0;
    else if ((caret == length) && (dir == 1)) return 0;

    if(dir == 0) {
        yj = raw[caret - 1];
        len = strlen(ZhuyinPinyin[yj].pinyin_key);
        strcpy(tmp1, ZhuyinPinyin[yj].pinyin_key);
	
	if((caret > 1) && IsYunMu(yj)) {
	    yj = raw[caret - 2];
	    if(IsIUV(yj) || IsUpperIUV(yj)) {
		strcpy(tmp, ZhuyinPinyin[yj].pinyin_key);
		strcat(tmp, tmp1);
		if(IsCompressedYunMu(tmp)) {
	    	    if((yj == CY_U) && (raw[caret - 1] == CY_ENG) && (caret > 2) && IsJQX(raw[caret - 3])) ; 
		    else len --;
		}
	    }
	}
	else if(IsUpperIUV(yj) && (caret < length)) {
	    if((yj == CY_YU) && (raw[caret] == CY_IE));
	    else if((yj == CY_YU) && (raw[caret] == CY_AN));
	    else if(IsYunMu(raw[caret])) len --;
	}
    }
    else {
	yj = raw[caret];
	len = strlen(ZhuyinPinyin[yj].pinyin_key);
	strcpy(tmp1, ZhuyinPinyin[yj].pinyin_key);

	if((caret > 1) && IsYunMu(yj)) {
	    yj = raw[caret - 1];
	    if(IsIUV(yj) || IsUpperIUV(yj)) {
		strcpy(tmp, ZhuyinPinyin[yj].pinyin_key);
		strcat(tmp, tmp1);
		if(IsCompressedYunMu(tmp)) {
	    	    if((yj == CY_U) && (raw[caret] == CY_ENG) && (caret > 1) && IsJQX(raw[caret - 2])) ; 
		    else len --;
		}
	    }
	}
	else if(IsUpperIUV(yj) && (caret < length - 1)) {
	    if((yj == CY_YU) && (raw[caret + 1] == CY_IE));
	    else if((yj == CY_YU) && (raw[caret + 1] == CY_AN));
	    else if(IsYunMu(raw[caret + 1])) len --;
	}
    }
    return len;
}
		    
VOID ConvertYinJie(CHAR *raw, JINT caret, JINT hz_caret, JINT length, JINT *newyj) {

    JINT i, len, smlen;
    CHAR tmp[10], tmp1[10], *tmpsm = NULL, *tmpiuv = NULL, *tmpym = NULL;

    InitKeySeq();
    
    if(newyj == NULL) {
	if ((caret > 0) && (caret == length) && 
	    (raw[caret - 1] != CY_SEP)) /* && IsUpperZCS(raw[caret - 1])) */
	    AppendKey('\'');
	else AppendKey(-1);
    }

    else if(IsShengMu(*newyj)) {
        if(IsZCS(*newyj)) *newyj += 23; /* to zhi chi shi ri zi ci si */
        if((caret > 0) && (raw[caret - 1] != CY_SEP)) AppendKey('\'');
        len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
        for(i = 0; i < len; i ++) 
	    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);

	if((caret == 0) && (length > caret)) {
	    AppendKey('\'');
	    AppendKey(IMXK_Left);
	}
    }

    else if(IsIUV(*newyj)) {
        if((caret == 0) || IsYunMu(raw[caret - 1]) || IsTone(raw[caret - 1]) || 
	   (raw[caret - 1] == CY_SEP) || (hz_caret == caret)) {
            *newyj += 23;
            if((caret > 0) && (raw[caret - 1] != CY_SEP)) AppendKey('\'');
            len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
            for(i = 0; i < len; i ++) 
	        AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	    if((caret == 0) && (length > caret)) {
	        AppendKey('\'');
	        AppendKey(IMXK_Left);
	    }
        }

        else {    
            if(IsUpperZCS(raw[caret - 1])) {
                if(*newyj == CY_U) {
                    raw[caret - 1] -= 23;
                    AppendKey(IMXK_BackSpace);
		}
                else {
                    *newyj += 23;
		    AppendKey('\'');
		}
                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++)
                    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	        if((caret == 0) && (length > caret)) {
	            AppendKey('\'');
	            AppendKey(IMXK_Left);
	        }
            }

            else if(IsIUV(raw[caret - 1]) || IsUpperIUV(raw[caret - 1])) {
                *newyj += 23;
		AppendKey('\'');
                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++) 
                    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	        if((caret == 0) && (length > caret)) {
	            AppendKey('\'');
	            AppendKey(IMXK_Left);
	        }
            }

            else if( (IsGKH(raw[caret - 1]) && (*newyj == CY_I)) ||
                     (IsJQX(raw[caret - 1]) && (*newyj == CY_U)) ||
                     (!IsJQX(raw[caret - 1]) && !IsNL(raw[caret - 1]) && (*newyj == CY_V)) ){
                *newyj += 23;
		AppendKey('\'');
                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++) 
                    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	        if((caret == 0) && (length > caret)) {
	            AppendKey('\'');
	            AppendKey(IMXK_Left);
	        }
            }

            else if(IsJQX(raw[caret - 1]) && (*newyj == CY_V)) {
                *newyj = CY_U; /* v to u */
                AppendKey(ZhuyinPinyin[*newyj].pinyin_key[0]);
            }

	    else {
                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++)
                    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
            }
        }
    }

    else if(IsYunMu(*newyj)) {
        tmpym = ZhuyinPinyin[*newyj].pinyin_key;
        smlen = 0;

        tmpsm = tmpiuv = NULL;
        if((caret > 0) && (caret != hz_caret)){
            if(IsUpperZCS(raw[caret - 1])) {
                tmpsm = ZhuyinPinyin[raw[caret - 1] - 23].pinyin_key;
                tmpiuv = NULL;
                smlen = strlen(tmpsm);
            }
            else if(IsUpperIUV(raw[caret - 1])) {
                tmpiuv = ZhuyinPinyin[raw[caret - 1]].pinyin_key;
                tmpsm = NULL;
                smlen = 1;
            }
            else if(IsShengMu(raw[caret - 1])) {
                tmpsm = ZhuyinPinyin[raw[caret - 1]].pinyin_key;
                smlen = strlen(tmpsm);
                tmpiuv = NULL;
            }
            else if((caret > 1) && IsIUV(raw[caret - 1]) && IsShengMu(raw[caret - 2])) {
                tmpsm=ZhuyinPinyin[raw[caret - 2]].pinyin_key;
                smlen = strlen(tmpsm);
                tmpiuv=ZhuyinPinyin[raw[caret - 1]].pinyin_key;
	    }
        }

        tmp[0] = 0;
        if(tmpsm != NULL) strcat(tmp, tmpsm); 
        if(tmpiuv != NULL) strcat(tmp, tmpiuv);
        if(tmpym != NULL) strcat(tmp, tmpym);

        if(IsValidYinJie(tmp, smlen, tmp1)) {
	    if((caret > 0) && (caret != hz_caret) && IsUpperZCS(raw[caret - 1])) {
		raw[caret - 1] -= 23;
		AppendKey(IMXK_BackSpace);
	    } 
	    else if((caret > 0) && (caret != hz_caret) && IsUpperIUV(raw[caret - 1])) 
		if(IsUpperYu(raw[caret - 1]) && (*newyj == CY_AN) );
		else if( (raw[caret] != CY_SEP) && (caret < length) ) ;
		else AppendKey(IMXK_BackSpace);

            if(strlen(tmp1) == 0) {
		if((caret > 0) && (caret == hz_caret)) AppendKey('\'');
		else if((caret > 0) && (tmpsm == NULL) && (tmpiuv == NULL) && (raw[caret - 1] != CY_SEP)) AppendKey('\'');

                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++)
                    AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	        if((caret == 0) && (length > caret)) {
	            AppendKey('\'');
	            AppendKey(IMXK_Left);
	        }
            }
            else {
                len = strlen(tmp1);
                if(tmpsm != NULL) AppendKey(IMXK_BackSpace);
                for(i = 0; i < len; i ++) AppendKey(tmp1[i]);
            }
        }
        else {
	    if((*newyj == CY_EI) || (*newyj == CY_IE)) AppendKey(-1);
	    else {
                if((caret > 0) && (raw[caret - 1] != CY_SEP)) AppendKey('\'');
                len = strlen(ZhuyinPinyin[*newyj].pinyin_key);
                for(i = 0; i < len; i ++) AppendKey(ZhuyinPinyin[*newyj].pinyin_key[i]);
	        if((caret == 0) && (length > caret)) {
	            AppendKey('\'');
	            AppendKey(IMXK_Left);
	        }
	    }
        }
    }
}

VOID Move(CHAR *str, int caret, int length, int dir) {
    JINT i;

    if(dir == 0) {
        for(i = length - 1; i >= caret; i --) str[i + 1] = str[i];
        if(length > 0) str[length + 1] = 0;
    }
    else if(caret > 0){
        for(i = caret; i < length; i ++) str[i - 1] = str[i];
        if(caret < length) str[length - 1] = 0;
    }
}

JINT DeleteYinJie (CHAR *raw, JINT caret, JINT length) {
    JINT i, len = 0;

    while( (caret < length) && !IsTone(raw[caret]) && 
	   (raw[caret] != CY_SEP) ) {
	len += GetCurrentLen(raw, caret, length, 1);
	caret ++;
    }
    return len;
}

VOID SaveLast (JINT nSesID, ImToXSun* toXsunim) {
    JINT i,j;

    if(toXsunim->nCandiStart == 0) dummy[nSesID].nCandiStart = 0;

    dummy[nSesID].nType = toXsunim->nType;
    dummy[nSesID].nErrorCode = toXsunim->nErrorCode;
    dummy[nSesID].nChoiceNum = toXsunim->nChoiceNum;
    dummy[nSesID].nCaretPos = toXsunim->nCaretPos;
    for (i = 0; i < 16; i ++) dummy[nSesID].pwStatus[i] = toXsunim->pwStatus[i];
    for (i = 0; i < 128; i ++) dummy[nSesID].pwPreedit[i] = toXsunim->pwPreedit[i];
    for (i = 0; i < 256; i ++) dummy[nSesID].pwCommit[i] = toXsunim->pwCommit[i];
    for (i = 0; i < 8; i++)
	for (j = 0; j < 24; j++)
	    dummy[nSesID].pwLookupChoice[i][j] = toXsunim->pwLookupChoice[i][j];
    dummy[nSesID].nTotalSingleHzNum = toXsunim->nTotalSingleHzNum;
    dummy[nSesID].nTotalPhraseNum = toXsunim->nTotalPhraseNum;

    if(toXsunim->nType == IMXSUN_TYPE_COMMIT) {
	ZySessions[nSesID].caret = 0;
	ZySessions[nSesID].hz_caret = 0;
	ZySessions[nSesID].length = 0;
	ZySessions[nSesID].hanzi[0] = 0;
    }
}

VOID resetDummy(JINT nSesID) {
    int i,j;

    dummy[nSesID].nType = IMXSUN_TYPE_NORMAL;
    dummy[nSesID].nErrorCode = 0;
    dummy[nSesID].nChoiceNum = 0;
    dummy[nSesID].nCaretPos = 0;
    for (i = 0; i < 16; i ++) dummy[nSesID].pwStatus[i] = 0;
    for (i = 0; i < 128; i ++) dummy[nSesID].pwPreedit[i] = 0;
    for (i = 0; i < 256; i ++) dummy[nSesID].pwCommit[i] = 0;
    for (i = 0; i < 8; i++)
	for (j = 0; j < 24; j++)
	    dummy[nSesID].pwLookupChoice[i][j] = 0;
    dummy[nSesID].nTotalSingleHzNum = 0;
    dummy[nSesID].nTotalPhraseNum = 0;
    dummy[nSesID].nCandiStart = 0;
    dummy[nSesID].nCandiEnd = 0;
    dummy[nSesID].nLastPhrasePageNum = 0;
}

ImToXSun* NewZY_trans(JINT nSesID, JINT nXKey, JINT nAsciiKey, JINT nSpecKeyState) {

    JINT    i, j, len, pos, yj, delyj, delhznum, hznum, shengmu, hzid;
    JINT startbak, endbak;
    ImToXSun* toXsunim;
    static int first = 1;
    CHAR tmp[10], tmp1[10];
    unsigned short *preedit, tmphz;

    if(first) {
        for(i = 0; i < 512; i ++) {
            ZySessions[i].length = 0;
            ZySessions[i].caret = 0;
            ZySessions[i].hz_caret = 0;
            ZySessions[i].hanzi[0] = 0;
	    resetDummy(i);
        }
        first = 0;
    }

    if( (nXKey == '1') && (nSpecKeyState == ALTMASK)) {
	ZySessions[nSesID].caret = 0;
	ZySessions[nSesID].hz_caret = 0;
	ZySessions[nSesID].length = 0;
	ZySessions[nSesID].hanzi[0] = 0;
	resetDummy(nSesID);
	IM_trans(nSesID, IMXK_Escape, IMXK_Escape, 0);
	Mode = (Mode == ZHUYIN_MODE)? PINYIN_MODE : ZHUYIN_MODE; 
	return &(dummy[nSesID]);
    }

    if(Mode == PINYIN_MODE) 
    	return (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);

    if ((nAsciiKey == IMXK_N) && (nSpecKeyState == 5)) {
        nAsciiKey = (JINT)IMXK_bracketright;
        nSpecKeyState = 0;
    }
    else if ((nAsciiKey == IMXK_P) && (nSpecKeyState == 5)) {
        nAsciiKey = (JINT)IMXK_bracketleft;
        nSpecKeyState = 0;
    }

    if ((nAsciiKey >= 0x20) && (nAsciiKey <= 0x7E) && ((nSpecKeyState == 0) || (nSpecKeyState == 1))) {

        if(nAsciiKey == IMXK_bracketright) {
	    /* Fix bug 4837040: CTRL+P freeze desktop in NewZhuYin IM */
	    if (ZySessions[nSesID].length == 0) return(NULL);

	    if((dummy[nSesID].nTotalPhraseNum + dummy[nSesID].nTotalSingleHzNum > 0) && 
		(dummy[nSesID].nCandiEnd + 1 >= dummy[nSesID].nTotalPhraseNum + dummy[nSesID].nTotalSingleHzNum))
		return &dummy[nSesID];

	    if(dummy[nSesID].nCandiEnd == dummy[nSesID].nTotalPhraseNum) {
		dummy[nSesID].nCandiStart = dummy[nSesID].nCandiEnd;
		return ConvertPreeditLookup(nSesID);
	    }
	    else {
		startbak = dummy[nSesID].nCandiStart;
		endbak = dummy[nSesID].nCandiEnd;
		dummy[nSesID].nCandiStart = dummy[nSesID].nCandiEnd + 1;
		ConvertPreeditLookup(nSesID);
		if((dummy[nSesID].nCandiStart == dummy[nSesID].nCandiEnd) &&
		   (dummy[nSesID].nCandiEnd == dummy[nSesID].nTotalPhraseNum + dummy[nSesID].nTotalSingleHzNum)) {
		    dummy[nSesID].nCandiStart = startbak;
		    dummy[nSesID].nCandiEnd = endbak;
		}
		return &(dummy[nSesID]);
	    }
        }

        if(nAsciiKey == IMXK_bracketleft) {
	    /* Fix bug 4837040: CTRL+P freeze desktop in NewZhuYin IM */
	    if (ZySessions[nSesID].length == 0) return(NULL);

/*
	    if((dummy[nSesID].nTotalPhraseNum + dummy[nSesID].nTotalSingleHzNum > 0) && 
		(dummy[nSesID].nCandiStart <= 0))
		return &dummy[nSesID];
*/
	    if (dummy[nSesID].nCandiStart <= 0)
		return &dummy[nSesID];

	    endbak = dummy[nSesID].nCandiEnd;
	    dummy[nSesID].nCandiEnd = dummy[nSesID].nCandiStart - 1;
	    FilterCandiBackward(nSesID, &(dummy[nSesID]), endbak);
	    return &(dummy[nSesID]);
        }

        else if(IsSelectKey(nAsciiKey)) {
/*
printf("Select key = %d nChoiceNum = %d\n", nAsciiKey, dummy[nSesID].nChoiceNum);
*/

	    if(dummy[nSesID].nChoiceNum == 0) {
	        toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	        SaveLast(nSesID, toXsunim);
                return ConvertPreeditLookup(nSesID);
	    }
	    hzid = GetCandidateIndex(nAsciiKey);
	    if((hzid != -1) && (hzid < dummy[nSesID].nChoiceNum)) { 
		JwordCat(ZySessions[nSesID].hanzi, dummy[nSesID].pwLookupChoice[hzid]);
	    }
	    hznum = JwordLen(ZySessions[nSesID].hanzi);
	    
	    toXsunim = (ImToXSun*) CommitCandidate(nSesID, &(dummy[nSesID]), dummy[nSesID].nCandiIndex[hzid]);
/*
printf("toXsunim->nType = %d\n", toXsunim->nType);
*/

	    for(i = 0; (i < ZySessions[nSesID].length) && (hznum > 0); i ++) 
	        if(ZySessions[nSesID].rawstr[i] == CY_SEP) hznum --;
	    if(i > 0)
		ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i - 1;
	    else ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i;

	    if(toXsunim->nType == IMXSUN_TYPE_COMMIT) {
		ZySessions[nSesID].caret = 0;
		ZySessions[nSesID].hz_caret = 0;
		ZySessions[nSesID].length = 0;
		ZySessions[nSesID].hanzi[0] = 0;

		resetDummy(nSesID);
	        return toXsunim;
	    }
	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
        }

	if(IsToneKey(nAsciiKey)) {
	    pos = ZySessions[nSesID].caret;
	    if( (pos == 0) || 
		(IsShengMu(ZySessions[nSesID].rawstr[pos - 1])) ||
		(IsTone(ZySessions[nSesID].rawstr[pos - 1])) ||
		((pos < ZySessions[nSesID].length) && (ZySessions[nSesID].rawstr[pos + 1] == CY_SEP))) {

	        toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	        SaveLast(nSesID, toXsunim);
                return ConvertPreeditLookup(nSesID);
	    }
            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
	    ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] = GetToneIndex(nAsciiKey);
            ZySessions[nSesID].length ++;
            ZySessions[nSesID].caret ++;

	    dummy[nSesID].nCandiStart = dummy[nSesID].nCandiEnd = 0;
	    return ConvertPreeditLookup(nSesID);
	}

        if(nAsciiKey != '\'')
	    for(i = 0; i < 37; i ++)
	        if(nAsciiKey == ZhuyinPinyin[i].zhuyin_key) break;

	if((i == 37) && (nAsciiKey != '\'')) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    SaveLast(nSesID, toXsunim);
            return ConvertPreeditLookup(nSesID);
	}
/*
printf("preedit length = %d\n", ZySessions[nSesID].length);
*/
	if(ZySessions[nSesID].length >= MAXLENGTH) {
	    return &(dummy[nSesID]);
	}

	if((nAsciiKey != '\'') && (ZySessions[nSesID].caret > 0)) {
	    yj = ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1];
	    if(IsShengMu(yj) || IsUpperIUV(yj) || IsIUV(yj)) { 
	        len = DeleteYinJie(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length);
                for(j = 0; j < len; j ++)
                    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
	    }
	    if(ZySessions[nSesID].caret < ZySessions[nSesID].length) {
	        delyj = ZySessions[nSesID].rawstr[ZySessions[nSesID].caret];
	        if(delyj != CY_SEP) {
	            if(IsUpperYi(yj) || IsZCS(yj)) {
                        toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_i, IMXK_i, nSpecKeyState);
                        if(IsZCS(yj)) ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1] += 23;
	            }
	            else if(IsUpperWu(yj) || IsUpperYu(yj)) {
			if( IsUpperYu(yj) && ((delyj == CY_AN) || (delyj == CY_IE)));
                        else toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, IMXK_u, nSpecKeyState);
	            }
	            else if((ZySessions[nSesID].caret < ZySessions[nSesID].length - 1) && (yj == CY_V) && (delyj == CY_IE)) {
	                pos = ZySessions[nSesID].caret + 1;
	                yj = ZySessions[nSesID].rawstr[pos];
	         	if((yj == CY_N) || (yj == CY_L)) {
	             	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
	                    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_v, IMXK_v, nSpecKeyState);
	         	}
	            }
	            else if((ZySessions[nSesID].caret < ZySessions[nSesID].length - 1) && (yj == CY_U) && (delyj == CY_ENG)) {
	                pos = ZySessions[nSesID].caret + 1;
	                yj = ZySessions[nSesID].rawstr[pos];
	         	if(IsJQX(yj)) {
	         	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
			    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, IMXK_u, nSpecKeyState);
	         	}
	            }
	        }
	    }
 
	    for(j = 0; j < 2; j ++) { 
	        if( (ZySessions[nSesID].caret < ZySessions[nSesID].length) && 
	     	    (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] != CY_SEP) ) {
	            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	            ZySessions[nSesID].length --;
	        }
	    }
	}

	if(nAsciiKey == '\'')  ConvertYinJie(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, 
		ZySessions[nSesID].hz_caret, ZySessions[nSesID].length, NULL);
        else {
	    ConvertYinJie(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, 
		ZySessions[nSesID].hz_caret, ZySessions[nSesID].length, &i);
            if(GetKey(0) != -1)
		Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
	}

	if(GetKey(0) == -1) return ConvertPreeditLookup(nSesID);

	if(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] == CY_SEP) 
	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
		
        for(j = 0; j < GetKeySeqLen(); j ++) 
            toXsunim = (ImToXSun*) IM_trans(nSesID, KeySeq[j], KeySeq[j], nSpecKeyState);

	if((ZySessions[nSesID].caret < ZySessions[nSesID].length) && 
	   (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] == CY_SEP)) { 
	    toXsunim = (ImToXSun*) IM_trans(nSesID, '\'', '\'', nSpecKeyState);
	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Left, IMXK_Left, nSpecKeyState);
	}

        pos = ZySessions[nSesID].caret;
            if(GetKey(0) == '\'') { 
            ZySessions[nSesID].rawstr[pos] = CY_SEP;
            pos ++;
            ZySessions[nSesID].length ++;
            ZySessions[nSesID].caret ++;
            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
        }
	if(nAsciiKey != '\'') {
	    ZySessions[nSesID].rawstr[pos] = i;
            ZySessions[nSesID].length ++;
            ZySessions[nSesID].caret ++;
	}
	        
	if ((GetKey(0) != '\'') && (GetKeySeqLen() > 1) && (GetKey(GetKeySeqLen() - 2) == '\'')) {
            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
            ZySessions[nSesID].rawstr[pos + 1] = CY_SEP;
            ZySessions[nSesID].length ++;
	}

	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Delete) {
	if(ZySessions[nSesID].caret == ZySessions[nSesID].length) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
	}

	if(IsTone(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret])) {
	    Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	    ZySessions[nSesID].length --;
	    dummy[nSesID].nCandiStart = dummy[nSesID].nCandiEnd = 0;
            return ConvertPreeditLookup(nSesID);
	}

	pos = ZySessions[nSesID].caret;
	yj = ZySessions[nSesID].rawstr[pos];

	if(yj == CY_SEP) { /* delete separater */
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	    ZySessions[nSesID].length --;
	}

	shengmu = -1;
	yj = ZySessions[nSesID].rawstr[pos];
	if(ZySessions[nSesID].caret < ZySessions[nSesID].length) {
	    if(IsShengMu(yj) || IsUpperIUV(yj) || IsUpperZCS(yj)) {
		len = GetCurrentLen(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
		if(IsUpperIUV(yj) && (ZySessions[nSesID].caret < ZySessions[nSesID].length - 1) && 
		   (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret + 1] != CY_SEP))
		    len --;

        	for(i = 0; i < len; i ++) {
		    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
		}
		if ((ZySessions[nSesID].caret < ZySessions[nSesID].length - 1) && 
		    (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret + 1] != CY_SEP)) shengmu = yj;
		else {
	            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	            ZySessions[nSesID].length --;

		    if((ZySessions[nSesID].length > 0) && (pos == 0) && (ZySessions[nSesID].rawstr[pos] == CY_SEP) ) {
                        toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
		        Move(ZySessions[nSesID].rawstr, pos + 1, ZySessions[nSesID].length, 1);
		        ZySessions[nSesID].length --;
		    }
		    SaveLast(nSesID, toXsunim);
		    return ConvertPreeditLookup(nSesID);
	        }
	    }
	}

	if(shengmu != -1) ZySessions[nSesID].caret ++;

	yj = ZySessions[nSesID].rawstr[ZySessions[nSesID].caret];
	if(ZySessions[nSesID].caret < ZySessions[nSesID].length) {
	    if(yj != CY_SEP) {
		delyj = yj;
	        len = DeleteYinJie(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length);
                for(i = 0; i < len; i ++) {
                    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
		}

	        for(i = 0; i < 2; i ++) { /* delete yiwuyu, yunmu and tone */
	            if( (ZySessions[nSesID].caret < ZySessions[nSesID].length) && 
		        (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] != CY_SEP)) { 
	                Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	                ZySessions[nSesID].length --;
		    }
	 	}

		if(shengmu != -1) {
		    ZySessions[nSesID].caret --;
	            Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	            ZySessions[nSesID].length --;
		}

		pos = ZySessions[nSesID].caret; 
		if((ZySessions[nSesID].length > 0) && (pos == 0) && (ZySessions[nSesID].rawstr[pos] == CY_SEP) ) {
                    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
		    Move(ZySessions[nSesID].rawstr, pos + 1, ZySessions[nSesID].length, 1);
		    ZySessions[nSesID].length --;
		}

		if( ZySessions[nSesID].caret > 0 ) {
		    pos = ZySessions[nSesID].caret - 1;
		    yj = ZySessions[nSesID].rawstr[pos];
	    	    if(IsUpperYi(yj) || IsZCS(yj)) {
                	toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_i, nAsciiKey, nSpecKeyState);
                	if(IsZCS(yj)) ZySessions[nSesID].rawstr[pos] += 23;
	    	    }
	    	    else if(IsUpperWu(yj) || IsUpperYu(yj)) {
			if( IsUpperYu(yj) && ((delyj == CY_AN) || (delyj == CY_IE)));
                	else toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, nAsciiKey, nSpecKeyState);
	    	    }
	    	    else if((ZySessions[nSesID].caret > 1) && (yj == CY_V) && (delyj == CY_IE)) {
	        	pos = ZySessions[nSesID].caret - 2;
	        	yj = ZySessions[nSesID].rawstr[pos];
			if((yj == CY_N) || (yj == CY_L)) {
		    	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
		    	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_v, nAsciiKey, nSpecKeyState);
		        }
	    	    }
	    	    else if((ZySessions[nSesID].caret > 1) && (yj == CY_U) && (delyj == CY_ENG)) {
	        	pos = ZySessions[nSesID].caret - 2;
	        	yj = ZySessions[nSesID].rawstr[pos];
			toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
			toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, nAsciiKey, nSpecKeyState);
	    	    }
		}
	    }
	}

	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_BackSpace) {
	if((ZySessions[nSesID].caret == 0) || (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1] == CY_SEP)){
	    if(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1] == CY_SEP) {
		Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
		ZySessions[nSesID].caret --;
		ZySessions[nSesID].length --;
	    }
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
	}   

	if(ZySessions[nSesID].hz_caret == ZySessions[nSesID].caret) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    preedit = (unsigned short *)toXsunim->pwPreedit;
	    hznum = 0;
	    delhznum = 0;
	    while(*preedit > 0xa140) {
	        hznum ++;
	        preedit ++;
	    }

	    if(hznum > 0) {
		tmphz = *(preedit - 1);
		preedit = ZySessions[nSesID].hanzi;
		preedit += JwordLen(ZySessions[nSesID].hanzi) - 1 ;
		
		while((preedit >= ZySessions[nSesID].hanzi) && (*preedit != tmphz)) {
		    preedit --;
		    delhznum ++;
		}
	    }
	    else delhznum = JwordLen(ZySessions[nSesID].hanzi);
	    hznum = JwordLen(ZySessions[nSesID].hanzi) - delhznum;
	    ZySessions[nSesID].hanzi[hznum] = 0;
	    
	    for(i = 0; (i < ZySessions[nSesID].length) && (hznum > 0); i ++) 
	        if(ZySessions[nSesID].rawstr[i] == CY_SEP) hznum --;
	    if(i > 0) ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i - 1;
	    else ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i;

	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
        }

	if(IsTone(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1])) {
	    Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
	    ZySessions[nSesID].caret --;
	    ZySessions[nSesID].length --;
	    dummy[nSesID].nCandiStart = dummy[nSesID].nCandiEnd = 0;
	    return ConvertPreeditLookup(nSesID);
	}


	delyj = ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1];

	if(IsShengMu(delyj) || IsUpperIUV(delyj) || IsIUV(delyj)) { 
	    len = DeleteYinJie(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length);
            for(i = 0; i < len; i ++)
                toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
	}

	len = GetCurrentLen(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
        for(i = 0; i < len; i ++)
            toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);

	for(i = 0; i < 2; i ++) { /* delete yunmu */
	    if( (ZySessions[nSesID].caret < ZySessions[nSesID].length) && 
		(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] != CY_SEP) ) {
	        Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	        ZySessions[nSesID].length --;
	    }
	}

        Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
	ZySessions[nSesID].caret --;
	ZySessions[nSesID].length --;

	if( (ZySessions[nSesID].caret == 0) &&
	    (ZySessions[nSesID].length > 0) &&
	    (ZySessions[nSesID].rawstr[0] == CY_SEP) ) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Delete, IMXK_Delete, nSpecKeyState);
	    Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret + 1, ZySessions[nSesID].length, 1);
	    ZySessions[nSesID].length --;
	}
	else if(ZySessions[nSesID].caret > 0) {
	    pos = ZySessions[nSesID].caret - 1;
	    yj = ZySessions[nSesID].rawstr[pos];
	    if(yj == CY_SEP) {
		if(ZySessions[nSesID].caret < ZySessions[nSesID].length) 
	  	    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_Left, IMXK_Left, nSpecKeyState); 
		else (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);

        	Move(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
		ZySessions[nSesID].caret --;
		ZySessions[nSesID].length --;
	    }
	    else if(IsUpperYi(yj) || IsZCS(yj)) {
                toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_i, nAsciiKey, nSpecKeyState);
                if(IsZCS(yj)) ZySessions[nSesID].rawstr[pos] += 23;
	    }
	    else if(IsUpperWu(yj) || IsUpperYu(yj)) {
		if( IsUpperYu(yj) && ((delyj == CY_AN) || (delyj == CY_IE)));
                else toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, nAsciiKey, nSpecKeyState);
	    }
	    else if((ZySessions[nSesID].caret > 1) && (yj == CY_V) && (delyj == CY_IE)) {
	        pos = ZySessions[nSesID].caret - 2;
	        yj = ZySessions[nSesID].rawstr[pos];
		if((yj == CY_N) || (yj == CY_L)) {
		    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
		    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_v, nAsciiKey, nSpecKeyState);
		}
	    }
	    else if((ZySessions[nSesID].caret > 1) && (yj == CY_U) && (delyj == CY_ENG)) {
	        pos = ZySessions[nSesID].caret - 2;
	        yj = ZySessions[nSesID].rawstr[pos];
/*
		if(IsJQX(yj)) {
		    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
		    toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, nAsciiKey, nSpecKeyState);
		}
*/
		toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_BackSpace, IMXK_BackSpace,nSpecKeyState);
		toXsunim = (ImToXSun*) IM_trans(nSesID, IMXK_u, nAsciiKey, nSpecKeyState);
	    }
	}
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Right) {
	if((ZySessions[nSesID].caret == ZySessions[nSesID].length) || 
	   ((ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] == CY_SEP) &&
	    (ZySessions[nSesID].caret == ZySessions[nSesID].length - 1))){
	    if((ZySessions[nSesID].rawstr[ZySessions[nSesID].caret] == CY_SEP) && 
	      (ZySessions[nSesID].caret == ZySessions[nSesID].length - 1)){
		ZySessions[nSesID].caret ++;
	    }
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
	}

	else if(IsTone(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret])) {
	    ZySessions[nSesID].caret ++;
	    return ConvertPreeditLookup(nSesID);
	}

	pos = ZySessions[nSesID].caret;
	yj = ZySessions[nSesID].rawstr[pos];
	if(yj == CY_SEP) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    ZySessions[nSesID].caret ++;
	}
	if(ZySessions[nSesID].caret < ZySessions[nSesID].length) {
	    len = GetCurrentLen(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 1);
            for(i = 0; i < len; i ++)
        	toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    ZySessions[nSesID].caret ++;
	}
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Left) {
	if((ZySessions[nSesID].caret == 0) || (ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1] == CY_SEP)){
	    if(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1] == CY_SEP) {
		ZySessions[nSesID].caret --;
	    }
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
	}

	if(ZySessions[nSesID].hz_caret == ZySessions[nSesID].caret) {
	    toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	    
	    preedit = toXsunim->pwPreedit;
	    hznum = 0;
	    delhznum = 0;
	    while(*preedit > 0xa140) {
	        hznum ++;
	        preedit ++;
	    }
	    if(hznum > 0) {
	        tmphz = *(preedit - 1);
	        preedit = ZySessions[nSesID].hanzi;
	        preedit += JwordLen(ZySessions[nSesID].hanzi) - 1 ;

	        while((preedit >= ZySessions[nSesID].hanzi) && (*preedit != tmphz)) {
		    preedit --;
		    delhznum ++;
	        }
	    }
	    else delhznum = JwordLen(ZySessions[nSesID].hanzi);
	    hznum = JwordLen(ZySessions[nSesID].hanzi) - delhznum;
	    ZySessions[nSesID].hanzi[hznum] = 0;

	    for(i = 0; (i < ZySessions[nSesID].length) && (hznum > 0); i ++) 
	        if(ZySessions[nSesID].rawstr[i] == CY_SEP) hznum --;
	    if(i > 0) ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i - 1;
	    else ZySessions[nSesID].caret = ZySessions[nSesID].hz_caret = i;

	    SaveLast(nSesID, toXsunim);
	    return ConvertPreeditLookup(nSesID);
        }

	if(IsTone(ZySessions[nSesID].rawstr[ZySessions[nSesID].caret - 1])) {
	    ZySessions[nSesID].caret --;
	    return ConvertPreeditLookup(nSesID);
	}

	len = GetCurrentLen(ZySessions[nSesID].rawstr, ZySessions[nSesID].caret, ZySessions[nSesID].length, 0);
        for(i = 0; i < len; i ++)
            toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);

	ZySessions[nSesID].caret --;

	if(ZySessions[nSesID].caret > 0) {
	    pos = ZySessions[nSesID].caret - 1;
	    yj = ZySessions[nSesID].rawstr[pos];
	    if(yj == CY_SEP) {
		toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
		ZySessions[nSesID].caret --;
	    }
	}
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Home) {
        toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
        ZySessions[nSesID].caret = 0;
        ZySessions[nSesID].hz_caret = 0;
        ZySessions[nSesID].hanzi[0] = 0;
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_End) {
        toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
        ZySessions[nSesID].caret = ZySessions[nSesID].length;
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Escape) {
        ZySessions[nSesID].caret = 0;
        ZySessions[nSesID].hz_caret = 0;
        ZySessions[nSesID].hanzi[0] = 0;
        ZySessions[nSesID].length = 0;
        toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	SaveLast(nSesID, toXsunim);
        return ConvertPreeditLookup(nSesID);
    }

    else if(nXKey == IMXK_Return) {
	toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	dummy[nSesID].nCandiStart = toXsunim->nCandiStart;
	SaveLast(nSesID, toXsunim);
	return ConvertPreeditLookup(nSesID);
    }

    else {
	toXsunim = (ImToXSun*) IM_trans(nSesID, nXKey, nAsciiKey, nSpecKeyState);
	SaveLast(nSesID, toXsunim);
	return ConvertPreeditLookup(nSesID);
    }
}

VOID NewZY_close (JINT nSesID) {
        ZySessions[nSesID].caret = 0;
        ZySessions[nSesID].hz_caret = 0;
        ZySessions[nSesID].hanzi[0] = 0;
        ZySessions[nSesID].length = 0;
        IM_close(nSesID);
}

JINT IsSelectKey(JINT k) {
        if( (k == IMXK_space) ||
	    (k == IMXK_A) || 
            (k == IMXK_B) || 
            (k == IMXK_C) ||   
            (k == IMXK_D) ||
            (k == IMXK_E) ||   
            (k == IMXK_F) || 
            (k == IMXK_G) ||
            (k == IMXK_H) || 
            (k == IMXK_I) ) 
	    return TRUE;
	else return FALSE;
}

JINT IsToneKey(JINT k) {
	if( (k == IMXK_6) ||
	    (k == IMXK_3) ||
	    (k == IMXK_4) ||
	    (k == IMXK_7) )
	    return TRUE;
	else return FALSE;
}

JINT GetToneIndex(JINT k) {
	if (k == IMXK_space) return CY_TONE1;
	else if (k == IMXK_6) return CY_TONE2;
	else if (k == IMXK_3) return CY_TONE3;
	else if (k == IMXK_4) return CY_TONE4;
	else if (k == IMXK_7) return CY_TONE5;
	else return -1;
}

JINT GetCandidateIndex(JINT k) {
    if (k == IMXK_space) return 0;
    else if (k == IMXK_A) return 0;
    else if(k == IMXK_B) return 1;
    else if(k == IMXK_C) return 2;
    else if(k == IMXK_D) return 3;
    else if(k == IMXK_E) return 4;
    else if(k == IMXK_F) return 5;
    else if(k == IMXK_G) return 6;
    else return -1;
}

ImToXSun* ConvertPreeditLookup(JINT nSesID) {
    JINT i, start, hznum, yj, yjnum = 0, caretyjnum = 0, len;
    JINT low, hi;
    JWORD *preedit, temp[256], tone[2] = {32, 0}, space[2] = { 32, 0 };
    CHAR  *raw;

    hznum = JwordLen(ZySessions[nSesID].hanzi);
    JwordCopy(temp, ZySessions[nSesID].hanzi);
    start = (hznum > 0) ? ZySessions[nSesID].hz_caret : 0;
/*
    for(i = 0; i < hznum; i ++) {
	printf("tone = %d ", GetTone(temp[i]));
    }
    printf("\n");
*/

    GetPreeditTones(ZySessions[nSesID].rawstr, ZySessions[nSesID].hz_caret, ZySessions[nSesID].length);
    FilterCandiForward(nSesID, &(dummy[nSesID]));

    raw = ZySessions[nSesID].rawstr;
    for(i = start; i < ZySessions[nSesID].length; i ++) {
	yj = ZySessions[nSesID].rawstr[i];
	if(yj == CY_SEP) {
	    JwordCat(temp, space);
	    yjnum ++;
	}
	else if(IsTone(yj)) {
	    tone[0] = GetToneSymbol(yj);
	    JwordCat(temp, tone);
	}
	else {
	    len = JwordLen(temp);
	    if( (i > 0) && (yj == CY_U) && IsJQX(ZySessions[nSesID].rawstr[i - 1]) ) {
	        hi = ZhuyinPinyin[yj + 1].zhuyin_str[0] & 0xff;
	        low =ZhuyinPinyin[yj + 1].zhuyin_str[1] & 0xff;
	    }
	    else {
	        hi = ZhuyinPinyin[yj].zhuyin_str[0] & 0xff;
	        low =ZhuyinPinyin[yj].zhuyin_str[1] & 0xff;
	    }
	    temp[len] = ((hi << 8) & 0xff00) + low;
	    temp[len + 1] = 0;
	}
    }

    JwordCopy(dummy[nSesID].pwPreedit, temp);
    if(hznum > 0) 
	dummy[nSesID].nCaretPos = hznum + ZySessions[nSesID].caret - ZySessions[nSesID].hz_caret;
    else dummy[nSesID].nCaretPos = ZySessions[nSesID].caret;
/*
printf("\npreedit :");
for(i = 0; i < JwordLen(dummy[nSesID].pwPreedit); i ++) {
    printf("%x ", dummy[nSesID].pwPreedit[i]);
}
printf("\n");

for(i = 0; i < ZySessions[nSesID].length; i ++) {
    printf("%d ", ZySessions[nSesID].rawstr[i]); 
}
printf("\n");
*/

    return &(dummy[nSesID]);
}

