/*
 * Copyright (C) 2003   Choe Hwanjin <krisna@kldp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

static const UTFCHAR keyboard_map_2[] = {
    0x0021,     /* XK_exclam:       exclamation mark               */
    0x0022,     /* XK_quotedbl:     quotation mark                 */
    0x0023,     /* XK_numbersign:   number sign                    */
    0x0024,     /* XK_dollar:       dollar sign                    */
    0x0025,     /* XK_percent:      percent sign                   */
    0x0026,     /* XK_ampersand:    ampersand                      */
    0x0027,     /* XK_apostrophe:   apostrophe                     */
    0x0028,     /* XK_parenleft:    left parenthesis               */
    0x0029,     /* XK_parenright:   right parenthesis              */
    0x002a,     /* XK_asterisk:     asterisk                       */
    0x002b,     /* XK_plus:         plus sign                      */
    0x002c,     /* XK_comma:        comma                          */
    0x002d,     /* XK_minus:        minus sign                     */
    0x002e,     /* XK_period:       period                         */
    0x002f,     /* XK_slash:        slash                          */
    0x0030,     /* XK_0:            0                              */
    0x0031,     /* XK_1:            1                              */
    0x0032,     /* XK_2:            2                              */
    0x0033,     /* XK_3:            3                              */
    0x0034,     /* XK_4:            4                              */
    0x0035,     /* XK_5:            5                              */
    0x0036,     /* XK_6:            6                              */
    0x0037,     /* XK_7:            7                              */
    0x0038,     /* XK_8:            8                              */
    0x0039,     /* XK_9:            9                              */
    0x003a,     /* XK_colon:        colon                          */
    0x003b,     /* XK_semicolon:    semicolon                      */
    0x003c,     /* XK_less:         less-than sign                 */
    0x003d,     /* XK_equal:        equals sign                    */
    0x003e,     /* XK_greater:      greater-than sign              */
    0x003f,     /* XK_question:     question mark                  */
    0x0040,     /* XK_at:           commercial at                  */
    0x1106,     /* XK_A:            choseong mieum                 */
    0x1172,     /* XK_B:            jungseong yu                   */
    0x110e,     /* XK_C:            choseong chieuch               */
    0x110b,     /* XK_D:            choseong ieung                 */
    0x1104,     /* XK_E:            choseong ssangtikeut           */
    0x1105,     /* XK_F:            choseong rieul                 */
    0x1112,     /* XK_G:            choseong hieuh                 */
    0x1169,     /* XK_H:            jungseong o                    */
    0x1163,     /* XK_I:            jungseong ya                   */
    0x1165,     /* XK_J:            jungseong eo                   */
    0x1161,     /* XK_K:            jungseong a                    */
    0x1175,     /* XK_L:            jungseong i                    */
    0x1173,     /* XK_M:            jungseong eu                   */
    0x116e,     /* XK_N:            jungseong u                    */
    0x1164,     /* XK_O:            jungseong yae                  */
    0x1168,     /* XK_P:            jungseong ye                   */
    0x1108,     /* XK_Q:            choseong ssangpieup            */
    0x1101,     /* XK_R:            choseong ssangkiyeok           */
    0x1102,     /* XK_S:            choseong nieun                 */
    0x110a,     /* XK_T:            choseong ssangsios             */
    0x1167,     /* XK_U:            jungseong yeo                  */
    0x1111,     /* XK_V:            choseong phieuph               */
    0x110d,     /* XK_W:            choseong ssangcieuc            */
    0x1110,     /* XK_X:            choseong thieuth               */
    0x116d,     /* XK_Y:            jungseong yo                   */
    0x110f,     /* XK_Z:            choseong khieukh               */
    0x005b,     /* XK_bracketleft:  left bracket                   */
    0x005c,     /* XK_backslash:    backslash                      */
    0x005d,     /* XK_bracketright: right bracket                  */
    0x005e,     /* XK_asciicircum:  circumflex accent              */
    0x005f,     /* XK_underscore:   underscore                     */
    0x0060,     /* XK_quoteleft:    grave accent                   */
    0x1106,     /* XK_a:            choseong  mieum                */
    0x1172,     /* XK_b:            jungseong yu                   */
    0x110e,     /* XK_c:            choseong  chieuch              */
    0x110b,     /* XK_d:            choseong  ieung                */
    0x1103,     /* XK_e:            choseong  tikeut               */
    0x1105,     /* XK_f:            choseong  rieul                */
    0x1112,     /* XK_g:            choseong  hieuh                */
    0x1169,     /* XK_h:            jungseong o                    */
    0x1163,     /* XK_i:            jungseong ya                   */
    0x1165,     /* XK_j:            jungseong eo                   */
    0x1161,     /* XK_k:            jungseong a                    */
    0x1175,     /* XK_l:            jungseong i                    */
    0x1173,     /* XK_m:            jungseong eu                   */
    0x116e,     /* XK_n:            jungseong u                    */
    0x1162,     /* XK_o:            jungseong ae                   */
    0x1166,     /* XK_p:            jungseong e                    */
    0x1107,     /* XK_q:            choseong  pieup                */
    0x1100,     /* XK_r:            choseong  kiyeok               */
    0x1102,     /* XK_s:            choseong  nieun                */
    0x1109,     /* XK_t:            choseong  sios                 */
    0x1167,     /* XK_u:            jungseong yeo                  */
    0x1111,     /* XK_v:            choseong  phieuph              */
    0x110c,     /* XK_w:            choseong  cieuc                */
    0x1110,     /* XK_x:            choseong  thieuth              */
    0x116d,     /* XK_y:            jungseong yo                   */
    0x110f,     /* XK_z:            choseong  khieukh              */
    0x007b,     /* XK_braceleft:    left brace                     */
    0x007c,     /* XK_bar:          vertical bar                   */
    0x007d,     /* XK_braceright:   right brace                    */
    0x007e      /* XK_asciitilde:   tilde                          */
};

static const UTFCHAR keyboard_map_32[] = {
    0x0021,     /* XK_exclam:       exclamation mark                */
    0x0022,     /* XK_quotedbl:     quotation mark                  */
    0x0023,     /* XK_numbersign:   number sign                     */
    0x0024,     /* XK_dollar:       dollar sign                     */
    0x0025,     /* XK_percent:      percent sign                    */
    0x0026,     /* XK_ampersand:    ampersand                       */
    0x0027,     /* XK_apostrophe:   apostrophe                      */
    0x0028,     /* XK_parenleft:    left parenthesis                */
    0x0029,     /* XK_parenright:   right parenthesis               */
    0x002a,     /* XK_asterisk:     asterisk                        */
    0x002b,     /* XK_plus:         plus sign                       */
    0x002c,     /* XK_comma:        comma                           */
    0x002d,     /* XK_minus:        minus sign                      */
    0x002e,     /* XK_period:       period                          */
    0x002f,     /* XK_slash:        slash                           */
    0x0030,     /* XK_0:            0                               */
    0x0031,     /* XK_1:            1                               */
    0x0032,     /* XK_2:            2                               */
    0x0033,     /* XK_3:            3                               */
    0x0034,     /* XK_4:            4                               */
    0x0035,     /* XK_5:            5                               */
    0x0036,     /* XK_6:            6                               */
    0x0037,     /* XK_7:            7                               */
    0x0038,     /* XK_8:            8                               */
    0x0039,     /* XK_9:            9                               */
    0x003a,     /* XK_colon:        colon                           */
    0x003b,     /* XK_semicolon:    semicolon                       */
    0x003c,     /* XK_less:         less-than sign                  */
    0x003d,     /* XK_equal:        equals sign                     */
    0x003e,     /* XK_greater:      greater-than sign               */
    0x003f,     /* XK_question:     question mark                   */
    0x0040,     /* XK_at:           commercial at                   */
    0x11b7,     /* XK_A:            jongseong mieum                 */
    0x1172,     /* XK_B:            jungseong yu                    */
    0x11be,     /* XK_C:            jongseong chieuch               */
    0x11bc,     /* XK_D:            jongseong ieung                 */
    0x11ae,     /* XK_E:            jongseong tikeut                */
    0x11af,     /* XK_F:            jongseong rieul                 */
    0x11c2,     /* XK_G:            jongseong hieuh                 */
    0x1169,     /* XK_H:            jungseong o                     */
    0x1163,     /* XK_I:            jungseong ya                    */
    0x1165,     /* XK_J:            jungseong eo                    */
    0x1161,     /* XK_K:            jungseong a                     */
    0x1175,     /* XK_L:            jungseong i                     */
    0x1173,     /* XK_M:            jungseong eu                    */
    0x116e,     /* XK_N:            jungseong u                     */
    0x1164,     /* XK_O:            jungseong yae                   */
    0x1168,     /* XK_P:            jungseong ye                    */
    0x11b8,     /* XK_Q:            jongseong pieup                 */
    0x11a8,     /* XK_R:            jongseong kiyeok                */
    0x11ab,     /* XK_S:            jongseong nieun                 */
    0x11ba,     /* XK_T:            jongseong sios                  */
    0x1167,     /* XK_U:            jungseong yeo                   */
    0x11c1,     /* XK_V:            jongseong phieuph               */
    0x11bd,     /* XK_W:            jongseong cieuc                 */
    0x11c0,     /* XK_X:            jongseong thieuth               */
    0x116d,     /* XK_Y:            jungseong yo                    */
    0x11bf,     /* XK_Z:            jongseong khieukh               */
    0x005b,     /* XK_bracketleft:  left bracket                    */
    0x005c,     /* XK_backslash:    backslash                       */
    0x005d,     /* XK_bracketright: right bracket                   */
    0x005e,     /* XK_asciicircum:  circumflex accent               */
    0x005f,     /* XK_underscore:   underscore                      */
    0x0060,     /* XK_quoteleft:    grave accent                    */
    0x1106,     /* XK_a:            choseong  mieum                 */
    0x1172,     /* XK_b:            jungseong yu                    */
    0x110e,     /* XK_c:            choseong  chieuch               */
    0x110b,     /* XK_d:            choseong  ieung                 */
    0x1103,     /* XK_e:            choseong  tikeut                */
    0x1105,     /* XK_f:            choseong  rieul                 */
    0x1112,     /* XK_g:            choseong  hieuh                 */
    0x1169,     /* XK_h:            jungseong o                     */
    0x1163,     /* XK_i:            jungseong ya                    */
    0x1165,     /* XK_j:            jungseong eo                    */
    0x1161,     /* XK_k:            jungseong a                     */
    0x1175,     /* XK_l:            jungseong i                     */
    0x1173,     /* XK_m:            jungseong eu                    */
    0x116e,     /* XK_n:            jungseong u                     */
    0x1162,     /* XK_o:            jungseong ae                    */
    0x1166,     /* XK_p:            jungseong e                     */
    0x1107,     /* XK_q:            choseong  pieup                 */
    0x1100,     /* XK_r:            choseong  kiyeok                */
    0x1102,     /* XK_s:            choseong  nieun                 */
    0x1109,     /* XK_t:            choseong  sios                  */
    0x1167,     /* XK_u:            jungseong yeo                   */
    0x1111,     /* XK_v:            choseong  phieuph               */
    0x110c,     /* XK_w:            choseong  cieuc                 */
    0x1110,     /* XK_x:            choseong  thieuth               */
    0x116d,     /* XK_y:            jungseong yo                    */
    0x110f,     /* XK_z:            choseong  khieukh               */
    0x007b,     /* XK_braceleft:    left brace                      */
    0x007c,     /* XK_bar:          vertical bar                    */
    0x007d,     /* XK_braceright:   right brace                     */
    0x007e,     /* XK_asciitilde:   tilde                           */
};

/* Hangul keyboard map table:
 * 3set keyboard 390 (sebulsik 390) */
static const UTFCHAR keyboard_map_390[] = {
    0x11bd,     /* XK_exclam:       jongseong cieuc                 */
    0x0022,     /* XK_quotedbl:     quotatioin mark                 */
    0x0023,     /* XK_numbersign:   number sign                     */
    0x0024,     /* XK_dollar:       dollar sign                     */
    0x0025,     /* XK_percent:      percent sign                    */
    0x0026,     /* XK_ampersand:    ampersand                       */
    0x1110,     /* XK_apostrophe:   choseong thieuth                */
    0x0028,     /* XK_parenleft:    left parenthesis                */
    0x0029,     /* XK_parenright:   right parenthesis               */
    0x002a,     /* XK_asterisk:     asterisk                        */
    0x002b,     /* XK_plus:         plus sign                       */
    0x002c,     /* XK_comma:        comma                           */
    0x002d,     /* XK_minus:        minus sign                      */
    0x002e,     /* XK_period:       period                          */
    0x1169,     /* XK_slash:        jungseong o                     */
    0x110f,     /* XK_0:            choseong  khieukh               */
    0x11c2,     /* XK_1:            jongseong hieuh                 */
    0x11bb,     /* XK_2:            jongseong ssangsios             */
    0x11b8,     /* XK_3:            jongseong pieup                 */
    0x116d,     /* XK_4:            jungseong yo                    */
    0x1172,     /* XK_5:            jungseong yu                    */
    0x1163,     /* XK_6:            jungseong ya                    */
    0x1168,     /* XK_7:            jungseong ye                    */
    0x1174,     /* XK_8:            jungseong yi                    */
    0x116e,     /* XK_9:            jungseong u                     */
    0x003a,     /* XK_colon:        colon                           */
    0x1107,     /* XK_semicolon:    choseong  pieup                 */
    0x0032,     /* XK_less:         2                               */
    0x003d,     /* XK_equal:        euals sign                      */
    0x0033,     /* XK_greater:      3                               */
    0x003f,     /* XK_question:     question mark                   */
    0x0040,     /* XK_at:           commertial at                   */
    0x11ae,     /* XK_A:            jongseong tikeut                */
    0x0021,     /* XK_B:            exclamation mark                */
    0x11b1,     /* XK_C:            jongseong rieul-mieum           */
    0x11b0,     /* XK_D:            jongseong rieul-kiyeok          */
    0x11bf,     /* XK_E:            jongseong khieukh               */
    0x11a9,     /* XK_F:            jongseong ssangkiyeok           */
    0x002f,     /* XK_G:            slash                           */
    0x0027,     /* XK_H:            apostrophe                      */
    0x0038,     /* XK_I:            8                               */
    0x0034,     /* XK_J:            4                               */
    0x0035,     /* XK_K:            5                               */
    0x0036,     /* XK_L:            6                               */
    0x0031,     /* XK_M:            1                               */
    0x0030,     /* XK_N:            0                               */
    0x0039,     /* XK_O:            9                               */
    0x003e,     /* XK_P:            greater-than sign               */
    0x11c1,     /* XK_Q:            jongseong phieuph               */
    0x1164,     /* XK_R:            jungseong yae                   */
    0x11ad,     /* XK_S:            jongseong nieun-hieuh           */
    0x003b,     /* XK_T:            semicolon                       */
    0x0037,     /* XK_U:            7                               */
    0x11b6,     /* XK_V:            jongseong rieul-hieuh           */
    0x11c0,     /* XK_W:            jongseong thikeuth              */
    0x11b9,     /* XK_X:            jongseong pieup-sios            */
    0x003c,     /* XK_Y:            less-than sign                  */
    0x11be,     /* XK_Z:            jongseong chieuch               */
    0x005b,     /* XK_bracketleft:  left bracket                    */
    0x005c,     /* XK_backslash:    backslash                       */
    0x005d,     /* XK_bracketright: right bracket                   */
    0x005e,     /* XK_asciicircum:  circumflex accent               */
    0x005f,     /* XK_underscore:   underscore                      */
    0x0060,     /* XK_quoteleft:    grave accent                    */
    0x11bc,     /* XK_a:            jongseong ieung                 */
    0x116e,     /* XK_b:            jungseong u                     */
    0x1166,     /* XK_c:            jungseong e                     */
    0x1175,     /* XK_d:            jungseong i                     */
    0x1167,     /* XK_e:            jungseong yeo                   */
    0x1161,     /* XK_f:            jungseong a                     */
    0x1173,     /* XK_g:            jungseong eu                    */
    0x1102,     /* XK_h:            choseong  nieun                 */
    0x1106,     /* XK_i:            choseong  mieum                 */
    0x110b,     /* XK_j:            choseong  ieung                 */
    0x1100,     /* XK_k:            choseong  kiyeok                */
    0x110c,     /* XK_l:            choseong  cieuc                 */
    0x1112,     /* XK_m:            choseong  hieuh                 */
    0x1109,     /* XK_n:            choseong  sios                  */
    0x110e,     /* XK_o:            choseong  chieuch               */
    0x1111,     /* XK_p:            choseong  phieuph               */
    0x11ba,     /* XK_q:            jongseong sios                  */
    0x1162,     /* XK_r:            jungseong ae                    */
    0x11ab,     /* XK_s:            jongseong nieun                 */
    0x1165,     /* XK_t:            jungseong eo                    */
    0x1103,     /* XK_u:            choseong  tikeut                */
    0x1169,     /* XK_v:            jungseong o                     */
    0x11af,     /* XK_w:            jongseong rieul                 */
    0x11a8,     /* XK_x:            jongseong kiyeok                */
    0x1105,     /* XK_y:            choseong  rieul                 */
    0x11b7,     /* XK_z:            jongseong mieum                 */
    0x007b,     /* XK_braceleft:    left brace                      */
    0x007c,     /* XK_bar:          vertical line(bar)              */
    0x007d,     /* XK_braceright:   right brace                     */
    0x007e,     /* XK_asciitilde:   tilde                           */
};

/* Hangul keyboard map table:
 * 3set keyboard final (sebulsik choejong) */
static const UTFCHAR keyboard_map_3final[] = {
    0x11a9,     /* XK_exclam:       jongseong ssangkiyeok           */
    0x00b7,     /* XK_quotedbl:     middle dot                      */
    0x11bd,     /* XK_numbersign:   jognseong cieuc                 */
    0x11b5,     /* XK_dollar:       jongseong rieul-phieuph         */
    0x11b4,     /* XK_percent:      jongseong rieul-thieuth         */
    0x201c,     /* XK_ampersand:    left double quotation mark      */
    0x1110,     /* XK_apostrophe:   choseong  thieuth               */
    0x0027,     /* XK_parenleft:    apostrophe                      */
    0x007e,     /* XK_parenright:   Tilde                           */
    0x201d,     /* XK_asterisk:     right double quotation mark     */
    0x002b,     /* XK_plus:         plus sign                       */
    0x002c,     /* XK_comma:        comma                           */
    0x0029,     /* XK_minus:        right parenthesis               */
    0x002e,     /* XK_period:       period                          */
    0x1169,     /* XK_slash:        jungseong o                     */
    0x110f,     /* XK_0:            choseong  khieukh               */
    0x11c2,     /* XK_1:            jongseong hieuh                 */
    0x11bb,     /* XK_2:            jongseong ssangsios             */
    0x11b8,     /* XK_3:            jongseong pieup                 */
    0x116d,     /* XK_4:            jungseong yo                    */
    0x1172,     /* XK_5:            jungseong yu                    */
    0x1163,     /* XK_6:            jungseong ya                    */
    0x1168,     /* XK_7:            jungseong ye                    */
    0x1174,     /* XK_8:            jungseong yi                    */
    0x116e,     /* XK_9:            jungseong u                     */
    0x0034,     /* XK_colon:        4                               */
    0x1107,     /* XK_semicolon:    choseong  pieup                 */
    0x002c,     /* XK_less:         comma                           */
    0x003e,     /* XK_equal:        greater-than sign               */
    0x002e,     /* XK_greater:      period                          */
    0x0021,     /* XK_question:     exclamation mark                */
    0x11b0,     /* XK_at:           jongseong rieul-kiyeok          */
    0x11ae,     /* XK_A:            jongseong tikeut                */
    0x003f,     /* XK_B:            question mark                   */
    0x11bf,     /* XK_C:            jongseong khieukh               */
    0x11b2,     /* XK_D:            jongseong rieul-pieup           */
    0x11ac,     /* XK_E:            jongseong nieun-cieuc           */
    0x11b1,     /* XK_F:            jongseong rieul-mieum           */
    0x1164,     /* XK_G:            jungseong yae                   */
    0x0030,     /* XK_H:            0                               */
    0x0037,     /* XK_I:            7                               */
    0x0031,     /* XK_J:            1                               */
    0x0032,     /* XK_K:            2                               */
    0x0033,     /* XK_L:            3                               */
    0x0022,     /* XK_M:            double quotation mark           */
    0x002d,     /* XK_N:            minus sign                      */
    0x0038,     /* XK_O:            8                               */
    0x0039,     /* XK_P:            9                               */
    0x11c1,     /* XK_Q:            jongseong phieuph               */
    0x11b6,     /* XK_R:            jongseong rieul-hieuh           */
    0x11ad,     /* XK_S:            jongseong nieun-hieuh           */
    0x11b3,     /* XK_T:            jongseong rieul-sios            */
    0x0036,     /* XK_U:            6                               */
    0x11aa,     /* XK_V:            jongseong kiyeok-sios           */
    0x11c0,     /* XK_W:            jongseong thikeuth              */
    0x11b9,     /* XK_X:            jongseong pieup-sios            */
    0x0035,     /* XK_Y:            5                               */
    0x11be,     /* XK_Z:            jongseong chieuch               */
    0x0028,     /* XK_bracketleft:  left parenthesis                */
    0x003a,     /* XK_backslash:    colon                           */
    0x003c,     /* XK_bracketright: less-than sign                  */
    0x003d,     /* XK_asciicircum:  equals sign                     */
    0x003b,     /* XK_underscore:   semicolon                       */
    0x002a,     /* XK_quoteleft:    asterisk                        */
    0x11bc,     /* XK_a:            jongseong ieung                 */
    0x116e,     /* XK_b:            jungseong u                     */
    0x1166,     /* XK_c:            jungseong e                     */
    0x1175,     /* XK_d:            jungseong i                     */
    0x1167,     /* XK_e:            jungseong yeo                   */
    0x1161,     /* XK_f:            jungseong a                     */
    0x1173,     /* XK_g:            jungseong eu                    */
    0x1102,     /* XK_h:            choseong  nieun                 */
    0x1106,     /* XK_i:            choseong  mieum                 */
    0x110b,     /* XK_j:            choseong  ieung                 */
    0x1100,     /* XK_k:            choseong  kiyeok                */
    0x110c,     /* XK_l:            choseong  cieuc                 */
    0x1112,     /* XK_m:            choseong  hieuh                 */
    0x1109,     /* XK_n:            choseong  sios                  */
    0x110e,     /* XK_o:            choseong  chieuch               */
    0x1111,     /* XK_p:            choseong  phieuph               */
    0x11ba,     /* XK_q:            jongseong sios                  */
    0x1162,     /* XK_r:            jungseong ae                    */
    0x11ab,     /* XK_s:            jongseong nieun                 */
    0x1165,     /* XK_t:            jungseong eo                    */
    0x1103,     /* XK_u:            choseong  tikeut                */
    0x1169,     /* XK_v:            jungseong o                     */
    0x11af,     /* XK_w:            jongseong rieul                 */
    0x11a8,     /* XK_x:            jongseong kiyeok                */
    0x1105,     /* XK_y:            choseong  rieul                 */
    0x11b7,     /* XK_z:            jongseong mieum                 */
    0x0025,     /* XK_braceleft:    percent sign                    */
    0x005c,     /* XK_bar:          backslash                       */
    0x002f,     /* XK_braceright:   slash                           */
    0x203b,     /* XK_asciitilde:   reference mark                  */
};

/* Hangul keyboard map table:
 * 3set keyboard no-shift (sebulsik sunarae) */
static const UTFCHAR keyboard_map_3sun[] = {
    0x0021,     /* XK_exclam:       exclamation mark                */
    0x0022,     /* XK_quotedbl:     quotatioin mark                 */
    0x0023,     /* XK_numbersign:   number sign                     */
    0x0024,     /* XK_dollar:       dollar sign                     */
    0x0025,     /* XK_percent:      percent sign                    */
    0x0026,     /* XK_ampersand:    ampersand                       */
    0x1110,     /* XK_apostrophe:   choseong thieuth                */
    0x0028,     /* XK_parenleft:    left parenthesis                */
    0x0029,     /* XK_parenright:   right parenthesis               */
    0x002a,     /* XK_asterisk:     asterisk                        */
    0x002b,     /* XK_plus:         plus sign                       */
    0x002c,     /* XK_comma:        comma                           */
    0x11bd,     /* XK_minus:        jongseong cieuc                 */
    0x002e,     /* XK_period:       period                          */
    0x11ae,     /* XK_slash:        jongseong tikeut                */
    0x1164,     /* XK_0:            choseong  yae                   */
    0x11c2,     /* XK_1:            jongseong hieuh                 */
    0x11bb,     /* XK_2:            jongseong ssangsios             */
    0x11b8,     /* XK_3:            jongseong pieup                 */
    0x116d,     /* XK_4:            jungseong yo                    */
    0x1172,     /* XK_5:            jungseong yu                    */
    0x1163,     /* XK_6:            jungseong ya                    */
    0x1168,     /* XK_7:            jungseong ye                    */
    0x1174,     /* XK_8:            jungseong yi                    */
    0x110f,     /* XK_9:            choseong khieukh                */
    0x003a,     /* XK_colon:        colon                           */
    0x1107,     /* XK_semicolon:    choseong  pieup                 */
    0x0032,     /* XK_less:         2                               */
    0x11be,     /* XK_equal:        jongseong chieuch               */
    0x0033,     /* XK_greater:      3                               */
    0x003f,     /* XK_question:     question mark                   */
    0x0040,     /* XK_at:           commertial at                   */
    0x11bc,     /* XK_A:            jongseong ieung                 */
    0x0021,     /* XK_B:            exclamation mark                */
    0x005c,     /* XK_C:            backslash                       */
    0x005d,     /* XK_D:            right bracket                   */
    0x1167,     /* XK_E:            jungseong yeo                   */
    0x1161,     /* XK_F:            jungseong a                     */
    0x002f,     /* XK_G:            slash                           */
    0x0027,     /* XK_H:            apostrophe                      */
    0x0038,     /* XK_I:            8                               */
    0x0034,     /* XK_J:            4                               */
    0x0035,     /* XK_K:            5                               */
    0x0036,     /* XK_L:            6                               */
    0x0031,     /* XK_M:            1                               */
    0x0030,     /* XK_N:            0                               */
    0x0039,     /* XK_O:            9                               */
    0x003e,     /* XK_P:            greater-than sign               */
    0x11ba,     /* XK_Q:            jongseong sios                  */
    0x1162,     /* XK_R:            jungseong ae                    */
    0x005b,     /* XK_S:            left bracket                    */
    0x003b,     /* XK_T:            semicolon                       */
    0x0037,     /* XK_U:            7                               */
    0x1169,     /* XK_V:            jungseong o                     */
    0x11af,     /* XK_W:            jongseong rieul                 */
    0x003d,     /* XK_X:            equals sign                     */
    0x003c,     /* XK_Y:            less-than sign                  */
    0x002d,     /* XK_Z:            minus sign                      */
    0x11c0,     /* XK_bracketleft:  jongseong thieuth               */
    0x11bf,     /* XK_backslash:    jongseong khieukh               */
    0x11c1,     /* XK_bracketright: jongseong phieuph               */
    0x005e,     /* XK_asciicircum:  circumflex accent               */
    0x005f,     /* XK_underscore:   underscore                      */
    0x0060,     /* XK_quoteleft:    grave accent                    */
    0x11bc,     /* XK_a:            jongseong ieung                 */
    0x116e,     /* XK_b:            jungseong u                     */
    0x1166,     /* XK_c:            jungseong e                     */
    0x1175,     /* XK_d:            jungseong i                     */
    0x1167,     /* XK_e:            jungseong yeo                   */
    0x1161,     /* XK_f:            jungseong a                     */
    0x1173,     /* XK_g:            jungseong eu                    */
    0x1102,     /* XK_h:            choseong  nieun                 */
    0x1106,     /* XK_i:            choseong  mieum                 */
    0x110b,     /* XK_j:            choseong  ieung                 */
    0x1100,     /* XK_k:            choseong  kiyeok                */
    0x110c,     /* XK_l:            choseong  cieuc                 */
    0x1112,     /* XK_m:            choseong  hieuh                 */
    0x1109,     /* XK_n:            choseong  sios                  */
    0x110e,     /* XK_o:            choseong  chieuch               */
    0x1111,     /* XK_p:            choseong  phieuph               */
    0x11ba,     /* XK_q:            jongseong sios                  */
    0x1162,     /* XK_r:            jungseong ae                    */
    0x11ab,     /* XK_s:            jongseong nieun                 */
    0x1165,     /* XK_t:            jungseong eo                    */
    0x1103,     /* XK_u:            choseong  tikeut                */
    0x1169,     /* XK_v:            jungseong o                     */
    0x11af,     /* XK_w:            jongseong rieul                 */
    0x11a8,     /* XK_x:            jongseong kiyeok                */
    0x1105,     /* XK_y:            choseong  rieul                 */
    0x11b7,     /* XK_z:            jongseong mieum                 */
    0x007b,     /* XK_braceleft:    left brace                      */
    0x007c,     /* XK_bar:          vertical line(bar)              */
    0x007d,     /* XK_braceright:   right brace                     */
    0x007e,     /* XK_asciitilde:   tilde                           */
};

/* Hangul keyboard map table:
 * 3set keyboard yetguel (sebulsik yetguel)
 * see http://asadal.cs.pusan.ac.kr/hangeul/kbd/oldkbd.jpg */
static const UTFCHAR keyboard_map_3yet[] = {
    0x11bd,     /* XK_exclam:       jongseong cieuc                 */
    0x0022,     /* XK_quotedbl:     quotatioin mark                 */
    0x0023,     /* XK_numbersign:   number sign                     */
    0x0024,     /* XK_dollar:       dollar sign                     */
    0x0025,     /* XK_percent:      percent sign                    */
    0x0026,     /* XK_ampersand:    ampersand                       */
    0x1110,     /* XK_apostrophe:   choseong thieuth                */
    0x0028,     /* XK_parenleft:    left parenthesis                */
    0x0029,     /* XK_parenright:   right parenthesis               */
    0x002a,     /* XK_asterisk:     asterisk                        */
    0x002b,     /* XK_plus:         plus sign                       */
    0x002c,     /* XK_comma:        comma                           */
    0x002d,     /* XK_minus:        minus sign                      */
    0x002e,     /* XK_period:       period                          */
    0x1169,     /* XK_slash:        jungseong o                     */
    0x110f,     /* XK_0:            choseong  khieukh               */
    0x11c2,     /* XK_1:            jongseong hieuh                 */
    0x11bb,     /* XK_2:            jongseong ssangsios             */
    0x11b8,     /* XK_3:            jongseong pieup                 */
    0x116d,     /* XK_4:            jungseong yo                    */
    0x1172,     /* XK_5:            jungseong yu                    */
    0x1163,     /* XK_6:            jungseong ya                    */
    0x1168,     /* XK_7:            jungseong ye                    */
    0x1174,     /* XK_8:            jungseong yi                    */
    0x116e,     /* XK_9:            jungseong u                     */
    0x003a,     /* XK_colon:        colon                           */
    0x1107,     /* XK_semicolon:    choseong  pieup                 */
    0x113c,     /* XK_less:         choseong chitueumsios           */
    0x003d,     /* XK_equal:        euals sign                      */
    0x113e,     /* XK_greater:      choseong ceongchieumsios        */
    0x003f,     /* XK_question:     question mark                   */
    0x11eb,     /* XK_at:           jongseong pansios               */
    0x11ae,     /* XK_A:            jongseong tikeut                */
    0x116e,     /* XK_B:            jungseong u                     */
    0x11b1,     /* XK_C:            jongseong rieul-mieum           */
    0x11b0,     /* XK_D:            jongseong rieul-kiyeok          */
    0x11bf,     /* XK_E:            jongseong khieukh               */
    0x11a9,     /* XK_F:            jongseong ssangkiyeok           */
    0x119e,     /* XK_G:            jungseong araea                 */
    0x1102,     /* XK_H:            choseong nieun                  */
    0x1154,     /* XK_I:            choseong chitueumchieuch        */
    0x114c,     /* XK_J:            choseong yesieung               */
    0x114e,     /* XK_K:            choseong chitueumcieuc          */
    0x1150,     /* XK_L:            choseong ceongchieumcieuc       */
    0x1159,     /* XK_M:            choseong yeorinhieuh            */
    0x1140,     /* XK_N:            choseong pansios                */
    0x1155,     /* XK_O:            choseong ceongchieumchieuch     */
    0x1111,     /* XK_P:            choseong phieuph                */
    0x11c1,     /* XK_Q:            jongseong phieuph               */
    0x1164,     /* XK_R:            jungseong yae                   */
    0x11ad,     /* XK_S:            jongseong nieun-hieuh           */
    0x1165,     /* XK_T:            jungseong eo                    */
    0x302e,     /* XK_U:            single dot tone mark            */
    0x11b6,     /* XK_V:            jongseong rieul-hieuh           */
    0x11c0,     /* XK_W:            jongseong thikeuth              */
    0x11b9,     /* XK_X:            jongseong pieup-sios            */
    0x302f,     /* XK_Y:            double dot tone mark            */
    0x11be,     /* XK_Z:            jongseong chieuch               */
    0x005b,     /* XK_bracketleft:  left bracket                    */
    0x005c,     /* XK_backslash:    backslash                       */
    0x005d,     /* XK_bracketright: right bracket                   */
    0x005e,     /* XK_asciicircum:  circumflex accent               */
    0x005f,     /* XK_underscore:   underscore                      */
    0x11f9,     /* XK_quoteleft:    jongseong yeorinhieuh           */
    0x11bc,     /* XK_a:            jongseong ieung                 */
    0x116e,     /* XK_b:            jungseong u                     */
    0x1166,     /* XK_c:            jungseong e                     */
    0x1175,     /* XK_d:            jungseong i                     */
    0x1167,     /* XK_e:            jungseong yeo                   */
    0x1161,     /* XK_f:            jungseong a                     */
    0x1173,     /* XK_g:            jungseong eu                    */
    0x1102,     /* XK_h:            choseong  nieun                 */
    0x1106,     /* XK_i:            choseong  mieum                 */
    0x110b,     /* XK_j:            choseong  ieung                 */
    0x1100,     /* XK_k:            choseong  kiyeok                */
    0x110c,     /* XK_l:            choseong  cieuc                 */
    0x1112,     /* XK_m:            choseong  hieuh                 */
    0x1109,     /* XK_n:            choseong  sios                  */
    0x110e,     /* XK_o:            choseong  chieuch               */
    0x1111,     /* XK_p:            choseong  phieuph               */
    0x11ba,     /* XK_q:            jongseong sios                  */
    0x1162,     /* XK_r:            jungseong ae                    */
    0x11ab,     /* XK_s:            jongseong nieun                 */
    0x1165,     /* XK_t:            jungseong eo                    */
    0x1103,     /* XK_u:            choseong  tikeut                */
    0x1169,     /* XK_v:            jungseong o                     */
    0x11af,     /* XK_w:            jongseong rieul                 */
    0x11a8,     /* XK_x:            jongseong kiyeok                */
    0x1105,     /* XK_y:            choseong  rieul                 */
    0x11b7,     /* XK_z:            jongseong mieum                 */
    0x007b,     /* XK_braceleft:    left brace                      */
    0x007c,     /* XK_bar:          vertical line(bar)              */
    0x007d,     /* XK_braceright:   right brace                     */
    0x11f0,     /* XK_asciitilde:   jongseong yesieung              */
};

/* vim: set ts=8 sw=4 et : */
