#include <stdio.h>

#include "le.h"
#include "encode.h"
#include "xaux_locale.h"

int map_keyevent_to_immkey(IMKeyEventStruct *key_event);
void proc_key_round_switch_ime_event(iml_session_t *s);
void proc_key_switch_conversion_event(iml_session_t *s, int on);
void proc_key_select_switch_ime_event(iml_session_t *s, int ime_id);
void proc_key_output(iml_session_t *s, IMKeyEventStruct *key_event);

extern int          gEngine_Num;
extern int          locale_Num;
extern int localeNameKeyCode;
extern int localeNameModifier;
extern int layoutNameKeyCode;
extern int layoutNameModifier;
extern IMEEngineRec *gEngine_Info[MAX_ENGINE_NUM];
extern IMEModeList  *modeList[MAX_ENGINE_NUM];
extern LocaleList *localeList;

/* process the keyboard event */
void proc_key_event(iml_session_t *s, IMKeyListEvent *keylistevent)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	IMKeyEventStruct *key_event = (IMKeyEventStruct *) keylistevent->keylist;
  char *last_locale_string;
  char *cur_locale_string;
  char *cur_engine_string;
	int i, j,  key_ret, ime_id, engine_id;
  int feid, leid;
	int keyCode, Modifier, keyChar;

  keyCode = key_event->keyCode;
  keyChar = key_event->keyChar;
  Modifier = key_event->modifier;

  last_locale_string = (char *)calloc(32, sizeof(char));
  cur_locale_string = (char *)calloc(32, sizeof(char));
  cur_engine_string = (char *)calloc(32, sizeof(char));

	log_f(" proc_keyevent:   session:%x\n", s);

	/* if no input methods in language engine. */
	if (gEngine_Num <=0) {
            	iml_sendback_key(s, key_event);
		return;
	}

	key_ret = map_keyevent_to_immkey(key_event);

	switch (key_ret) {
		/* English status <----> Non-English status */
		case ENGLISH_NONENGLISH_SWITCH_KEY:
			proc_key_switch_conversion_event(s, CONVERSION_OFF);
			return;

		/* Bound Switching between Input Methods */
		case ROUND_SWITCH_KEY:
			proc_key_round_switch_ime_event(s);
			return;
  }

	/*  Changing Locale Name */
	if ((keyCode == localeNameKeyCode) && (Modifier == localeNameModifier)) {
    engine_id = session_data->paletteaux_status.engine_id;
    log_f("Change Language: engine_id [%d]\n",engine_id);
    (void) strcpy((char *)cur_locale_string, modeList[engine_id]->locale_name)
;
    log_f("Change Language, locale_name [%s]\n",cur_locale_string);
    log_f("Change Language, localeList[%d]: [%s]\n",locale_Num, localeList[locale_Num - 1].locale_name);
    if(!strcmp(cur_locale_string, localeList[locale_Num - 1].locale_name)){
      le_switch_engine(s, 0);
    }else{
      for (i = engine_id; i< gEngine_Num; i++) {
        if(!strcmp(cur_locale_string, modeList[i]->locale_name)){
          log_f("EQUAL <%s>\n",modeList[i]->locale_name);
        }else{
          log_f("NOT EQUAL locale_name <%s>\n",modeList[i]->locale_name);
          log_f("NOT EQUAL engine_id <%d>\n",modeList[i]->engine_id);
          le_switch_engine(s, modeList[i]->engine_id);
          break;
        }
      }
    }
		return;
	}else if((keyCode == layoutNameKeyCode) && (Modifier == layoutNameModifier)){ 
	   /*  Changing keyboard layout Name */
     engine_id = session_data->paletteaux_status.engine_id;
     log_f("Changing Layout: engine_id [%d]\n",engine_id);
     (void) strcpy((char *)cur_locale_string, modeList[engine_id]->locale_name);
     log_f("Changing Layout: cur_locale_string [%s]\n",cur_locale_string);
     (void) strcpy((char *)cur_engine_string, modeList[engine_id]->engine_name);
     log_f("Changing Layout: engine_name [%s]\n",cur_engine_string);

     for(i=0; i< locale_Num; i++){
       if(!strcmp(cur_locale_string, localeList[i].locale_name)){
         feid = localeList[i].firstEngineId;
         leid = localeList[i].lastEngineId;
       }
     }
     log_f("Changing Layout: feid [%d] leid [%d]\n",feid, leid);
     for (i = engine_id; i<= gEngine_Num; i++) {
       if(!strcmp(cur_locale_string, modeList[i]->locale_name)){
         if(!strcmp(cur_engine_string, modeList[i]->engine_name)){
           log_f("Engine EQUAL <%s>\n",modeList[i]->engine_name);
           if(engine_id == leid){
             log_f("engine_id == leid \n");
             le_switch_engine(s, feid);
	           break;
           }
         }else{
           log_f("Engine NOT EQUAL engine_name <%s>\n",modeList[i]->engine_name);
           log_f("NOT EQUAL engine_id <%d>\n",modeList[i]->engine_id);
           le_switch_engine(s, modeList[i]->engine_id);
	         break;
         }
       }
     }
		 return;
   }
	proc_key_output(s, key_event);
}

/* filter keys that used by Input Methods Manager */
int map_keyevent_to_immkey(IMKeyEventStruct *key_event) 
{
	int keycode, modifier, keychar;

  keycode = key_event->keyCode;
  keychar = key_event->keyChar;
  modifier = key_event->modifier;

	log_f("Dec: keycode: %d, keychar: %d, status: %d\n",keycode, keychar, modifier);
	log_f("Hex: keycode: %x, keychar: %x, modifier: %x\n",keycode, keychar, modifier);

	/*  Control status */
	if (modifier & IM_CTRL_MASK) {
		switch(keycode) {
		 	case IM_VK_ESCAPE:	return(ROUND_SWITCH_KEY);
		 	case IM_VK_SPACE:	return(ENGLISH_NONENGLISH_SWITCH_KEY);
		}
	}
	return (IMM_NOT_USED_KEY);
}

void proc_key_switch_conversion_event(iml_session_t *s, int on)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, i;
	char locale_id, system_locale_id;

	log_f("ENGLISH_NONENGLISH SWITCH IME KEY, on:%d\n", on);

       	le_clear_ime_buffer(s, session_data->ime_buffer);

	session_data->paletteaux_status.on = on;
	engine_id = session_data->paletteaux_status.engine_id;
	log_f("proc_key_switch_conversion_event: engine_id <%d>\n", engine_id);
	if (on == CONVERSION_OFF) {
    log_f("Inside CONVERSION_OFF \n");
		le_status_draw(s);
		iml_conversion_off(s);
	} else {
    log_f("Inside CONVERSION_ON \n");
		iml_conversion_on(s);
		if (engine_id != 0xff) {
      log_f("engine_id != 0xff \n");
      le_switch_engine(s, engine_id);
    }
	}

	if (on == CONVERSION_ON && engine_id == 0xff) {
		system_locale_id = desktop_data->aux_locale_id;
    log_f("keyevent.c: system_locale_id <%d>\n",system_locale_id);
		engine_id = 0;
		for (i = 0; i< gEngine_Num; i++) {
			locale_id = gEngine_Info[i]->core.baseinfo.locale_id;
      log_f("keyevent.c: system_locale_id <%d> locale_id <%d>\n",system_locale_id,locale_id);
			if (locale_id == system_locale_id || locale_id == ENCODES_NUM) {
				engine_id = i;
				break;
			}
		}
		log_f("engine_id:%d\n", engine_id);
		le_switch_engine(s, engine_id);
	}
}

void proc_key_round_switch_ime_event(iml_session_t *s)
{
	 MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
   MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, i;
	char locale_id, system_locale_id;

	log_f("ROUND SWITCH IME KEY\n");

	system_locale_id = desktop_data->aux_locale_id;
	engine_id = session_data->paletteaux_status.engine_id;
	for (i = 0; i< gEngine_Num; i++) {
		engine_id = (engine_id + 1) % gEngine_Num;
		locale_id = gEngine_Info[engine_id]->core.baseinfo.locale_id;
		if (locale_id == system_locale_id || locale_id == ENCODES_NUM) {
			break;
		}
	}
	log_f("engine_id:%d\n", engine_id);

	le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_engine(s, engine_id);
}

void proc_key_select_switch_ime_event(iml_session_t *s, int ime_id)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, engine_num, i;
	char locale_id, system_locale_id;

	log_f("SELECT SWITCH IME KEY\n");
	log_f("selected ime_id:%d\n", ime_id);

	system_locale_id = desktop_data->aux_locale_id;
	engine_num = 0;
	engine_id = 0;
	for (i = 0; i< gEngine_Num; i++) {
		locale_id = gEngine_Info[i]->core.baseinfo.locale_id;
		if (locale_id == system_locale_id || locale_id == ENCODES_NUM) {
			if (engine_num >= ime_id) {
				engine_id = i;
				break;
			}
			engine_num ++;
		}
	}

	log_f("engine_id:%d\n", engine_id);
  le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_engine(s, engine_id);
}

void proc_key_output(iml_session_t *s, IMKeyEventStruct *key_event)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	IMEKeyRec  ime_keyevent;
	IMEArgList ime_args;
	int ret, cur_engine_id;

	cur_engine_id = session_data->paletteaux_status.engine_id;
	log_f("cur_engine_id:%d\n", cur_engine_id);
	if (cur_engine_id == 0xff) {
            	iml_sendback_key(s, key_event);
		return;
	}

	ime_keyevent.keyCode = key_event->keyCode;
	ime_keyevent.keyChar = key_event->keyChar;
	ime_keyevent.modifier = key_event->modifier;

	/* get user defined arguments */
	ime_args = desktop_data->ime_args[cur_engine_id];
	gEngine_Info[cur_engine_id]->core.envinfo.output_encode_id = desktop_data->aux_locale_id;
        ret = gEngine_Info[cur_engine_id]->so_methods->IME_Filter(&gEngine_Info[cur_engine_id]->core,
                                                   &ime_keyevent, ime_args, 
                                                   session_data->ime_buffer);

	if (ret == IME_NOT_USED_KEY)
		iml_sendback_key(s, key_event);
	else
    le_output_ime_buffer(s, session_data->ime_buffer);
}
