#ifndef LEMGR_HH_
#define LEMGR_HH_
#include <vector>
#include <string>
#include "basictype.hh"
#include "IMBasicObject.hh"
#include "LE.hh"

class IMInputContext;

class LEMgr
{
    string lepath;

    typedef vector<LEBase*> LEBaseVec;
    LEBaseVec levec;
    LEBase *psunim_default_lebase;

    bool ledata_inited;
    IMLangList langlist;
    IMDescriptorList imdesclist;
    IMObjectWithDescList imobjectdesclist;
    bool initialize_ledata();

    void listup_LEs();

  public:
    const IMLangList* get_all_langlist();
    const IMDescriptorList* get_all_imdesclist();
    const IMObjectWithDescList* get_all_imobjectdesclist();
    LEContext *choose_LE(
	IMInputContext *pic
    );
    LEMgr(const char* lepath);
    virtual ~LEMgr();
};

#endif /* not IMSVRARG_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
