#ifndef IIIMP_IMSTATE_HH_
#define IIIMP_IMSTATE_HH_
#include <iiimp.h>
#include "basictype.hh"
#include "IMState.hh"

class IIIMProtocol;
class IIIMPTrans;
class IIIMP_IMState : public IMState
{
    IIIMPTrans *pimt;
    bool parse_user_name(const u16string& uname,
			 u16string& username,
			 u16string& password,
			 string& hostname);
    bool send_trigger_keys();
    virtual bool message_proc(
	void *message
    );
    virtual void destroy();

  public:
    bool send(IIIMP_message* pmes, bool deletep = false);
    IIIMPTrans* get_iiimptrans()
    { return pimt; }
    IIIMP_IMState(
	IIIMProtocol *pimp,
	IIIMPTrans *pimt
    );
};

class IIIMP_IMState_Session;
// In this state, the IM user is correctly identified by IM_CONNECT.
// And waiting the client's request.
class IIIMP_IMState_Identified : public IIIMP_IMState
{
    void exit_from_identified();
    IIIMP_imattribute *create_object_descriptors();
    bool set_data_to_client();
    IIIMP_imattribute* get_imattribute(
	IIIMP_card16 id
    );
    virtual bool message_proc(
	void *message
    );

  public:
    IIIMP_IMState_Identified(
	IIIMP_IMState *pimt,
	IMHandler *pimh
    );
};

// In this state, the IM receives a request from the client, but
// still continue the session.  Note that transfer the state to
// IIIMP_IMState_Identified by sending the corresponding reply
// message.
class IIIMP_IMState_Session : public IIIMP_IMState
{
    virtual bool message_proc(
	void *message
    );

  public:
    IIIMP_IMState_Session(
	IIIMP_IMState_Identified *pimt
    );
};

#endif /* not IIIMP_IMSTATE_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
