<?php
/********************************************************
    Author: Jayme Metcalfe

	include/ldapquery.inc
	
	PURPOSE:
        LDAP do LDAP query
        
    PRE-CONDITION:
        doldap is set from contacts.php
        ldap_conf.inc is set up

    POST-CONDITION:
        LDAP entries added to address book

    Comments: Should work fine :)

********************************************************/

$ldapid = $_GET["ldapserver"]; 

echo "<h3>LDAP query executing</h3>";
echo "Connecting ...";

$ds=ldap_connect($LDAP_INFO[$ldapid]["hostname"]);  // must be a valid LDAP server!
echo "LDAP connection established<p>";

if ($ds) { 
    echo "Binding ..."; 
    if ($LDAP_INFO[$ldapid]["anon_bind"]) {  // this is an anonymous bind
      $r = ldap_bind($ds);                                  
      if ($r) {echo "Bind successful<p>";}
      else {echo "Bind unsuccessful<p>";}
    }
    else { // non-anonymous bind
      $username = $LDAP_INFO[$ldapid]["ldap_username"];
      $password = $LDAP_INFO[$ldapid]["ldap_password"];
      $r = ldap_bind($ds, "cn=$username, ", $password);
      if ($r) {echo "Bind successful<p>";}
      else {echo "Bind unsuccessful<p>";}
    }

    echo "Returning all entries ...";
    // Search surname entry
    $sr=ldap_search($ds,$LDAP_INFO[$ldapid]["ldap_root_dn"],"cn=*");  

    echo "Number of entires returned is ".ldap_count_entries($ds,$sr)."<p>";
    $info = ldap_get_entries($ds, $sr);
    echo "Data for ".$info["count"]." items entered into address book:<p>";
    echo "Closing connection";
    ldap_close($ds);

} else {
    echo "<h4>Unable to connect to LDAP server</h4>";
    exit;
}

// Create array from LDAP data

$group="LDAP - ".$LDAP_INFO[$ldapid]["name"];

//create data array
for ($i = 0; $i < $info["count"]; $i++) {
  $new_contact_array[$i] = array(
       	"owner" => $session_dataID,
       	"name" => $info[$i]["cn"][0],
       	"email" => $info[$i]["mail"][0],
       	"email2" => $email2,
       	"grp" => $group,
       	"aim" => $aim,
       	"icq" => $icq,
		"yahoo" => $yahoo,
		"msn" => $msn,
		"jabber" => $jabber,
       	"phone" => $phone,
       	"work" => $work,
       	"cell" => $cell,
       	"address" => $address,
       	"url" => $url,
       	"comments" => $comments
    	  );
	}	

//Delete old LDAP address book to prevent dual entries

$contacts = $dm->sort($sort_field, $sort_order);
$numContacts = count($contacts);
echo "<br />Total Number of contacts: ".$numContacts;

$numgroup = 0;
$i = 1;
while ($i <= $numContacts) {
  if ($contacts[$i]["grp"] == $group) {
    $numgroup++;
  }
  $i++;
}

if ($numgroup > 0) {
  $numdeleted = 0; $i = 1;
  while ($numdeleted <= $numgroup) {
    if ($contacts[$i]["grp"] == $group) {
      $dm->delete($i);
      $numdeleted++;
      $i = 1;
    }
    else {
      $i++;
    }
  }
}


//Do Insert
for ($i = 0; $i < $info["count"]; $i++) {
  if (!$dm->insert($new_contact_array[$i])){
    echo "Insert failed<br>";
    $dm->showError();
  }
}

?>


