<?php

/********************************************************

	AUTHOR: Ben Weinberg <ben@bensbrain.com>
	FILE:  source/addcontacts3.php
	PURPOSE:
		Add contacts from csv file...
	
********************************************************/


include("../include/super2global.inc");
include("../include/contacts_commons.inc");
include_once("../include/data_manager.inc");
if (isset($user)){
	include("../include/header_main.inc");
	include("../lang/".$my_prefs["lang"]."/contacts.inc");
	include("../lang/".$my_prefs["lang"]."/compose.inc");

	//authenticate
	include_once("../include/icl.inc");
	$conn=iil_Connect($host, $loginID, $password, $AUTH_MODE);
	if ($conn){
		iil_Close($conn);
	}else{
		echo "Authentication failed.";
		echo "</html>\n";
		exit;
	}
}

$temp_contacts = unserialize(rawurldecode($temp_contacts));
?>

<br>
<table width="100%" cellpadding=2 cellspacing=0>
<tr bgcolor="#222244"><td>
<span class="bigTitle">Contact Importer: Page 3/3</span>
</td></tr>
<tr bgcolor="#f0f0f0"><td>

<?php

//initialize source name
	$source_name = $DB_CONTACTS_TABLE;
	if (empty($source_name)) $source_name = "contacts";
	
	//open data manager connection
	$dm = new DataManager_obj;
	if ($dm->initialize($loginID, $host, $source_name, $backend)){
	}else{
		echo "Data Manager initialization failed:<br>\n";
		$dm->showError();
	}

// make array containing names of imported fields and matching iloha fields
$matching_array = array();
while (list($key, $value) = each($HTTP_POST_VARS)){
if ($key != "temp_contacts" && $key != "finish") {
	// $key is imported field, $value is iloha field
	if ($value != "") $matching_array["$key"] = $value; 
	}
}

$numrows = count($temp_contacts);

// $temp_contacts is an array of contacts in sub-arrays like:  ("name"=>"bill",email=>"bill@bill.com")

// make new array like temp_contacts, using the matching array above to substitute new iloha field names as keys

for ($i = 0; $i < $numrows; $i++) {  // loop through rows of imported contacts

if ( isset($new_contact_array) ) unset($new_contact_array);

		$new_contact_array = array(
        	"owner" => $session_dataID
//         	"grp" => $group,  // this leaves the option of defining a group on the previous page into which to insert these contacts
    	);
	
	reset($matching_array);
	
	while (list($imp_name, $iloha_name) = each($matching_array)){
	$newvalue = $temp_contacts[$i][$imp_name];
//	echo "temp_contacts [$imp_name] = " .  $newvalue . "<br>";
	if ($newvalue != "") {
		if (!isset($new_contact_array["$iloha_name"])) $new_contact_array["$iloha_name"] = $newvalue;
		else $new_contact_array["$iloha_name"] .= "  " . $newvalue;
		}
	}
$recordname = (isset($new_contact_array["name"])) ? "(" . $new_contact_array["name"] . ")" : "" ;
	
/*
	while ( list($key,$value) = each ($new_contact_array)){
	echo "$key = $value<br>";
	}
*/	

	// insert contact
	if ($dm->insert($new_contact_array)) echo "Record " . ($i + 1) . " $recordname Inserted <br>\n";
	else{
		echo "Insert failed for record " . ($i + 1) . "<br>";
		$dm->showError();
	}

}// end loop through rows of imported contacts

echo("<br><br><a href='contacts.php?user=$user'>Click here to view all your contacts.</a><br><br>");

?>
</td></tr>
</table>
</body>
</html>
