/***************************************
  $Header: /cvsroot/petscgraphics/illuminator.h,v 1.16 2004/03/07 01:56:18 hazelsct Exp $

  This is the interface for the Illuminator library.
***************************************/

#ifndef ILLUMINATOR_H
#define ILLUMINATOR_H    /*+ To stop multiple inclusions. +*/
#include <petscda.h>

/* Core stuff */
int IllDrawTet (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant, PetscScalar *color);
int IllDrawHex (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant, PetscScalar *color);
int IllDraw3DBlock (int xd, int yd, int zd, int xs, int ys, int zs, int xm,
		    int ym, int zm, PetscScalar *minmax, PetscScalar *vals,
		    int skip, int n_quants, PetscScalar *isoquants,
		    PetscScalar *colors);

/*+ A value of
  +latex+{\tt field\_plot\_type}
  +html+ <tt>field_plot_type</tt>
  is attached to each field in a simulation in order to visualize them
  properly.  Types are as follows:
  +*/
typedef enum {
  /*+Plot scalar field using colors.+*/
  FIELD_SCALAR_COLORS=0x00,
  /*+Plot scalar field using contours.+*/
  FIELD_SCALAR_CONTOURS=0x01,
  /*+Plot ternary data using red, green, blue for components (third component
    is inferred from first two).+*/
  FIELD_TERNARY_RGB=0x10,
  /*+Plot vector field using arrows.+*/
  FIELD_VECTOR_ARROWS=0x20,
  /*+Plot vector field using hue for direction, intensity for magnitude.+*/
  FIELD_VECTOR_HUEINTENSE=0x21,
  /*+Plot transformation tensor field as vector triplets.+*/
  FIELD_TENSOR_TRANSFORM_VECTORS=0x30,
  /*+Plot symmetric tensor field using lines in principal stress directions.+*/
  FIELD_TENSOR_STRESS=0x38,
  /*+Plot symmetric tensor field using lines in principal stress directions,
    inferring last diagonal from the opposite of the sum of the other two.+*/
  FIELD_TENSOR_STRESS_SHEAR=0x39
} field_plot_type;

/* PETSc stuff; xcut, ycut and zcut should almost always be PETSC_FALSE */
int DATriangulate
(DA theda, Vec globalX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, PetscTruth xcut, PetscTruth ycut,
 PetscTruth zcut);
int DATriangulateLocal
(DA theda, Vec localX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, PetscTruth xcut, PetscTruth ycut,
 PetscTruth zcut);
int IllErrorHandler (int id, char *message);

/* Plot2D stuff, future development... */

/* int DAPlot (DA theda, Vec global, PetscScalar x_magnify, PetscScalar y_magnify,
   plot_type *types, void **params); */

/* IlluMulti load/save stuff, including compression #defines */
int IlluMultiLoad
(char *basename, DA *theda, PetscScalar *wx,PetscScalar *wy,PetscScalar *wz,
 field_plot_type **fieldtypes, int *usermetacount, char ***usermetanames,
 char ***usermetadata);
int IlluMultiRead (DA theda, Vec X, char *basename, int *usermetacount, 
		   char ***usermetanames, char ***usermetadata);
int IlluMultiSave
(DA theda, Vec X, char *basename, PetscScalar wx,PetscScalar wy,PetscScalar wz,
 field_plot_type *fieldtypes, int usermetacount, char **usermetanames,
 char **usermetadata, int compressed);
#define COMPRESS_INT_MASK  0x30
#define COMPRESS_INT_NONE  0x00
#define COMPRESS_INT_LONG  0x10
#define COMPRESS_INT_SHORT 0x20
#define COMPRESS_INT_CHAR  0x30
#define COMPRESS_GZIP_MASK 0x0F
#define COMPRESS_GZIP_NONE 0x00
#define COMPRESS_GZIP_FAST 0x01
#define COMPRESS_GZIP_BEST 0x0A

/* Geomview stuff */
int GeomviewBegin (MPI_Comm comm);
int GeomviewEnd (MPI_Comm comm);
int GeomviewDisplayTriangulation (MPI_Comm comm, PetscScalar *minmax,
				  char *name, PetscTruth transparent);

#endif /* ILLUMINATOR_H */
