# igraph Code of Conduct

## Introduction

This code of conduct applies to all spaces managed by the igraph project,
including all public and private mailing lists, issue trackers, wikis, blogs,
Twitter, and any other communication channel used by our community. Any events
related to our community shall also be bound by this code of conduct or a very
similar variant thereof.

This code of conduct should be honored by everyone who participates in the
igraph community formally or informally, or claims any affiliation with the
project, in any project-related activities, and, especially, when representing
the project, in any capacity.

This code of conduct is neither exhaustive nor complete. It serves to distill
our common understanding of a collaborative, shared environment and goals.
Please try to follow this code in spirit as much as in letter, to create
a friendly and productive environment that enriches the surrounding community.

## Specific guidelines

We strive to:

1. Be open. We invite anyone to participate in our community. We prefer to use
   public methods of communication for project-related messages, unless
   discussing something sensitive. This applies to messages for help or
   project-related support, too; not only is a public-support request much more
   likely to result in an answer to a question, it also ensures that any
   inadvertent mistakes in answering are more easily detected and corrected.

2. Be empathetic, welcoming, friendly, and patient. We work together to resolve
   conflict, and assume good intentions. We may all experience some frustration
   from time to time, but we do not allow frustration to turn into a personal
   attack. A community where people feel uncomfortable or threatened is not a
   productive one.

3. Be collaborative. Our work will be used by other people, and in turn we will
   depend on the work of others. When we make something for the benefit of the
   project, we are willing to explain to others how it works, so that they can
   build on the work to make it even better. Any decision we make will affect
   users and colleagues, and we take those consequences seriously when making
   decisions.

4. Be inquisitive. Nobody knows everything! Asking questions early avoids many
   problems later, so we encourage questions, although we may direct them to
   the appropriate forum. We will try hard to be responsive and helpful.

5. Be careful in the words that we choose. We are careful and respectful in
   our communication and we take responsibility for our own words. Be kind to
   others. Do not insult or put down other participants. We do not tolerate
   harassment or other exclusionary behavior, such as:

    * Violent threats or language directed against another person.

    * Sexist, racist, or otherwise discriminatory jokes and language.

   * Posting sexually explicit or violent material.

   * Posting (or threatening to post) other people’s personally identifying
     information (“doxing”).

   * Sharing private content, such as emails sent privately or non-publicly,
      or unlogged forums, such as IRC channel history, without the sender’s consent.

    * Personal insults, especially those using racist or sexist terms.

   * Unwelcome sexual attention.

   * Excessive profanity. Please avoid swearwords; people differ greatly in
     their sensitivity to swearing.

   * Repeated harassment of others. In general, if someone asks you to stop,
     then stop.

   * Advocating for, or encouraging, any of the above behavior.

## Diversity statement

The igraph project welcomes and encourages participation by everyone. We are
committed to being a community that everyone enjoys being part of. Although
we may not always be able to accommodate each individual’s preferences, we try
our best to treat everyone kindly.

No matter how you identify yourself or how others perceive you: we welcome you.
Though no list can hope to be comprehensive, we explicitly honor diversity in:
age, culture, ethnicity, genotype, gender identity or expression, language,
national origin, neurotype, phenotype, political beliefs, profession, race,
religion, sexual orientation, socioeconomic status, subculture and technical
ability, to the extent that these do not conflict with this code of conduct.

Though we welcome people fluent in all languages, igraph development is
conducted in English.

Standards for behavior in the igraph community are detailed in the Code of
Conduct above. Participants in our community should uphold these standards
in all their interactions and help others to do so as well (see next section).

## Reporting guidelines

We know that it is painfully common for internet communication to start at or
devolve into obvious and flagrant abuse. We also recognize that sometimes
people may have a bad day, or be unaware of some of the guidelines in this Code
of Conduct. Please keep this in mind when deciding on how to respond to a
breach of this Code.

For clearly flagrant breaches, report those to the igraph organisation
(see below). For possibly unintentional breaches, you may reply to the person
and point out this Code of Conduct (either in public or in private, whatever is
most appropriate). If you would prefer not to do that, please feel free to
report to the igraph organisation directly, or ask the organisation for
advice, in confidence.

You can report issues to the igraph organisation, at <igraph@igraph.org>.
Currently, the following persons will receive your report:

* Gábor Csárdi

* Tamás Nepusz

* Szabolcs Horvát

* Vincent Traag

If your report involves any of the above mentioned persons, or if they feel
they have a conflict of interest in handling it, they will recuse themselves
from considering your report. Alternatively, if, for any reason, you feel
uncomfortable making a report to the organisation directly, then you can also
contact any of the above mentioned persons individually.

## Incident reporting

We will investigate and respond to all complaints. The igraph organisation will
protect the identity of the reporter, and treat the content of complaints as
confidential (unless the reporter agrees otherwise).

In case of flagrant breaches, e.g., personal threats or violent, sexist or
racist language, we will immediately disconnect the originator from igraph. In
particular, the organisation will

1. Immediately disconnect the originator from all igraph communication channels.

2. Revoke any granted permissions from the originator.

3. Reply to the reporter that their report has been received and that the
   originator has been disconnected.

4. In every case, the moderator should make a reasonable effort to contact the
   originator, and tell them specifically how their language or actions qualify
   as a “flagrant breach”. The moderator should also say that, if the
   originator believes this is unfair or they want to be reconnected to igraph,
   they have the right to ask for a review, as below, by the igraph
   organisation.

5. The igraph organisation will formally review and sign off on all cases
   where this mechanism has been applied to make sure it is not being
   used to control ordinary heated disagreement.

In cases not involving flagrant breaches of this code of conduct, the process
for acting on any received code of conduct violation report will be:

1. acknowledgement that the report has been received

2. reasonable discussion/feedback

3. mediation (if feedback didn’t help, and only if both reporter and reportee
   agree to this)

The organisation will respond to any report as soon as possible, and at most
within 5 working days.

## Endnotes

This Code of Conduct is inspired by [the SciPy Code of Conduct](https://docs.scipy.org/doc/scipy/reference/dev/conduct/code_of_conduct.html).

The current organisation of the igraph community is rudimentary. A more
professional organisation may develop in the future, at which point the
procedure of handling incident reports will also be further formalized.
