/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPICKER_H
#define IPICKER_H


#include "iobject.h"
#include <vtkAbstractPropPicker.h>
#include "idataformatter.h"


#include "iposition.h"

class iActor;
class iDataType;
class iPickEventObserver;

class vtkSphereSource;


class iPicker : public iObject, public vtkAbstractPropPicker, public iDataFormatter
{

	friend class iExtensionFactory;
	friend class iPickEventObserver;

public:

	static iPicker* New(iViewModule *vm);
	static const iObjectType& Type();

	virtual int IsA(const char *type);
		
	IOBJECT_DECLARE_GETSET1(Accuracy,float);
	IOBJECT_DECLARE_GETSET1(PickMethod,int);
	IOBJECT_DECLARE_GETSET1(PointSize,float);

	inline const iPosition& GetPosition() const { return mPos; }
	inline const iString& GetObjectName() const { return mObjName; }

	void ShowPickedPoint(bool s);

	virtual int Pick(double x, double y, double z, vtkRenderer *ren);
	virtual void Modified();

protected:
	
	iPicker(iViewModule *vm);
	virtual ~iPicker();

	virtual void PackStateBody(iString &) const;
	virtual void UnPackStateBody(const iString &);

	void UpdateReport();
	virtual void UpdateReportBody();

	iPosition mPos;
	iString mObjName;
	int mObjType;
	const iDataType *mDataTypePointer;
	int mPickMethod;
	const int mNumPickMethods;

	//
	//  Actual pickers
	//
	vtkAbstractPropPicker *mDevices[3];
	iPickEventObserver *mObserver;

	//
	//  Graphical representation
	//
	iActor *mPointActor;
	vtkSphereSource *mPointSource;
	float mPointSize, mAccuracy;
};

#endif  // IPICKER_H
