/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IFIELDVIEWOBJECT_H
#define IFIELDVIEWOBJECT_H


#include "isolidviewobject.h"


class iGridDataConverter;

class vtkImageData;


class iFieldViewObject : public iSolidViewObject
{
	
public:
	
	static const iObjectType& Type();
	virtual const iObjectType& RealType();
		
	virtual void SetColorBy(int q);
	inline int GetColorBy() const { return mColorBy; }
	
	virtual void SetGlyphSize(const iDistance &q);
	inline const iDistance& GetGlyphSize() const { return mGlyphSize; }
	
	virtual void SetGlyphSampleRate(int q);
	inline int GetGlyphSampleRate() const { return mGlyphSampleRate; }
	
	virtual int GetDataOffset() const = 0;
	virtual bool CanBeShown() const;

protected:
	
	iFieldViewObject(iViewModule *vm, const iDataInfo &info, int numActors, unsigned int rank, unsigned int flags);
	virtual ~iFieldViewObject();

	virtual void UpdateGlyphSize() = 0;
	virtual void UpdateGlyphSampleRate() = 0;
	virtual void ResetPipelineInput(vtkImageData *input) = 0;

	virtual void ResetInput();
	virtual void UpdateColorByExtra(){}

	virtual void FieldViewObjectPackStateBody(iString &s) const = 0;
	virtual void FieldViewObjectUnPackStateBody(const iString &s) = 0;
	virtual void FieldViewObjectSyncWithData(int info, void *data) = 0;

	virtual void SolidViewObjectPackStateBody(iString &s) const;
	virtual void SolidViewObjectUnPackStateBody(const iString &s);
	virtual void ViewObjectSyncWithData(int info, void *data);
	virtual void ShowColorBarsBody(bool);

	virtual const iDataType& GetScalarDataType() const;

	bool IsConnectedToScalars() const;
	bool IsColoredByScalars() const;

	iDistance mGlyphSize;
	int mColorBy, mColorByOffset, mGlyphSampleRate;

	iGridDataConverter *mDataConverter;

private:

	static const iObjectKey& KeyColorBy();
	static const iObjectKey& KeyGlyphSize(bool opengl = false);
	static const iObjectKey& KeyGlyphSampleRate();
	static const iObjectKey& KeyConnectedToScalars();
	static const iObjectKey& KeyDataOffset();
};

//
//  Re-define SolidViewObject macros
//
#define IFIELDVIEWOBJECT_DECLARE_INHERITED_KEYS \
	ISOLIDVIEWOBJECT_DECLARE_INHERITED_KEYS; \
	static const iObjectKey& KeyColorBy(); \
	static const iObjectKey& KeyGlyphSize(bool opengl = false); \
	static const iObjectKey& KeyGlyphSampleRate(); \
	static const iObjectKey& KeyConnectedToScalars(); \
	static const iObjectKey& KeyDataOffset()


#define IFIELDVIEWOBJECT_DECLARE_INHERITED_MEMBERS \
	virtual float GetMemorySize() const; \
	virtual int GetDataOffset() const; \
	protected: \
	virtual void ResetPipelineInput(vtkImageData *input); \
	virtual void ResetPipeline(); \
	virtual void FieldViewObjectPackStateBody(iString &s) const; \
	virtual void FieldViewObjectUnPackStateBody(const iString &s); \
	virtual void FieldViewObjectSyncWithData(int info, void *data); \
	virtual void UpdateGlyphSize(); \
	virtual void UpdateGlyphSampleRate(); \
	virtual void ShowBody(bool s); \
	virtual void FinishInitialization(); \
	public: \
	virtual const iObjectType& RealType()


#define IVIEWOBJECT_DEFINE_INHERITED_KEYS_FIELD(_type_) \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewObject,_type_,ColorBy,cb,OffsetInt,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewObject,_type_,GlyphSampleRate,gr,Int,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewObject,_type_,ConnectedToScalars,cs,Bool,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewObject,_type_,DataOffset,-off,OffsetInt,1); \
	IOBJECT_DEFINE_INHERITED_DISTANCE_KEY(iFieldViewObject,_type_,GlyphSize,gs)

#endif // IFIELDVIEWOBJECT_H

