/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICROSSSECTIONSERIALPIPELINE_H
#define ICROSSSECTIONSERIALPIPELINE_H


#include "iserialpipeline.h"


class iOrthoPolygonPlaneFilter;
class iOrthoSlicer;
class iOrthoTexturePlaneFilter;
class iCrossSectionViewObject;
class iGridDataConverter;

class vtkImageData;


class iCrossSectionSerialPipeline : public iGridDataToPolyDataPipeline
{

	friend class iCrossSectionViewObject;
	
public:
	
	virtual iGridDataToPolyDataPipeline* Copy() const;
	virtual void AttachObservers(bool master);
	virtual float GetMemorySize() const;
		
	virtual void UpdateMethod();
	virtual void UpdateDir();
	virtual void UpdateVar();
	virtual void UpdatePos();
	virtual void UpdateResampleFactor();
	virtual void UpdateInterpolateData();
	
	void SetTexturePiece(vtkImageData *texture, int offX, int offY);

protected:
	
	iCrossSectionSerialPipeline(iCrossSectionViewObject *s);
	virtual ~iCrossSectionSerialPipeline();

	virtual void ProduceOutput(vtkImageData *input, vtkPolyData *output);

	void UpdateAll();

	iCrossSectionViewObject *mParent;

	//
	//  VTK stuff
	//
	iGridDataConverter *mDataConverter;
	iOrthoSlicer *mSlicer;
	iOrthoPolygonPlaneFilter *mOrthoPlane;
	iOrthoTexturePlaneFilter *mTextureConverter;
};

#endif // ICROSSSECTIONSERIALPIPELINE_H

