/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVISUALOBJECTFAMILY_H
#define IVISUALOBJECTFAMILY_H

class iVTK;

#include "ifamily.h"

template<class T>
class iVisualObjectFamily: public iFamily<T>
{
	
public:
		
	iVisualObjectFamily(iVTK *m):iFamily<T>(m){ vis = false; }
	virtual ~iVisualObjectFamily(){}

	inline bool isVisible(){ return vis; } 
	void show(bool s); 
	float getMemorySize();
	bool copy(iVisualObjectFamily<T> *p);
	int createMember();
	bool deleteMember(int i);
	void reset();
	void setDataChannel(int dc);
	void setDataStream(int ds);

private:

	bool vis;
		
};


template<class T>
void iVisualObjectFamily<T>::show(bool s)
{ 
	int j; 
	vis = s;
	for(j=0; j<=max; j++) memlist[j]->show(s); 
}


template<class T>
float iVisualObjectFamily<T>::getMemorySize()
{
	int j;
	float s = 0.0;
	for(j=0; j<=max; j++) s += memlist[j]->getMemorySize();
	return s;
}


template<class T>
int iVisualObjectFamily<T>::createMember()
{
	int ret = iFamily<T>::createMember();
	return ret;
}


template<class T>
bool iVisualObjectFamily<T>::deleteMember(int i)
{
	if(iFamily<T>::deleteMember(i)) return true;
	this->show(false);
	return false;
}


template<class T>
bool iVisualObjectFamily<T>::copy(iVisualObjectFamily<T> *p)
{
	int i;
	//
	//  Copy the array strcuture
	//
	T** newMemlist = new T*[p->maxMax];
	if(newMemlist == 0) return false;
	maxMax = p->maxMax;
	//
	//  Remove old members
	//
    for(i=0; i<=max; i++) delete memlist[i];
	delete [] memlist;
	memlist = newMemlist;
	max = p->max;
	cur = p->cur;
	//
	//  Create new members
	//
	for(i=0; i<=max; i++){
		memlist[i] = New();
		if(memlist[i] == 0)
		{
			max = i - 1;
			cur = 0;
			return false;
		}
		memlist[i]->copyState(p->memlist[i]);
	}
	show(p->vis);

	return true;
}


template<class T>
void iVisualObjectFamily<T>::reset()
{
	int j;
	for(j=0; j<=max; j++) memlist[j]->reset();
	show(false);
}


template<class T>
void iVisualObjectFamily<T>::setDataChannel(int dc)
{
	int j;
	for(j=0; j<=max; j++) memlist[j]->setDataChannel(dc);
}


template<class T>
void iVisualObjectFamily<T>::setDataStream(int ds)
{
	int j;
	for(j=0; j<=max; j++) memlist[j]->setDataStream(ds);
}

#endif // IVISUALOBJECTFAMILY_H
