/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
**  Simple shell aroung QT QString class
*/

#ifndef ISTRING_H
#define ISTRING_H

#include <qstring.h>
#include <qstringlist.h>
#include <qregexp.h>

class iString : public QString 
{

public:

	iString(QString s) : QString(s) {};
	iString(char *s) : QString(s) {};
	iString() : QString() {};
	iString& replace(iString target, const iString &replacement);
	iString& replace(uint index, uint len, const QString &s);
	int findWord(const QString & str, int index = 0) const;
	int findScriptWord(const QString & str, int index = 0) const;
	iString lowerScriptText();
	
};


class iStringList : public QStringList 
{
};


class iRegExp : public QRegExp
{

public:

	iRegExp(const char *s) : QRegExp(s) {};

};


inline iString& iString::replace(uint index, uint len, const QString &s)
{
	QString::replace(index,len,s);
	return *this;
}


inline iString& iString::replace(iString target, const iString &replacement)
{
	int i;
	while((i=this->find(target))>-1) QString::replace(i,target.length(),replacement);
	return *this;
}


inline int iString::findWord(const QString & str, int index) const
{
	int i = index;
	int l = str.length();

	while((i=this->find(str,i))>-1)
	{
		if(i>0 && this->at(i-1).isLetterOrNumber()) { i+=l; continue; }
		if(i+l<(int)this->length() && this->at(i+l).isLetterOrNumber()) { i+=l; continue; }
		break;
	}
	return i;
}

inline int iString::findScriptWord(const QString & str, int index) const
{
	int i = index;
	int l = str.length();

	while((i=this->find(str,i))>-1)
	{
		if(i>0 && (this->at(i-1).isLetterOrNumber()||this->at(i-1)=='-')) { i+=l; continue; }
		if(i+l<(int)this->length() && (this->at(i+l).isLetterOrNumber()||this->at(i-1)=='-')) { i+=l; continue; }
		break;
	}
	return i;
}

inline iString iString::lowerScriptText()
{
	int i1 = 0, i2 = this->find('"');
	iString ret;
	while(i2 != -1)
	{
		if(i2 > i1) ret += this->mid(i1,i2-i1).lower();
		i1 = i2;
		i2 = this->find('"',i2+1);
		if(i2 != -1) 
		{
			ret += this->mid(i1,i2-i1+1);  
			i1 = i2 + 1;
			i2 = this->find('"',i1);
		}
	}
	ret += this->mid(i1).lower();
	return ret;
}

#endif // ISTRING_H
 

