/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************

  Global variables

****************************************************************************/

#ifndef IGLOBALS_H
#define IGLOBALS_H

//
//  Version control
//

#include <vtkVersion.h>

#define I_VTK_VERSION 0

#if (VTK_MAJOR_VERSION == 4 && VTK_MINOR_VERSION == 4)
	#undef I_VTK_VERSION
	#define I_VTK_VERSION 44
	#define vtkFloat double
#endif

#if (VTK_MAJOR_VERSION == 4 && VTK_MINOR_VERSION == 2)
	#undef I_VTK_VERSION
	#define I_VTK_VERSION 42
	#define I_VTK_VERSION_42
	#define vtkFloat float
	#define VTKFLOAT_IS_FLOAT
#endif

#if (VTK_MAJOR_VERSION == 4 && VTK_MINOR_VERSION == 0)
	#undef I_VTK_VERSION
	#define I_VTK_VERSION 40
	#define I_VTK_VERSION_40
	#define vtkFloat float
	#define VTKFLOAT_IS_FLOAT
#endif

#if (I_VTK_VERSION == 0)
#error FATAL ERROR: IFRIT has not been ported to this version of VTK
$TERMINATE$
#endif

//
//  Major constants
//

#define NVARMAX 3
#define NATTMAX	3
#define NVECMAX	1
#define NTENMAX	1

#define NWIDMAX		100

#define MAXDATACHANNEL	1

#define NICE_DEFAULT_COLOR iColor(120,180,180)


#endif // IGLOBALS_H
