/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#include <qlistbox.h>

QPixmap image(char *s);

void iDialogErrorlist::init()
{
	
    PixmapLabel->setPixmap(image("error.png"));
    
    ErrorListBox = new QListBox(this);
    if(ErrorListBox != 0)
    {
		ErrorListBox->setMinimumHeight(160);
		this->setExtension(ErrorListBox);
		this->setOrientation(Qt::Vertical );
		this->showExtension(false);
	}
    
}


void iDialogErrorlist::destroy()
{
    delete ErrorListBox;
}


void iDialogErrorlist::addErrorMessage( int n, QString &m )
{
	
    QString s;
    s = "Line " + s.setNum(n+1) + ": " + m;
	ErrorListBox->insertItem(s,-1);
	
}


void iDialogErrorlist::showDetails( bool s )
{
    this->showExtension(s);
}


void iDialogErrorlist::clearList()
{
    ErrorListBox->clear();
}


