/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICAPTION_H
#define ICAPTION_H


#include <vtkCaptionActor2D.h>

class vtkPolyData;
class vtkPolyDataMapper2D;
class vtkPolyDataMapper;
class vtkActor2D;
class vtkActor;
class vtkTextMapper;


class iCaption: public vtkCaptionActor2D
{
	
public:
	
	static iCaption *New();
	
	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual void setFontSize(int s);
	inline int getFontSize(){ return fontSize; }

	virtual void setLeader3D(bool s){ leader3D = true; }
	inline bool getLeader3D(){return leader3D; }

protected:
	
	iCaption();
	~iCaption();
	
private:

	int fontSize;
	float unmagx1[2], unmagx2[2];
	bool leader3D;
	//
	//  Need new border and leader since they are declared private in the parent class
	//
	vtkPolyData         *borderPolyData;
	vtkPolyDataMapper2D *borderMapper;
	vtkActor2D          *borderActor;
	
	// for 2D leader
	vtkPolyData         *leaderPolyData;
	vtkPolyDataMapper2D *leaderMapper2D;
	vtkActor2D          *leaderActor2D;

	// for 3D leader
	vtkPolyDataMapper   *leaderMapper3D;
	vtkActor            *leaderActor3D;

	vtkTextMapper *tmpMapper;

};

#endif // ICAPTION_H
