/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fts.h>

#include <qfileinfo.h>
#include <qdir.h>

#include "ifpinterface.h"
#include "ifprecconv.h"

int cancel_progress;
QLibrary *ifpLib = NULL;
bool usingLibrary = FALSE;
bool errorInLibrary = FALSE;
QString ifpLibraryVersion;

// ifp_init
my_ifp_init ifpgui_ifp_init;
// ifp_finalize
my_ifp_finalize ifpgui_ifp_finalize;
// ifp_find_device
my_ifp_find_device ifpgui_ifp_find_device;
// ifp_release_device;
my_ifp_release_device ifpgui_ifp_release_device;
// ifp_format
my_ifp_format ifpgui_ifp_format;
// ifp_update_firmware
my_ifp_update_firmware ifpgui_ifp_update_firmware;
// ifp_device_info
my_ifp_device_info ifpgui_ifp_device_info;
// ifp_battery
my_ifp_battery ifpgui_ifp_battery;
// ifp_capacity
my_ifp_capacity ifpgui_ifp_capacity;
// ifp_freespace
my_ifp_freespace ifpgui_ifp_freespace;
// ifp_model
my_ifp_model ifpgui_ifp_model;
// ifp_delta
my_ifp_delta ifpgui_ifp_delta;
// ifp_firmware_version
my_ifp_firmware_version ifpgui_ifp_firmware_version;
// ifp_error_message
my_ifp_error_message ifpgui_ifp_error_message;
// ifp_rename
my_ifp_rename ifpgui_ifp_rename;
// ifp_delete
my_ifp_delete ifpgui_ifp_delete;
// ifp_mkdir
my_ifp_mkdir ifpgui_ifp_mkdir;
// ifp_rmdir
my_ifp_rmdir ifpgui_ifp_rmdir;
// ifp_list_dirs
my_ifp_list_dirs ifpgui_ifp_list_dirs;
// ifp_read_file_progress
my_ifp_read_file_progress ifpgui_ifp_read_file_progress;
// ifp_write_file_progress
my_ifp_write_file_progress ifpgui_ifp_write_file_progress;
// ifp_download_file
my_ifp_download_file ifpbase_ifp_download_file;
// ifp_upload_file
my_ifp_upload_file ifpgui_ifp_upload_file;
// ifp_delete_dir_recursive
my_ifp_delete_dir_recursive ifpgui_ifp_delete_dir_recursive;
// ifp_download_dir
my_ifp_download_dir ifpgui_ifp_download_dir;
// ifp_upload_dir
my_ifp_upload_dir ifpgui_ifp_upload_dir;
// ifp_is_file
my_ifp_is_file ifpgui_ifp_is_file;
// ifp_is_dir
my_ifp_is_dir ifpgui_ifp_is_dir;
// ifp_exists
my_ifp_exists ifpgui_ifp_exists;
// ifp_get_tuner_presets
my_ifp_get_tuner_presets ifpgui_ifp_get_tuner_presets;
// ifp_set_tuner_presets
my_ifp_set_tuner_presets ifpgui_ifp_set_tuner_presets;
// ifp_get_station
my_ifp_get_station ifpgui_ifp_get_station;
// ifp_set_station
my_ifp_set_station ifpgui_ifp_set_station;


usb_dev_handle    *ifp_dh  = NULL;
struct usb_device *usb_dev = NULL;
struct ifp_device ifp_dev;

//-----------------------------------------------------------
// helper functions
//-----------------------------------------------------------
void print_library_error(void)
   {
   errorInLibrary = TRUE;
   fprintf(stderr, "The ifplib Library is missing one or more functions.\n");
   fprintf(stderr, "Please get the latest version from http://ifp-driver.sourcefourge.net.\n\n");
   fprintf(stderr, "USING THE INTERNAL STATIC VERSIONS OF THE FUNCTIONS.\n");
   }

//===========================================================================
// initialize_ifp_device()
//   This function will initialize the usb bus, find the iFP usb device,
//   claim the iFP interface, and initialize the iFP library
//
//   Returns: %IFP_OK if successful, %IFP_ERR_DEV_FUBAR on error
//===========================================================================
int initialize_ifp_device(void)
{
   int ret;

   ret = IFP_ERR_DEV_FUBAR;

   ifpLib = new QLibrary("ifp");

// ifp_init
   ifpgui_ifp_init = (my_ifp_init)ifpLib->resolve("ifp_init");
   if (ifpgui_ifp_init == NULL)
      {
      ifpgui_ifp_init = ifp_init;
      }

   usingLibrary = ifpLib->isLoaded();
   if (usingLibrary)
      {
      ifpLibraryVersion = ifpLib->library();
      }
   else
      {
      ifpLibraryVersion = "";
      }

   if (usingLibrary)
      {
   // ifp_finalize
      ifpgui_ifp_finalize = (my_ifp_finalize)ifpLib->resolve("ifp_finalize");
      if (ifpgui_ifp_finalize == NULL)
         {
         printf("ERROR: ifp_finalize() not available in libifp\n");
         print_library_error();
         }
   // ifp_find_device
      ifpgui_ifp_find_device = (my_ifp_find_device)ifpLib->resolve("ifp_find_device");
      if (ifpgui_ifp_find_device == NULL)
         {
         printf("ERROR: ifp_find_device() not available in libifp\n");
         print_library_error();
         }
   // ifp_release_device
      ifpgui_ifp_release_device = (my_ifp_release_device)ifpLib->resolve("ifp_release_device");
      if (ifpgui_ifp_release_device == NULL)
         {
         printf("ERROR: ifp_release_device() not available in libifp\n");
         print_library_error();
         }
   // ifp_format
      ifpgui_ifp_format = (my_ifp_format)ifpLib->resolve("ifp_format");
      if (ifpgui_ifp_format == NULL)
         {
         printf("ERROR: ifp_format() not available in libifp\n");
         print_library_error();
         }
   // ifp_update_firmware
      ifpgui_ifp_update_firmware = (my_ifp_update_firmware)ifpLib->resolve("ifp_update_firmware");
      if (ifpgui_ifp_update_firmware == NULL)
         {
         printf("ERROR: ifp_update_firmware() not available in libifp\n");
         print_library_error();
         }
   // ifp_device_info
      ifpgui_ifp_device_info = (my_ifp_device_info)ifpLib->resolve("ifp_device_info");
      if (ifpgui_ifp_device_info == NULL)
         {
         printf("ERROR: ifp_device_info() not available in libifp\n");
         print_library_error();
         }
   // ifp_battery
      ifpgui_ifp_battery = (my_ifp_battery)ifpLib->resolve("ifp_battery");
      if (ifpgui_ifp_battery == NULL)
         {
         printf("ERROR: ifp_battery() not available in libifp\n");
         print_library_error();
         }
   // ifp_capacity
      ifpgui_ifp_capacity = (my_ifp_capacity)ifpLib->resolve("ifp_capacity");
      if (ifpgui_ifp_capacity == NULL)
         {
         printf("ERROR: ifp_capacity() not available in libifp\n");
         print_library_error();
         }
   // ifp_freespace
      ifpgui_ifp_freespace = (my_ifp_freespace)ifpLib->resolve("ifp_freespace");
      if (ifpgui_ifp_freespace == NULL)
         {
         printf("ERROR: ifp_freespace() not available in libifp\n");
         print_library_error();
         }
   // ifp_model
      ifpgui_ifp_model = (my_ifp_model)ifpLib->resolve("ifp_model");
      if (ifpgui_ifp_model == NULL)
         {
         printf("ERROR: ifp_model() not available in libifp\n");
         print_library_error();
         }
   // ifp_delta
      ifpgui_ifp_delta = (my_ifp_delta)ifpLib->resolve("ifp_delta");
      if (ifpgui_ifp_delta == NULL)
         {
         printf("ERROR: ifp_delta() not available in libifp\n");
         print_library_error();
         }
   // ifp_firmware_version
      ifpgui_ifp_firmware_version = (my_ifp_firmware_version)ifpLib->resolve("ifp_firmware_version");
      if (ifpgui_ifp_firmware_version == NULL)
         {
         printf("ERROR: ifp_firmware_version() not available in libifp\n");
         print_library_error();
         }
   // ifp_error_message
      ifpgui_ifp_error_message = (my_ifp_error_message)ifpLib->resolve("ifp_error_message");
      if (ifpgui_ifp_error_message == NULL)
         {
         printf("ERROR: ifp_error_message() not available in libifp\n");
         print_library_error();
         }
   // ifp_rename
      ifpgui_ifp_rename = (my_ifp_rename)ifpLib->resolve("ifp_rename");
      if (ifpgui_ifp_rename == NULL)
         {
         printf("ERROR: ifp_rename() not available in libifp\n");
         print_library_error();
         }
   // ifp_delete
      ifpgui_ifp_delete = (my_ifp_delete)ifpLib->resolve("ifp_delete");
      if (ifpgui_ifp_delete == NULL)
         {
         printf("ERROR: ifp_delete() not available in libifp\n");
         print_library_error();
         }
   // ifp_mkdir
      ifpgui_ifp_mkdir = (my_ifp_mkdir)ifpLib->resolve("ifp_mkdir");
      if (ifpgui_ifp_mkdir == NULL)
         {
         printf("ERROR: ifp_mkdir() not available in libifp\n");
         print_library_error();
         }
   // ifp_rmdir
      ifpgui_ifp_rmdir = (my_ifp_rmdir)ifpLib->resolve("ifp_rmdir");
      if (ifpgui_ifp_rmdir == NULL)
         {
         printf("ERROR: ifp_rmdir() not available in libifp\n");
         print_library_error();
         }
   // ifp_list_dirs
      ifpgui_ifp_list_dirs = (my_ifp_list_dirs)ifpLib->resolve("ifp_list_dirs");
      if (ifpgui_ifp_list_dirs == NULL)
         {
         printf("ERROR: ifp_list_dirs() not available in libifp\n");
         print_library_error();
         }
   // ifp_read_file_progress
      ifpgui_ifp_read_file_progress = (my_ifp_read_file_progress)ifpLib->resolve("ifp_read_file_progress");
      if (ifpgui_ifp_read_file_progress == NULL)
         {
         printf("ERROR: ifp_read_file_progress() not available in libifp\n");
         print_library_error();
         }
   // ifp_write_file_progress
      ifpgui_ifp_write_file_progress = (my_ifp_write_file_progress)ifpLib->resolve("ifp_write_file_progress");
      if (ifpgui_ifp_write_file_progress == NULL)
         {
         printf("ERROR: ifp_write_file_progress() not available in libifp\n");
         print_library_error();
         }
   // ifp_download_file
      ifpbase_ifp_download_file = (my_ifp_download_file)ifpLib->resolve("ifp_download_file");
      if (ifpbase_ifp_download_file == NULL)
         {
         printf("ERROR: ifp_download_file() not available in libifp\n");
         print_library_error();
         }
   // ifp_upload_file
      ifpgui_ifp_upload_file = (my_ifp_upload_file)ifpLib->resolve("ifp_upload_file");
      if (ifpgui_ifp_upload_file == NULL)
         {
         printf("ERROR: ifp_upload_file() not available in libifp\n");
         print_library_error();
         }
   // ifp_delete_dir_recursive
      ifpgui_ifp_delete_dir_recursive = (my_ifp_delete_dir_recursive)ifpLib->resolve("ifp_delete_dir_recursive");
      if (ifpgui_ifp_delete_dir_recursive == NULL)
         {
         printf("ERROR: ifp_delete_dir_recursive() not available in libifp\n");
         print_library_error();
         }
   // ifp_download_dir
      ifpgui_ifp_download_dir = (my_ifp_download_dir)ifpLib->resolve("ifp_download_dir");
      if (ifpgui_ifp_download_dir == NULL)
         {
         printf("ERROR: ifp_download_dir() not available in libifp\n");
         print_library_error();
         }
   // ifp_upload_dir
      ifpgui_ifp_upload_dir = (my_ifp_upload_dir)ifpLib->resolve("ifp_upload_dir");
      if (ifpgui_ifp_upload_dir == NULL)
         {
         printf("ERROR: ifp_upload_dir() not available in libifp\n");
         print_library_error();
         }
   // ifp_is_file
      ifpgui_ifp_is_file = (my_ifp_is_file)ifpLib->resolve("ifp_is_file");
      if (ifpgui_ifp_is_file == NULL)
         {
         printf("ERROR: ifp_is_file() not available in libifp\n");
         print_library_error();
         }
   // ifp_is_dir
      ifpgui_ifp_is_dir = (my_ifp_is_dir)ifpLib->resolve("ifp_is_dir");
      if (ifpgui_ifp_is_dir == NULL)
         {
         printf("ERROR: ifp_is_dir() not available in libifp\n");
         print_library_error();
         }
   // ifp_exists
      ifpgui_ifp_exists = (my_ifp_exists)ifpLib->resolve("ifp_exists");
      if (ifpgui_ifp_exists == NULL)
         {
         printf("ERROR: ifp_exists() not available in libifp\n");
         print_library_error();
         }
   // ifp_get_tuner_presets
      ifpgui_ifp_get_tuner_presets = (my_ifp_get_tuner_presets)ifpLib->resolve("ifp_get_tuner_presets");
      if (ifpgui_ifp_get_tuner_presets == NULL)
         {
         printf("ERROR: ifp_get_tuner_presets() not available in libifp\n");
         print_library_error();
         }
   // ifp_set_tuner_presets
      ifpgui_ifp_set_tuner_presets = (my_ifp_set_tuner_presets)ifpLib->resolve("ifp_set_tuner_presets");
      if (ifpgui_ifp_set_tuner_presets == NULL)
         {
         printf("ERROR: ifp_set_tuner_presets() not available in libifp\n");
         print_library_error();
         }
   // ifp_get_station
      ifpgui_ifp_get_station = (my_ifp_get_station)ifpLib->resolve("ifp_get_station");
      if (ifpgui_ifp_get_station == NULL)
         {
         printf("ERROR: ifp_get_station() not available in libifp\n");
         print_library_error();
         }
   // ifp_set_station
      ifpgui_ifp_set_station = (my_ifp_set_station)ifpLib->resolve("ifp_set_station");
      if (ifpgui_ifp_set_station == NULL)
         {
         printf("ERROR: ifp_set_station() not available in libifp\n");
         print_library_error();
         }
      }

   //-------------------------------------------------------------------------
   // if there was an error loading the library or the library was not found
   //-------------------------------------------------------------------------
   if ((errorInLibrary) || (!usingLibrary))
      {
   // ifp_finalize
      ifpgui_ifp_finalize = ifp_finalize;
   // ifp_find_device
      ifpgui_ifp_find_device = ifp_find_device;
   // ifp_release_device
      ifpgui_ifp_release_device = ifp_release_device;
   // ifp_format
      ifpgui_ifp_format = ifp_format;
   // ifp_update_firmware
      ifpgui_ifp_update_firmware = ifp_update_firmware;
   // ifp_device_info
      ifpgui_ifp_device_info = ifp_device_info;
   // ifp_battery
      ifpgui_ifp_battery = ifp_battery;
   // ifp_capacity
      ifpgui_ifp_capacity = ifp_capacity;
   // ifp_freespace
      ifpgui_ifp_freespace = ifp_freespace;
   // ifp_model
      ifpgui_ifp_model = ifp_model;
   // ifp_delta
      ifpgui_ifp_delta = ifp_delta;
   // ifp_firmware_version
      ifpgui_ifp_firmware_version = ifp_firmware_version;
   // ifp_error_message
      ifpgui_ifp_error_message = ifp_error_message;
   // ifp_rename
      ifpgui_ifp_rename = ifp_rename;
   // ifp_delete
      ifpgui_ifp_delete = ifp_delete;
   // ifp_mkdir
      ifpgui_ifp_mkdir = ifp_mkdir;
   // ifp_rmdir
      ifpgui_ifp_rmdir = ifp_rmdir;
   // ifp_list_dirs
      ifpgui_ifp_list_dirs = ifp_list_dirs;
   // ifp_read_file_progress
      ifpgui_ifp_read_file_progress = ifp_read_file_progress;
   // ifp_write_file_progress
      ifpgui_ifp_write_file_progress = ifp_write_file_progress;
   // ifp_download_file
      ifpbase_ifp_download_file = ifp_download_file;
   // ifp_upload_file
      ifpgui_ifp_upload_file = ifp_upload_file;
   // ifp_delete_dir_recursive
      ifpgui_ifp_delete_dir_recursive = ifp_delete_dir_recursive;
   // ifp_download_dir
      ifpgui_ifp_download_dir = ifp_download_dir;
   // ifp_upload_dir
      ifpgui_ifp_upload_dir = ifp_upload_dir;
   // ifp_is_file
      ifpgui_ifp_is_file = ifp_is_file;
   // ifp_is_dir
      ifpgui_ifp_is_dir = ifp_is_dir;
   // ifp_exists
      ifpgui_ifp_exists = ifp_exists;
   // ifp_get_tuner_presets
      ifpgui_ifp_get_tuner_presets = ifp_get_tuner_presets;
   // ifp_set_tuner_presets
      ifpgui_ifp_set_tuner_presets = ifp_set_tuner_presets;
   // ifp_get_station
      ifpgui_ifp_get_station = ifp_get_station;
   // ifp_set_station
      ifpgui_ifp_set_station = ifp_set_station;
      }
   //---------------------------------------------------------------------------
   // initialize ifp device
   //---------------------------------------------------------------------------
   usb_init();
   ifp_dh = (usb_dev_handle*)ifpgui_ifp_find_device();
   if (ifp_dh == NULL)
      {
      return(ret);
      }

   usb_dev = usb_device(ifp_dh);
   if (usb_dev == NULL)
      {
      release_ifp_device();
      return(ret);
      }

   /* "must be called" written in the libusb documentation */
   if (usb_claim_interface(ifp_dh, usb_dev->config->interface->altsetting->bInterfaceNumber))
      {
      fprintf(stderr, "Device is busy.  (I was unable to claim its interface.)\n");
      release_ifp_device();
      return(ret);
      }

   ret = ifpgui_ifp_init(&ifp_dev, ifp_dh);
   if (ret != IFP_OK)
      {
      release_ifp_device();
      ret = IFP_ERR_DEV_FUBAR;
      }

   return(ret);
}


//===========================================================================
// release_ifp_device()
//   This function will release all the resources created with
//   initialize_ifp_device().  Call this function when you are finished
//   the iFP device.
//
//   Returns: %IFP_OK if successful
//===========================================================================
int release_ifp_device(void)
{
   int ret;

   ret = IFP_OK;
   if ((ifp_dh != NULL) && (usb_dev != NULL))
      {
      ret = ifpgui_ifp_finalize(&ifp_dev);
      usb_release_interface(ifp_dh, usb_dev->config->interface->altsetting->bInterfaceNumber);
      }
   if (ifp_dh != NULL)
      {
      ifpgui_ifp_release_device(ifp_dh);
      }
   ifp_dh  = NULL;
   usb_dev = NULL;

   delete ifpLib;
   ifpLib = NULL;

   return(ret);
}

int ifpgui_ifp_download_file(struct ifp_device * dev,
        const char * remotefile, const char * localfile,
        ifp_progress fn, void * fn_context)
   {
   int ret, conv_ret;
   char ext[10], newfile[1000];

   ret = ifpbase_ifp_download_file(dev, remotefile, localfile, fn, fn_context);
   if ((ret == IFP_OK) && FALSE)// && (convert))
      {
      //---------------------------------------------------------------
      // convert the *.rec file
      //---------------------------------------------------------------
      ext[0] = remotefile[strlen(remotefile) - 4]; // .
      ext[1] = remotefile[strlen(remotefile) - 3]; // r or R
      ext[2] = remotefile[strlen(remotefile) - 2]; // e or E
      ext[3] = remotefile[strlen(remotefile) - 1]; // c or C
      if ((strncmp(ext,".rec",4) == 0) || (strncmp(ext,".REC",4) == 0))
         {
         // do conversion
         strncpy(newfile, localfile, 999);
         newfile[999] = '\0';
         if (strlen(newfile) != strlen(localfile))
            {
            fprintf(stderr, "File name length greater than 1000.\r\n");
            fprintf(stderr, "Cannot convert REC file to MP3.\r\n");
            return(ret);
            }
         newfile[strlen(localfile) - 3] = 'w';
         newfile[strlen(localfile) - 2] = 'a';
         newfile[strlen(localfile) - 1] = 'v';
         conv_ret = ifprecconv(localfile, newfile);
         if (conv_ret == 77)
            {
            newfile[strlen(localfile) - 3] = 'm';
            newfile[strlen(localfile) - 2] = 'p';
            newfile[strlen(localfile) - 1] = '3';
            rename(localfile, newfile);
            }
         else if (!conv_ret)
            {
            // lame sample.wav sample.mp3
            // lame -h sample.wav sample.mp3  // highest quality
            // lame -r sample.rec sample.mp3  // assume raw format ??? this might work or might not
            }
         }
      }
   return(ret);
   }

