/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qmessagebox.h>
#include <qdir.h>

#include "ifptoolbar.h"

QString app_path;

ifpToolsWidget::ifpToolsWidget( QMainWindow *parent, const char *name )
      : QToolBar( parent, name )
   {
   QStringList tmp_str_list;

   BatteryStatus = new QLabel(tr("BatteryStatus"), this);
   BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery0.png"));
   QToolTip::add( BatteryStatus, tr("Battery Status") );
   QString batteryStatusText = tr("<p>This status bar shows the Battery Status.</p>");
   QWhatsThis::add(BatteryStatus, batteryStatusText);

   space1        = new QLabel("      ", this);

   CapacityStatus = new QProgressBar(100000, this, "CapacityStatus");
   QToolTip::add(CapacityStatus, tr("Used Storage"));
   QString CapacityStatusText = tr("<p>This shows the ammount of space used by uploaded songs and files.</p>");
   QWhatsThis::add(CapacityStatus, CapacityStatusText);

   Capacitylbl      = new QLabel(tr("   MB"), this);
   Capacitylbl->setAlignment(int(QLabel::AlignVCenter | QLabel::AlignLeft));
   QToolTip::add(Capacitylbl, tr("Free Storage") );
   QString CapacityText = tr("<p>This shows the ammount of space used by uploaded songs and files.</p>");
   QWhatsThis::add(Capacitylbl, CapacityText);

   space2        = new QLabel("      ", this);

   UploadPlaylist = new QPushButton("UploadPlaylist", this);
   UploadPlaylist->setMinimumSize(50,30);
   UploadPlaylist->setFocusPolicy(QWidget::NoFocus);
   UploadPlaylist->setPixmap(QPixmap::fromMimeSource("playlist.png"));
   QToolTip::add(UploadPlaylist, tr("Upload Playlist to iFP"));
   QString UploadPlaylistText =
      tr("<p>Select a destination on the iFP device.  Then, press this button to upload an m3u playist to the iFP device at the selected destination.</p>");
   QWhatsThis::add(UploadPlaylist, UploadPlaylistText);

   Upload        = new QPushButton("Upload", this);
   Upload->setMinimumSize(50,30);
   Upload->setFocusPolicy(QWidget::NoFocus);
   Upload->setPixmap(QPixmap::fromMimeSource("upload_s.png"));
   QToolTip::add(Upload, tr("Upload File to iFP"));
   QString UploadText = tr("<p>Select a file from the left and press this button to upload it to the iFP device.</p>");
   QWhatsThis::add(Upload, UploadText);
   //Upload->setText("Upload");

   Download      = new QPushButton("Download", this);
   Download->setMinimumSize(50,30);
   Download->setFocusPolicy(QWidget::NoFocus);
   Download->setPixmap(QPixmap::fromMimeSource("download_s.png"));
   QToolTip::add(Download, tr("Download File from iFP"));
   QString DownloadText = tr("<p>Select a file from the right and press this button to download it to your hard drive.</p>");
   QWhatsThis::add(Download, DownloadText);
   //Download->setText("Download");

   space3        = new QLabel("      ", this);

   RadioFreq     = new QPushButton("RadioFreq", this);
   RadioFreq->setMinimumSize(50,30);
   RadioFreq->setFocusPolicy(QWidget::NoFocus);
   RadioFreq->setPixmap(QPixmap::fromMimeSource("radio_s.png"));
   QToolTip::add(RadioFreq, tr("Edit Radio Frequency Settings"));
   QString RadioFreqText = tr("<p>Press this button to open the dialog that allows you to edit the radio frequency settings for your iFP device.</p>");
   QWhatsThis::add(RadioFreq, RadioFreqText);

   space4        = new QLabel("                      ", this);

   Format        = new QPushButton("Format", this);
   Format->setMinimumSize(50,30);
   Format->setFocusPolicy(QWidget::NoFocus);
   Format->setPixmap(QPixmap::fromMimeSource("format_s.png"));
   QToolTip::add(Format, tr("Format iFP Flash"));
   QString FormatText = tr("<p>Press this button to format the iFP device.</p>");
   QWhatsThis::add(Format, FormatText);
   //Format->setText("Format");

   UpdateFirmware = new QPushButton("UpdateFirmware", this);
   UpdateFirmware->setMinimumSize(50,30);
   UpdateFirmware->setFocusPolicy(QWidget::NoFocus);
   UpdateFirmware->setPixmap(QPixmap::fromMimeSource("reload_s.png"));
   QToolTip::add(UpdateFirmware, tr("Update iFP Firmware"));
   QString UpdateFirmwareText = tr("<p>Use this to update the iFP device firmware.</p> <br>"
                                   "<p>You must first download a firmware file and save it to your hard drive.</p><br>" );
   QWhatsThis::add( UpdateFirmware, UpdateFirmwareText );

   connect(UploadPlaylist, SIGNAL(clicked()),
           this, SLOT(sUploadPlaylistClicked()));
   connect(Upload, SIGNAL(clicked()),
           this, SLOT(sUploadClicked()));
   connect(Download, SIGNAL(clicked()),
           this, SLOT(sDownloadClicked()));
   connect(Format, SIGNAL(clicked()),
           this, SLOT(sFormatClicked()));
   connect(UpdateFirmware, SIGNAL(clicked()),
           this, SLOT(sUpdateFirwareClicked()));
   connect(RadioFreq, SIGNAL(clicked()),
           this, SLOT(sRadioFreqClicked()));
   }


ifpToolsWidget::~ifpToolsWidget()
   {
   }

void ifpToolsWidget::RefreshAll()
{

}

void ifpToolsWidget::sBatteryStatus(int bStatus)
{
   switch (bStatus)
      {
      case 1:
         BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery1.png"));
         break;
      case 2:
         BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery2.png"));
         break;
      case 3:
         BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery3.png"));
         break;
      case 4:
         BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery4.png"));
         break;
      default:
         BatteryStatus->setPixmap(QPixmap::fromMimeSource("battery0.png"));
      }
}


void ifpToolsWidget::sCapacity(int capSize, int capFree)
{
   int sizeMB;

   CapacityStatus->setProgress(capSize - capFree, capSize);
   sizeMB = capFree / 1000000;
   Capacitylbl->setText(tr("%1 MB\n  free").arg(sizeMB));
}

void ifpToolsWidget::sUploadPlaylistClicked(void)
{
   emit UploadPlaylistClicked();
}

void ifpToolsWidget::sUploadClicked(void)
{
   emit UploadClicked();
}

void ifpToolsWidget::sDownloadClicked(void)
{
   emit DownloadClicked();
}

void ifpToolsWidget::sFormatClicked(void)
{
   emit FormatClicked();
}

void ifpToolsWidget::sUpdateFirwareClicked(void)
{
   emit UpdateFirwareClicked();
}

void ifpToolsWidget::sRadioFreqClicked(void)
{
   emit RadioFreqClicked();
}

void ifpToolsWidget::sShowToolbarText(void)
   {
   lblBatteryStatus->hide();
   lblCapacityStatus->hide();
   lblUpload->hide();
   lblDownload->hide();
   lblspace2->hide();
   lblFormat->hide();
   lblUpdateFirmware->hide();
   setMinimumSize(500,  40); // width, height
   setMaximumSize(2000, 40); // width, height
   }

void ifpToolsWidget::sHideToolbarText(void)
   {
   lblBatteryStatus->show();
   lblCapacityStatus->show();
   lblUpload->show();
   lblDownload->show();
   lblspace2->show();
   lblFormat->show();
   lblUpdateFirmware->show();
   setMinimumSize(500,  50); // width, height
   setMaximumSize(2000, 50); // width, height
   }
