/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XImlib2Background.cpp
 *
 * Copyright (c) 2005, FixXxeR (avelar@gmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "XImlib2Background.h"
#include "Database.h"

XImlib2Background::XImlib2Background(AbstractContainer * c, AbstractConfig * con) : container(c), config(con)
{

}

XImlib2Background::~XImlib2Background()
{
}

Pixmap XImlib2Background::getBackgroundPixmap()
{
      Pixmap pixmap, mask; 
      DesktopConfig * dConfig =
		    dynamic_cast<DesktopConfig *>(config);
       
      XDesktopContainer * xContainer =
                    dynamic_cast<XDesktopContainer *>(container);

      string file = dConfig->getFileBackground().c_str();

      if(file != "None"){

	Imlib_Image image = imlib_load_image(file.c_str());

        if (!image){
		file = string(DEFAULT_PREFIX) + "/share/" + string(PACKAGE) + "/wall_default.png";
		image = imlib_load_image(file.c_str());
	}
     
	if(image){
	  imlib_context_set_image(image);

	  w = imlib_image_get_width();
	  h = imlib_image_get_height();
	  imlib_context_set_blend(1);
	  imlib_blend_image_onto_image(image, 0,
				       0, 0,  w, h,
				       0, 0,  w, h);

	  imlib_render_image_on_drawable_at_size(0, 0, w , h);
	  imlib_render_pixmaps_for_whole_image (&pixmap, &mask);
	  XSetWindowBackgroundPixmap (xContainer->getDisplay(), xContainer->getRootWindow(), pixmap);
	  imlib_free_image();
	}
      }
     return pixmap;
}
