/*
        IcuKrell 2.0.0-pre0.1 - drJeckyll <drJeckyll@hotmail.com>
*/

#include "icukrell.h"

static gchar *full_file;

void make_file_name(gchar *file_name)
{
	gchar myfile[255];
	FILE *fd, *fd1, *fd2;

	sprintf(myfile, "%s/.icq/icons/%s/%s", getenv("HOME"), icukrell_theme_name, file_name);

	if ((fd = fopen(myfile, "rb")) == NULL)
	{
		sprintf(myfile, "%s/icons/%s/%s", GNOMEICU_INSTALL_DIR, icukrell_theme_name, file_name);

		if ((fd1 = fopen(myfile, "rb")) == NULL)
		{
			sprintf(myfile, "%s/icons/Default/%s", GNOMEICU_INSTALL_DIR, file_name);

			if ((fd2 = fopen(myfile, "rb")) == NULL)
			{
				sprintf(myfile, "NOT FOUND");
			} else fclose(fd2);
		} else fclose(fd1);
	} else fclose(fd);

	full_file = g_strdup(myfile);
}

void create_piximage(gchar *file_name, GdkPixmap **my_pixmap, GdkBitmap **my_bitmap)
{
	GkrellmPiximage *im;

	make_file_name(file_name);

#ifdef TEST_MODE
	fprintf(stderr, "init image: [%s]\n", full_file);
#endif
	im = gkrellm_piximage_new_from_file(full_file);
	gkrellm_scale_piximage_to_pixmap(im, my_pixmap, my_bitmap, 0, 0);
	gkrellm_destroy_piximage(im);
}

gboolean init_pixmaps()
{
#ifdef TEST_MODE
	fprintf(stderr, "init_pixmaps...\n");
#endif

	create_piximage("gnomeicu-offline.png", &offline_pixmap, &offline_bitmap);
	/*im = gdk_imlib_load_image(full_file);
	gdk_imlib_render(im, im->rgb_width, im->rgb_height);
        offline_pixmap = gdk_imlib_copy_image(im);
        offline_bitmap = gdk_imlib_copy_mask(im);
        gdk_imlib_destroy_image(im);*/
	create_piximage("gnomeicu-online.png", &online_pixmap, &online_bitmap);
	create_piximage("gnomeicu-inv.png", &inv_pixmap, &inv_bitmap);
	create_piximage("gnomeicu-na.png", &na_pixmap, &na_bitmap);
	create_piximage("gnomeicu-ffc.png", &chat_pixmap, &chat_bitmap);
	create_piximage("gnomeicu-occ.png", &occ_pixmap, &occ_bitmap);
	create_piximage("gnomeicu-away.png", &away_pixmap, &away_bitmap);
	create_piximage("gnomeicu-dnd.png", &dnd_pixmap, &dnd_bitmap);
	create_piximage("gnomeicu-message.png", &message_pixmap, &message_bitmap);

	return TRUE;
}
