package CParse::Union;

use 5.6.0;
use strict;
use warnings;

use CType::Union;
use CType::Ref;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $tag = shift;
    my $declarations = shift;
    my $attributes1 = shift;
    my $attributes2 = shift;
    my $self = {tag => $tag,
                declarations => $declarations,
                attributes1 => $attributes1,
                attributes2 => $attributes2,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $str = "union";
    if ($self->{attributes1})
      {
        $str .= " " . $self->{attributes1}->dump_c;
      }
    if ($self->{tag})
      {
        $str .= " $self->{tag}";
      }
    $str .= "\n{\n";
    foreach my $declaration (@{$self->{declarations}})
      {
        my @dump = split /\n/, $declaration->dump_c;
        $str .= join('', map {"  $_\n"} @dump);
      }
    $str .= "}";
    if ($self->{attributes2})
      {
        $str .= " " . $self->{attributes2}->dump_c;
      }

    return $str;
  }

sub construct_type
  {
    my $self = shift;
    my $namespace = shift;

    my @attributes;
    push @attributes, $self->{attributes1}->attributes if $self->{attributes1};
    push @attributes, $self->{attributes2}->attributes if $self->{attributes2};

    $_->process($namespace)
      foreach grep {$_->isa('CParse::Struct') or $_->isa('CParse::Union') or $_->isa('CParse::Enum')} @{$self->{declarations}};

    my @members = map {$_->get_members($namespace)} @{$self->{declarations}};

    return new CType::Union \@members, \@attributes, $CParse::current_location;
  }

sub process
  {
    my $self = shift;

    my $namespace = shift;

    if ($self->{tag})
      {
        # Heuristic: we'll ignore redefinitions that occur at the same file:line
        my $old = $namespace->get('union', $self->{tag});
        if ($old and
            ($old->{file} ne $CParse::current_location->{file} or $old->{line} ne $CParse::current_location->{line}))
          {
            die "Redefinition of union $self->{tag}\n (old definition at $old->{file}:$old->{line})\n";
          }

        my $type = $self->construct_type($namespace);
        $namespace->set('union', $self->{tag}, $type);
      }
  }

sub get_type
  {
    my $self = shift;

    my $namespace = shift;

    if ($self->{tag})
      {
        return new CType::Ref 'union', $self->{tag}, $namespace;
      }
    else
      {
        return $self->construct_type($namespace);
      }
  }

1;
