/*
 * Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test 1.1 01/09/19
 * @bug 4511404
 * @summary Check that a broken pipe error doesn't throw an exception
 *  	    indicating the socket is closed.
 */
import java.io.*;
import java.net.*;

public class BrokenPipe {

    private static class Closer implements Runnable {
        private final Socket s;

        Closer(Socket s) { 
	    this.s = s; 
	}

        public void run() {
            try {
		/* gives time for 'write' to block */
                Thread.sleep(5000);
                s.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ServerSocket ss = new ServerSocket(0);
        Socket client = new Socket(InetAddress.getLocalHost(),
                                   ss.getLocalPort());
        Socket server = ss.accept();
        ss.close();
        new Thread(new Closer(server)).start();

        try {
            client.getOutputStream().write(new byte[1000000]);
        } catch (IOException ioe) {

	    /*
	     * Check that the exception text doesn't indicate the
 	     * socket is closed. In tiger we should be able to
	     * replace this by catching a more specific exception.
	     */
            String text = ioe.getMessage();
            if (text.toLowerCase().indexOf("closed") >= 0) {
                throw ioe;
            }
        }
	server.close();
    }

}
