/*
 * Copyright 2001-2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.jmx.snmp;


// java import
//
import java.util.Enumeration;
import java.net.InetAddress;

/**
 * Defines the user based ACL used by the SNMP protocol adaptor.
 * <p>
 * <p><b>This API is a Sun Microsystems internal API  and is subject 
 * to change without notice.</b></p>
 * @since 1.5
 */

public interface UserAcl {

    /**
     * Returns the name of the ACL.
     *
     * @return The name of the ACL.
     */
    public String getName();

    /**
     * Checks whether or not the specified user has <CODE>READ</CODE> access.
     *
     * @param user The user name to check.
     *
     * @return <CODE>true</CODE> if the host has read permission, <CODE>false</CODE> otherwise.
     */
    public boolean checkReadPermission(String user);

    /**
     * Checks whether or not the specified user and context name have <CODE>READ</CODE> access.
     *
     * @param user The user name to check.
     * @param contextName The context name associated with the user.
     * @param securityLevel The request security level.
     * @return <CODE>true</CODE> if the pair (user, context) has read permission, <CODE>false</CODE> otherwise.
     */
    public boolean checkReadPermission(String user, String contextName, int securityLevel);

    /**
     * Checks whether or not a context name is defined.
     *
     * @param contextName The context name to check.
     *
     * @return <CODE>true</CODE> if the context is known, <CODE>false</CODE> otherwise.
     */
    public boolean checkContextName(String contextName);

    /**
     * Checks whether or not the specified user has <CODE>WRITE</CODE> access.
     *
     * @param user The user to check.
     *
     * @return <CODE>true</CODE> if the user has write permission, <CODE>false</CODE> otherwise.
     */
    public boolean checkWritePermission(String user);

    /**
     * Checks whether or not the specified user and context name have <CODE>WRITE</CODE> access.
     *
     * @param user The user name to check.
     * @param contextName The context name associated with the user.
     * @param securityLevel The request security level.
     * @return <CODE>true</CODE> if the pair (user, context) has write permission, <CODE>false</CODE> otherwise.
     */
    public boolean checkWritePermission(String user, String contextName, int securityLevel);
}
