<?php
/**
*   generates an html overview page with all the icons and 
*   MUA identifier strings from the js dispMUA source
*
*   @author Christian Weiske <cweiske@cweiske.de>
*/

$strAgentList   = dirname(__FILE__) . '/src/content/messenger-dispmua/useragents.txt';
$strSourceFile  = dirname(__FILE__) . '/src/content/messenger-dispmua/dispmua_overlay.js';
$strIconDir     = dirname(__FILE__) . '/src/content/messenger-dispmua/48x48/';
$strOutFile     = '/data/html/cweiske/cweiske.de/misc_extensions_dispmuas.htm';
$strRelIconPath = 'graphics/misc/dispmua/48x48/';
$bCopyIcons		= true;

$arCheckIgnores = array(
'',
'empty.png',
'pine.png',
'unknown.png',
'web_de.png',
'bug.png',
'bugzilla.png',
'seamonkey.png',
'go_pronto.png'
);

//<html><head><title>Mail applications supported by dispMUA</title>
$strHtmlBegin = <<<EOD
<style type="text/css">
div.mua {
    padding-left:50px;
    border: 1px solid black;
    margin-bottom:5px;
    padding-top: 10px;
    clear: both;
    min-height: 45px;
}
div.mua img.icon {
    float:left;
    margin-left:-40px;
    margin-top: -7px;

}
div.mua ul {
    margin-top: 0px;
}
img.icon {
    float:left;
    margin-left:-40px;
    clear:both;
}
ul {
    margin-top: 0px;
}
</style>

EOD;
//</head><body>

$strHtmlMidOne = <<<EOD
<h3>Supported user agents</h3>

EOD;
$strHtmlMidTwo = <<<EOD
<h3>Unsupported user agents</h3>

EOD;
$strHtmlEnd = <<<EOD
EOD;
//</body></html>

if (!file_exists($strSourceFile)) {
    die('Source file "' . $strSourceFile . '" doesn\'t exist');
}
if (!file_exists($strAgentList)) {
    die('Agent list file "' . $strAgentList . '" doesn\'t exist');
}

$arIdentifiers      = file($strAgentList);
$arIcons            = array();
$arReferencedIcons  = array();

$arLines            = file($strSourceFile);
$strAllocationArray = '';
$strIconCode        = '';

$bInBrace = false;
$nState   = 0;
foreach ($arLines as $strLine) {
    $strLine = trim($strLine);
    if (substr($strLine, -3) == '{{{') {
        //open braces
        $bInBrace = true;
        $nState++;
    } else if (substr($strLine, -3) == '}}}') {
        $bInBrace = false;
    } else if ($bInBrace) {
        if ($nState == 1) {
            //icon assignments
            $strAllocationArray .= $strLine . "\n";
        } else if ($nState == 2) {
            $strIconCode .= $strLine . "\n";
        }
    }
}//foreach line


/**
*   This is no real javascript2php function, just 
*   for the special case of the dispMUA allocation array
*/
function javascriptArray2php($code)
{
    $code = str_replace(': {'   , ' => array('  , $code);
    $code = str_replace('},'    , '),'          , $code);
    $code = str_replace("}\n"   , ")\n"         , $code);
    $code = str_replace(': "'   , ' => "'       , $code);
    $code = str_replace(")\n),\n" , '));'       , $code);
    $code = str_replace('arDispMuaAllocation => array', '$arDispMuaAllocation = array', $code);
    return $code;
}//function javascriptArray2php($code)

function javascriptFunction2php($code)
{
    $strVar = '[a-zA-Z0-9_]+(?:\\.[a-zA-Z0-9_]+(?:\\[(?:"|\')?[^"\'\\]]*(?:"|\')?\\])+)?';
    $strVarOrNumber = '(?:[0-9]+|' . $strVar . ')';
    $code = preg_replace('/for\\s*\\(\\s*(' . $strVar . ')\\s+in\\s+(' . $strVar . ')\\)/', 'foreach (\\$\\1 as \\$\\2)', $code);
    $code = preg_replace('/if\\s*\\(\\s*(\\!)?\\s*(' . $strVar . ')\\)/', 'if (\\1\\$\\2)', $code);
    $code = preg_replace('/(' . $strVar . ')\\s*=\\s*(' . $strVar . ')\\s*;/', '\\$\\1 = $\\2;', $code);
    $code = preg_replace('/\\[(' . $strVar . ')\\]/', '[\\$\\1]', $code);
    $code = preg_replace('/var\\s+(' . $strVar . ')/', '\\$\\1', $code);

    $code = str_replace('$true' , 'true' , $code);
    $code = str_replace('$false', 'false', $code);

    //specific
    $code = str_replace('$dispMuaGlobals.', '$', $code);
    return $code;
}

//convert the javascript allocation array to a php array
$strAllocationArray = javascriptArray2php($strAllocationArray);
eval($strAllocationArray);
if (!isset($arDispMuaAllocation)) {
    echo 'Error converting the javascript to php:' . "\r\n";
    echo $strAllocationArray . "\r\n";
    die();
}

function getIcon($strUserAgent, $arDispMuaAllocation)
{
    $strUserAgentLower = strtolower($strUserAgent);
    $strDispMuaIcon = false;
    $bFound = false;
    //in-built data
    if (!$bFound) {
        //most wanted
        foreach ($arDispMuaAllocation["presearch"] as $strDispMuaKey => $strValue) {
            //does it contain the key somewhere?
            if (strpos($strUserAgentLower, $strDispMuaKey) !== false) {
                $bFound = true;
                $strDispMuaIcon = $arDispMuaAllocation["presearch"][$strDispMuaKey];
                break;
            }
        }
    }

    if (!$bFound) {
        //Letter it begins with
        $chLetter = substr($strUserAgentLower, 0, 1);
        if (isset($arDispMuaAllocation[$chLetter])) {
            foreach ($arDispMuaAllocation[$chLetter] as $strDispMuaKey => $strValue) {
                //check if the identification really begins with the key
                if (substr($strUserAgentLower, 0, strlen($strDispMuaKey)) == $strDispMuaKey) {
                    $bFound = true;
                    $strDispMuaIcon = $arDispMuaAllocation[$chLetter][$strDispMuaKey];
                    break;
                }
            }
        }
    }

    if (!$bFound) {
        //the rest
        foreach ($arDispMuaAllocation["postsearch"] as $strDispMuaKey => $strValue) {
            //does it contain the key somewhere?
            if (strpos($strUserAgentLower, $strDispMuaKey) !== false) {
                $bFound = true;
                $strDispMuaIcon = $arDispMuaAllocation["postsearch"][$strDispMuaKey];
                break;
            }
        }
    }
    return $strDispMuaIcon;
}//function getIcon($strUserAgent, $arDispMuaAllocation)

foreach ($arDispMuaAllocation as $arSub) {
    foreach ($arSub as $strIconFile) {
        $arReferencedIcons[$strIconFile] = $strIconFile;
    }
}

$arFoundIcons = array();
$arNotFound   = array();
foreach ($arIdentifiers as $strIdentifier) {
    $strIcon = getIcon($strIdentifier, $arDispMuaAllocation);
    if ($strIcon === false) {
        $arNotFound[] = $strIdentifier;
    } else {
        $arFoundIcons[$strIcon][] = $strIdentifier;
    }
}//foreach identifier


//output
$strContent = $strHtmlBegin;

$nSupported = count($arFoundIcons);
$nUnsupported = count($arNotFound);
$strContent .= '<a href="http://www.cweiske.de/misc_extensions.htm#dispMUA">dispMUA</a> supports ' . $nSupported . ' mail programs and knows of ' . $nUnsupported . ' unsupported ones. If you know of another unsupported user agent or want to send me an icon for one of them, <a href="http://www.cweiske.de/feedback.htm">let me know</a>.';

$strContent .= $strHtmlMidOne;

foreach ($arFoundIcons as $strIcon => $objIcon) {
    $strContent .= '<div class="mua"><img src="' . $strRelIconPath . $strIcon . '" width="48" height="48" class="icon" alt=""/>' . "\r\n<ul>";
    foreach ($objIcon as $strIdentifier) {
        $strContent .= '<li class="yes">' . htmlspecialchars($strIdentifier) . '</li>' . "\r\n";
    }
    $strContent .= '</ul></div>' . "\r\n";
}

$strContent .= $strHtmlMidTwo;

if (count($arNotFound) > 0) {
    $strContent .= '<ul>';
    foreach ($arNotFound as $strIdentifier) {
        $strContent .= '<li>' . htmlspecialchars($strIdentifier) . '</li>';
    }
    $strContent .= '</ul>';
}//some not found


$strContent .= $strHtmlEnd;

$hdl = fopen($strOutFile, 'w+');
fwrite($hdl, $strContent);
fclose($hdl);

if ($bCopyIcons) {
	//copy the icons to the relative graphics directory
	$strDestDir = dirname($strOutFile) . '/' . $strRelIconPath;
	
	$arNotUsed = array();
	$arFiles = glob($strIconDir . '*.png');
	foreach ($arFiles as $strFile) {
	    unset($arReferencedIcons[basename($strFile)]);
		copy($strFile, $strDestDir . basename($strFile));
		
		$strBasename = basename($strFile);
		if (!isset($arFoundIcons[$strBasename]) && !array_search($strBasename, $arCheckIgnores)) {
			$arNotUsed[] = $strBasename;
		}
	}
	
	if (count($arNotUsed) > 0) {
		echo count ($arNotUsed) . ' icons not used:' . "\r\n";
		foreach ($arNotUsed as $strIcon) {
			echo '  ' . $strIcon . "\r\n";
		}
	}
}

if (count($arReferencedIcons) > 0) {
    echo "Some referenced icons don't exist:\r\n";
    echo ' ' . implode(',', $arReferencedIcons) . "\r\n";
}

echo 'Supported/Unsupported: ' . $nSupported . '/' . $nUnsupported . "\r\n";

?>