//main.c
//ical2sqlite
//Lucas Waye

#include "ical.h"
#include "sqlite3.h"
#include <time.h>
#include "Calendar.sql.h"
#include <stdio.h>
#include <string.h>

#define DATABASE_FILE "Calendar.sqlitedb"

static char* icalmemory_strdup_and_dequote(const char* str)
{
    const char* p;
    char* out = (char*)malloc(sizeof(char) * strlen(str) +1);
    char* pout;

    if (out == 0){
	return 0;
    }

    pout = out;

    for (p = str; *p!=0; p++){
	
	if( *p == '\\')
	{
	    p++;
	    switch(*p){
		case 0:
		{
		    *pout = '\0';
		    break;

		}
		case 'n':
		case 'N':
		{
			*pout = '\n';
		    break;
		}
		case 't':
		case 'T':
		{
		    *pout = '\t';
		    break;
		}
		case 'r':
		case 'R':
		{
		    p--;
		    break;
		}
		case 'b':
		case 'B':
		{
		    *pout = '\b';
		    break;
		}
		case 'f':
		case 'F':
		{
		    *pout = '\f';
		    break;
		}
		case ';':
		case ',':
		case '"':
		case '\\':
		{
		    *pout = *p;
		    break;
		}
		default:
		{
		    *pout = ' ';
		}		
	    }
	} else {
	    *pout = *p;
	}

	pout++;
	
    }

    *pout = '\0';

    return out;
}

void prepare_database(sqlite3** db)
{
	truncate(DATABASE_FILE, 0);
	
	sqlite3_open(DATABASE_FILE, db);

	sqlite3_exec(*db, ASQL, NULL, NULL, NULL);
}

int main(int argc, char* argv[])
{
	if(argc < 2) 
	{
		puts("Usage: ical2sqlite [filename]");
		return 0;
	}
	
	FILE *file = fopen(argv[1], "r");
	if(!file)
	{
		printf("File %s not found. Halting.\n", argv[1]);
		return 0;
	}
	
	fclose(file);
	
	sqlite3** db;

	prepare_database(db);

	parse_text(argc, *db, argv);

	sqlite3_close(*db);
	return 0;
}

char *strreplace(char *src, char *replace, char *to)
{

        char *dest = NULL;
        char *retstr = NULL;

        if(src == NULL )
                return NULL;

        //returning the src if replace is NULL
        if(replace == NULL || to == NULL)
        {

                dest = (char *)malloc(strlen(src) + 1);
                if(dest == NULL)
                        return NULL;
                else
                        strcpy(dest, src);

                return dest;
        }

        //if replace is found in src
        if(retstr = strstr(src, replace))
        {

            int beforelen = retstr - src;
            int replacelen = strlen(replace);
            dest = (char *)malloc(strlen(src) + 1 + strlen(to) - replacelen);
            if(dest == NULL)
                    return NULL;

            strncpy(dest,src, beforelen);
            strcat(dest, to);
            strcat(dest, &src[beforelen + replacelen]);
            return dest;

        }
        else //return the string itself
        {
                dest = (char *)malloc(strlen(src) + 1);
                if(dest == NULL)
                        return NULL;

                else
                        strcpy(dest, src);

                return dest;

        }
}


void parse_calendar(icalcomponent *c, sqlite3* database) 
{
	icalcomponent* event;
	icalproperty* property;

	time_t epoch = 978307200; //number of seconds in 31 years (Jan 1, 2001 UTC)


	for(event = icalcomponent_get_first_component(c, ICAL_VEVENT_COMPONENT); 
		event != 0; 
		event = icalcomponent_get_next_component(c, ICAL_VEVENT_COMPONENT)) {

		int dtstart = icaltime_as_timet(icalcomponent_get_dtstart(event))  - epoch;
		int dtend = icaltime_as_timet(icalcomponent_get_dtend(event))  - epoch;
		icaltimezone* timezone = icaltimezone_get_utc_timezone();

		char* summary = "";
		char* location = "";
		char* description = "";
		char bydaybuf[100];
		int pos = 0;
		for(pos = 0; pos < 100; pos++) bydaybuf[pos] = 0;
		int allday =  icaltime_is_date(icalcomponent_get_dtstart(event));
		struct icalrecurrencetype recur;
		int frequency = 3, until = 0;

		for(property = icalcomponent_get_first_property(event, ICAL_ANY_PROPERTY);
			property != 0;
			property =  icalcomponent_get_next_property(event, ICAL_ANY_PROPERTY)) {			

			icalvalue_kind kind = icalproperty_string_to_kind(icalproperty_get_property_name(property));
			char* value = icalproperty_get_value_as_string(property);

			switch(kind) {
				case ICAL_SUMMARY_PROPERTY:
					summary =  icalmemory_strdup_and_dequote(value);
					break;
				case ICAL_LOCATION_PROPERTY:
					location =  icalmemory_strdup_and_dequote(value);
					break;

				case ICAL_DESCRIPTION_PROPERTY:
					description = icalmemory_strdup_and_dequote(value);
					
					break;

				case ICAL_DTSTART_PROPERTY:
					if(!allday)
						timezone = icaltimezone_get_builtin_timezone(icalparameter_get_xvalue( icalproperty_get_first_parameter(property, ICAL_TZID_PARAMETER)));
					break;

				case ICAL_RRULE_PROPERTY:
					recur = icalproperty_get_rrule(property);

					switch(recur.freq) {
						case ICAL_DAILY_RECURRENCE: frequency = 1; break;
						case ICAL_MONTHLY_RECURRENCE: frequency = 2; break;
						case ICAL_YEARLY_RECURRENCE: frequency = 3; break;
					}
					until = icaltime_as_timet(recur.until)  - epoch;
					
					int pos = 2, i=0;
					bydaybuf[0] = 'D'; bydaybuf[1] = '=';		
					for(i = 0; recur.by_day[i] != ICAL_RECURRENCE_ARRAY_MAX; i++) {
						if(pos > 2) bydaybuf[pos++] = ',';							
						bydaybuf[pos++] = 48 + icalrecurrencetype_day_position(recur.by_day[i]);
						switch(icalrecurrencetype_day_day_of_week(recur.by_day[i])) {
							case ICAL_SUNDAY_WEEKDAY: bydaybuf[pos++] = 'S'; bydaybuf[pos++] = 'U'; break;
							case ICAL_MONDAY_WEEKDAY: bydaybuf[pos++] = 'M'; bydaybuf[pos++] = 'O'; break;
							case ICAL_TUESDAY_WEEKDAY: bydaybuf[pos++] = 'T'; bydaybuf[pos++] = 'U'; break;
							case ICAL_WEDNESDAY_WEEKDAY: bydaybuf[pos++] = 'W'; bydaybuf[pos++] = 'E'; break;
							case ICAL_THURSDAY_WEEKDAY: bydaybuf[pos++] = 'T'; bydaybuf[pos++] = 'H'; break;
							case ICAL_FRIDAY_WEEKDAY: bydaybuf[pos++] = 'F'; bydaybuf[pos++] = 'R'; break;
							case ICAL_SATURDAY_WEEKDAY: bydaybuf[pos++] = 'S'; bydaybuf[pos++] = 'A'; break;
							default: bydaybuf[pos++] = 'T'; bydaybuf[pos++] = 'U'; break;
						}
					}
					bydaybuf[pos++] = '\0';
					break;
				
			}
		}
		
		icaltimetype start = icaltime_from_timet_with_zone(icaltime_as_timet(icalcomponent_get_dtstart(event)), allday, timezone);
		if(!allday) {
			int dst;
			icaltimetype** timea = &start;
			int offset = icaltimezone_get_utc_offset_of_utc_time(start.zone, timea, &dst);
			dtstart -= offset;
			dtend -= offset;
			until -= offset;
		}		
					
		char buffer[1000];
		char * tz = icaltimezone_get_location(timezone);
		char* find = "'";
		char* replace = "''";
		
		sprintf(buffer, "INSERT INTO Event (summary, location, description, start_date, start_tz, end_date, all_day, calendar_id) VALUES ('%s', '%s', '%s', '%d', '%s', '%d', '%d', '1')",
			strreplace(summary, find, replace), strreplace(location, find, replace), strreplace(description, find, replace), dtstart,  (tz != NULL ? tz : "_float"), dtend, allday);


		char* error;
		sqlite3_exec(database, buffer, NULL, NULL, &error);
		if(error != NULL) {
			printf("Error: %s --> %s %s\n", buffer, error, description);
			return;
		}
		
		if(strlen(bydaybuf) != 0) {
			int eventid = sqlite3_last_insert_rowid(database);
			
			sprintf(buffer, "INSERT INTO Recurrence (frequency, interval, count, end_date, specifier, event_id, week_start) VALUES ('%d', '%d', '%d', '%d', '%s', '%d', '%d')", frequency, recur.interval, recur.count, until, bydaybuf, eventid, recur.week_start - 1); 

			sqlite3_exec(database, buffer, NULL, NULL, NULL);
		}

	}
}
