'\" t
.TH PR3287 1 "16 August 2020"
.SH "NAME"
pr3287 \-
\s-1IBM\s+1
host printing tool
.SH "SYNOPSIS"
\fBpr3287\fP
[\fIoptions\fP] [L:][Y:][\fILUname\fP[,\fILUname\fP...]@]\fIhostname\fP[:\fIport\fP][=\fIaccept\fP]
.SH "DESCRIPTION"
\fBpr3287\fP
opens a telnet connection to an
\s-1IBM\s+1
host, and emulates an \s-1IBM\s+1 3287 printer.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection).
.LP
If the \fIhostname\fP is prefixed with \fBL:\fP, the connection will be made
through an SSL/TLS tunnel.
If the \fIhostname\fP is also prefixed with \fBY:\fP, the host's SSL/TLS
certificate will not be checked.
\fBpr3287\fP also supports TELNET START-TLS option negotiation without any
need for command-line options.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP
with an
`\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden by appending a
\fIport\fP
to the
\fIhostname\fP
with a colon
`\fB:\fP'.
.LP
An accept name (a name to compare to the host's SSL/TLS certificate) may be
specified by appending it with an equals sign.
.SH "OPTIONS"
\fBpr3287\fP
understands the following options:
.TP
\fB\-accepthostname\fP \fIname\fP
Specifies a particular hostname to accept when validating the name presented
in the server SSL certificate, instead of comparing to the name
used to make the connection.
\fIname\fP can either be \fBany\fP (OpenSSL only), which
disables name validation, or a specific name.
.TP
\fB\-assoc\fP \fILUname\fP
Causes the session to be associated with the specified
\fILUname\fP.
.TP
\fB\-blanklines\fP
In LU3 formatted mode, print blank lines even if they are all NULLs or control
characters.
(This is a violation of the 3270 printer protocol, but some hosts require it.)
.TP
\fB\-cadir\fP \fIdirectory\fP
Specifies a directory containing CA (root) certificates to use when verifying a
certificate provided by the host. (OpenSSL only)
.TP
\fB\-cafile\fP \fIfilename\fP
Specifies a \s-1PEM\s+1-format file containing CA (root) certificates to use
when verifying a certificate provided by the host. (OpenSSL only)
.TP
\fB\-certfile\fP \fIfilename\fP
Specifies a file containing a certificate to provide to the host.
The default file type is \s-1PEM\s+1 (OpenSSL) or PKCS12 (MacOS).
.TP
\fB\-certfiletype\fP \fItype\fP
Specifies the type of the certificate file specified
by \fB\-certfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP. (OpenSSL only)
.TP
\fB\-chainfile \fIfilename\fP\fP
Specifies a certificate chain file in \s-1PEM\s+1 format, containing a
certificate to provide to the host, as well as one or more
intermediate certificates and the CA certificate used to sign that certificate.
If \fB\-chainfile\fP is specified, it
overrides \fB\-certfile\fP. (OpenSSL only)
.TP
\fB\-clientcert\fP \fIname\fP
Specifies the name of a client certificate to provide to the host. It must be
installed in the keychain. (MacOS only)
.TP
\fB\-charset\fP \fIname\fP
Specifies an alternate host code page (input \s-1EBCDIC\s+1 mapping).
The default maps the U.S. English (037) code page to the
current locale character encoding.
pr3287 generally supports the same host character sets as
x3270.
.TP
\fB\-command\fP \fIcommand\fP
Specifies the command to run for each print job.
The default is \fBlpr\fP.
.TP
\fB\-crlf\fP
Causes newline characters in the output to be expanded to
carriage-return/linefeed sequences.
.TP
\fB\-crthru\fP
In unformatted 3270 mode, causes \s-1EBCDIC\s+1 CR orders to be passed to
directly to the printer as \s-1ASCII\s+1 CR characters, and the output buffer to
be flushed, instead of being specially interpreted by \fIpr3287\fP.
.IP
By default, \s-1EBCDIC\s+1 CRs cause the (virtual) print head to return to
column 0, so that subsequent text overwrites what is already in the buffer,
and the buffer is flushed only when an \s-1EBCDIC\s+1 NL or EM order is
received.
.TP
\fB\-daemon\fP
Causes
\fIpr3287\fP
to become a daemon (background) process.
.TP
\fB\-eojtimeout\fP \fIseconds\fP
Causes \fIpr3287\fP to complete the print job after \fIseconds\fP seconds
of inactivity.
.TP
\fB\-emflush\fP
Causes \fIpr3287\fP to flush any pending printer output whenever an EM
(End of Medium) order arrives in unformatted 3270 mode.
This can help preserve multi-page output with hosts that do not clear the 3270
buffer between pages.
(Note: This option is defined for historical purposes only; \fB\-emflush\fP is now
the default.)
.TP
\fB\-noemflush\fP
Causes \fIpr3287\fP not to flush any pending printer output when an EM
(End of Medium) order arrives in unformatted 3270 mode.
.TP
\fB\-ignoreeoj\fP
Ignore TN3270E PRINT-EOJ commands, relying on UNBIND commands to indicate
the ends of print jobs.
.TP
\fB\-ffeoj\fP
Causes \fIpr3287\fP to add a FF (formfeed) at the end of each print job.
.TP
\fB\-ffskip\fP
Causes \fIpr3287\fP to ignore a FF (formfeed) order if it occurs
at the top of a page.
.TP
\fB\-ffthru\fP
In SCS mode, causes \fIpr3287\fP to pass FF (formfeed) orders through to the
printer as ASCII formfeed characters, rather than simulating them based on the
values of the MPL (maximum presentation line) and TM (top margin) parameters.
.TP
\fB\-keyfile\fP \fIfilename\fP
Specifies a file containing the private key for the certificate file
(specified via \fB\-certfile\fP or \fB\-chainfile\fP).
The default file type is \s-1PEM\s+1. (OpenSSL only)
.TP
\fB\-keyfiletype\fP \fItype\fP
Specifies the type of the private key file specified
by \fB\-keyfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP. (OpenSSL only)
.TP
\fB\-keypasswd\fP \fItype\fP:\fIvalue\fP
Specifies the password for the private key file, if it is encrypted.
The argument can be \fBfile\fP:\fIfilename\fP, specifying that the
password is in a file, or \fBstring\fP:\fIstring\fP, specifying the
password on the command-line directly.
.TP
\fB\-mpp \fIn\fP\fP
Specifies a non-default value for the Maximum Presentation Position (the
line length for unformatted Write commands).
The default is 132.
The minimum is 40 and the maximum is 256.

.TP
\fB\-noverifycert\fP
Do not verify the host certificate for SSL/TLS connections.
.TP
\fB\-proxy \fItype\fP:\fIhost\fP[:\fIport\fP]\fP
Causes \fBpr3287\fP to connect via the specified proxy, instead of
using a direct connection.
The \fIhost\fP can be an IP address or hostname.
The optional \fIport\fP can be a number or a service name.
For a list of supported proxy \fItypes\fP, see \s-1PROXY\s+1
below.
.TP
\fB\-reconnect\fP
Causes \fIpr3287\fP to reconnect to the host, whenever the connection is
broken.
There is a 5-second delay between reconnect attempts, to reduce network
thrashing for down or misconfigured hosts.
.TP
\fB\-skipcc\fP
For unformatted writes, skip ASA carriage control characters (e.g., blank for
single-space, 0 for double-space, 1 for formfeed, etc.) in the first
position of each line of host output.
.TP
\fB\-trace\fP
Turns on data stream tracing.
Trace information is usually saved in the file
\fB/tmp/x3trc.\fP\fIpid\fP.
.TP
\fB\-tracedir\fP \fIdir\fP
Specifies the directory to save trace files in, instead of
\fB/tmp\fP.
.TP
\fB\-trnpre \fIfile\fP\fP
Specifies a file containing data that will be sent to the printer before each
print job.
The file contents are treated as transparent data, i.e., they are not
translated in any way.
.TP
\fB\-trnpost \fIfile\fP\fP
Specifies a file containing data that will be sent to the printer after each
print job.
The file contents are treated as transparent data, i.e., they are not
translated in any way.
.TP
\fB\-v\fP
Display build and version information and exit.
.TP
\fB\-verifycert\fP
Verify the host certificate for SSL/TLS connections. (This is the default
setting.)
.TP
\fB\-xtable \fIfile\fP\fP
Specifies a file containing transparent data translations.
The file specifies EBCDIC characters that will be translated into transparent
ASCII data (data that will not be further translated and will not count as
taking up column(s) on the print line).
Any printable ECBDIC code can be translated to zero or more ASCII characters.
.IP
The table consists of lines that look like:
.RS
\fBebcdic\fP \fIebcdic-code\fP \fBascii\fP \fIascii-code\fP...

.RE
.IP
The \fIebcdic-code\fP can be specified in hexadecimal X'\fInn\fP' notation or
as numbers in decimal, octal (with a leading 0) or hexadecimal (with a leading
0x).
The \fIascii-code\fPs can be specified as numbers in decimal, octal or
hexadecimal, control codes such as \fB^X\fP, symbolic control codes such
as \fBCR\fP or \fBEscape\fP, or as double-quoted strings, following the
full C-language conventions, such as \fB\\r\fP for a carriage return.
Comments begin with \fB#\fP, \fB!\fP or \fB//\fP.
.IP
Here are some examples of translations.
.br
# Expand EBCDIC D to an escape sequence.
.br
ebcdic X'C4' ascii Esc "]1,3" 0x6d
.br
# Delete EBCDIC B's
.br
ebcdic X'C2' ascii
.IP
The full list of symbolic control codes is: \fBBS CR BEL ESC ESCAPE FF HT LF NL NUL SPACE TAB VT\fP.
.SH "SIGNALS"
SIGINT, SIGHUP and SIGTERM cause the current print job to be flushed (any
pending data to be printed) and \fIpr3287\fP to exit.
.LP
SIGUSR1 causes the current print job to be flushed without otherwise
affecting the \fIpr3287\fP process.

.SH "PROXY"
The \fB\-proxy\fP option
causes pr3287 to use a proxy server to connect to the host.
The syntax of the option is:
.RS
\fItype\fP:\fIhost\fP[:\fIport\fP]

.RE
The supported values for \fItype\fP are:
.TS
center;
c l c .
T{
.na
.nh
Proxy Type
T}	T{
.na
.nh
Protocol
T}	T{
.na
.nh
Default Port
T}
_
T{
.na
.nh
http
T}	T{
.na
.nh
RFC 2817 HTTP tunnel (squid)
T}	T{
.na
.nh
3128
T}
T{
.na
.nh
passthru
T}	T{
.na
.nh
Sun in.telnet-gw
T}	T{
.na
.nh
none
T}
T{
.na
.nh
socks4
T}	T{
.na
.nh
SOCKS version 4
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
socks5
T}	T{
.na
.nh
SOCKS version 5 (RFC 1928)
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
telnet
T}	T{
.na
.nh
No protocol (just send \fBconnect\fP \fIhost port\fP)
T}	T{
.na
.nh
none
T}
.TE
.LP
The special types \fBsocks4a\fP and \fBsocks5d\fP can also be used to force
the proxy server to do the hostname resolution for the SOCKS protocol.
.SH "SEE ALSO"
x3270(1), c3270(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23\-0059
.br
Character Set Reference, IBM GA27\-3831
.br
3174 Establishment Controller Functional Description, IBM GA23\-0218
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
Copyright 1993-2020, Paul Mattes.
.br
Copyright 1990, Jeff Sparkes.
.br
Copyright 1989, Georgia Tech Research Corporation (GTRC), Atlanta, GA
 30332.
.br
All rights reserved.
.LP
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

.TP
*
Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
.TP
*
Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
.TP
*
Neither the names of Paul Mattes, Jeff Sparkes, GTRC nor the names of
their contributors may be used to endorse or promote products derived
from this software without specific prior written permission.
.LP
THIS SOFTWARE IS PROVIDED BY PAUL MATTES, JEFF SPARKES AND GTRC `AS IS' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL PAUL MATTES, JEFF SPARKES OR GTRC BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
.SH "VERSION"
pr3287 4.0ga11
