# -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is the Firefox Preferences System.
#
# The Initial Developer of the Original Code is
# Ben Goodger.
# Portions created by the Initial Developer are Copyright (C) 2005
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Ben Goodger <ben@mozilla.org>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

var gAdvancedPane = {
  _inited: false,
  init: function ()
  {
    this._inited = true;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    if (preference.value === null)
      return;
    advancedPrefs.selectedIndex = preference.value;
    
    this.updateAppUpdateItems();
    this.updateAutoItems();
    this.updateModeItems();
#ifdef MOZ_SAFE_BROWSING
    this.updateSBItems();
#endif
  },
  
  tabSelectionChanged: function ()
  {
    if (!this._inited)
      return;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    preference.valueFromPreferences = advancedPrefs.selectedIndex;
  },
  
  updateButtons: function (aButtonID, aPreferenceID)
  {
    var button = document.getElementById(aButtonID);
    var preference = document.getElementById(aPreferenceID);
    // This is actually before the value changes, so the value is not as you expect. 
    button.disabled = preference.value == true;
    return undefined;
  },

  showCertificates: function ()
  {
    document.documentElement.openWindow("mozilla:certmanager",
                                        "chrome://pippki/content/certManager.xul",
                                        "width=600,height=400", null);
  },
  
  showCRLs: function ()
  {
    document.documentElement.openWindow("Mozilla:CRLManager", 
                                        "chrome://pippki/content/crlManager.xul",
                                        "width=600,height=400", null);
  },
  
  showOCSP: function ()
  {
    document.documentElement.openSubDialog("chrome://mozapps/content/preferences/ocsp.xul",
                                           "", null);
  },
  
  showSecurityDevices: function ()
  {
    document.documentElement.openWindow("mozilla:devicemanager",
                                        "chrome://pippki/content/device_manager.xul",
                                        "width=600,height=400", null);
  },

  /**
   * UI state matrix for update preference conditions
   * 
   * UI Components:                                     Preferences
   * 1 = Firefox checkbox                               i   = app.update.enabled
   * 2 = When updates for Firefox are found label       ii  = app.update.auto
   * 3 = Automatic Radiogroup (Ask vs. Automatically)   iii = app.update.mode
   * 4 = Warn before disabling extensions checkbox
   * 
   * States:
   * Element     p   val     locked    Disabled 
   * 1           i   t/f     f         false
   *             i   t/f     t         true
   *             ii  t/f     t/f       false
   *             iii 0/1/2   t/f       false
   * 2,3         i   t       t/f       false
   *             i   f       t/f       true
   *             ii  t/f     f         false
   *             ii  t/f     t         true
   *             iii 0/1/2   t/f       false
   * 4           i   t       t/f       false
   *             i   f       t/f       true
   *             ii  t       t/f       false
   *             ii  f       t/f       true
   *             iii 0/1/2   f         false
   *             iii 0/1/2   t         true   
   * 
   */
  updateAppUpdateItems: function () 
  {
    var aus = 
        Components.classes["@mozilla.org/updates/update-service;1"].
        getService(Components.interfaces.nsIApplicationUpdateService);

    var enabledPref = document.getElementById("app.update.enabled");
    var enableAppUpdate = document.getElementById("enableAppUpdate");

    enableAppUpdate.disabled = !aus.canUpdate || enabledPref.locked;
  },
  
  updateAutoItems: function () 
  {
    var enabledPref = document.getElementById("app.update.enabled");
    var autoPref = document.getElementById("app.update.auto");
    
    var updateModeLabel = document.getElementById("updateModeLabel");
    var updateMode = document.getElementById("updateMode");
    
    var disable = enabledPref.locked || !enabledPref.value ||
                  autoPref.locked;
    updateModeLabel.disabled = updateMode.disabled = disable;
  },

  updateModeItems: function () 
  {
    var enabledPref = document.getElementById("app.update.enabled");
    var autoPref = document.getElementById("app.update.auto");
    var modePref = document.getElementById("app.update.mode");
    
    var warnIncompatible = document.getElementById("warnIncompatible");
    
    var disable = enabledPref.locked || !enabledPref.value || autoPref.locked ||
                  !autoPref.value || modePref.locked;
    warnIncompatible.disabled = disable;
  },

  /**
   * The Extensions checkbox and button are disabled only if the enable Addon
   * update preference is locked. 
   */
  updateAddonUpdateUI: function ()
  {
    var enabledPref = document.getElementById("extensions.update.enabled");
    var enableAddonUpdate = document.getElementById("enableAddonUpdate");

    enableAddonUpdate.disabled = enabledPref.locked;
  },  

  /**
   * app.update.mode is a three state integer preference, and we have to 
   * express all three values in a single checkbox:
   * "Warn me if this will disable extensions or themes"
   * Preference Value         Checkbox State    Meaning
   * 0                        Unchecked         Do not warn
   * 1                        Checked           Warn if there are incompatibilities
   * 2                        Checked           Warn if there are incompatibilities,
   *                                            or the update is major.
   */
  _modePreference: -1,
  addonWarnSyncFrom: function ()
  {
    var preference = document.getElementById("app.update.mode");
    var doNotWarn = preference.value != 0;
    gAdvancedPane._modePreference = doNotWarn ? preference.value : 1;
    return doNotWarn;
  },
  
  addonWarnSyncTo: function ()
  {
    var warnIncompatible = document.getElementById("warnIncompatible");
    return !warnIncompatible.checked ? 0 : gAdvancedPane._modePreference;
  },
  
  showUpdates: function ()
  {
    var prompter = Components.classes["@mozilla.org/updates/update-prompt;1"]
                             .createInstance(Components.interfaces.nsIUpdatePrompt);
    prompter.showUpdateHistory(window);
  },
  
  showLanguages: function ()
  {
    document.documentElement.openSubDialog("chrome://browser/content/preferences/languages.xul",
                                           "", null);
  },

  showWarnings: function ()
  {
    document.documentElement.openSubDialog("chrome://browser/content/preferences/securityWarnings.xul",
                                           "", null);
#ifdef MOZ_SAFE_BROWSING
  },
  
  updateSBItems: function ()
  {
    var sbEnabled = document.getElementById("safe-active").checked;
    document.getElementById("safe-local").disabled = !sbEnabled;
    document.getElementById("safe-remote").disabled = !sbEnabled;
#endif
  },

  /**
   * Displays a EULA if on-load anti-phishing detection is being enabled, 
   * allowing privacy wonks to not enable it if they want; if the user doesn't
   * agree, protection is switched back to using a cached anti-phishing list.
   */
  writeOnloadLookup: function ()
  {
    var radio = document.getElementById("safe-provider");
    // if the user's trying to enable on-load anti-phishing detection, tell him
    // about privacy concerns in a EULA so he can cancel it if he chooses
    if (radio.value == "true") {
      var userAgreed = this._userAgreedToPhishingEULA();

      // XXX I think this shouldn't be necessary and should be happening automatically, but it isn't
      if (!userAgreed)
        radio.value = "false";
      return userAgreed;
    }

    // user disabling -- nothing to display, no preference value to override
    return undefined;
  },

  /**
   * Displays the currently-used phishing provider's EULA and offers the user
   * the choice of cancelling the enabling of phishing.
   *
   * @returns bool
   *          true if the user still wants to enable phishing protection with
   *          the current provider, false otherwise
   */
  _userAgreedToPhishingEULA: function ()
  {
    // XXX this is hackish, and there's no nice URL support -- window with
    //     HTML file provided by anti-phishing provider later?
    const Cc = Components.classes, Ci = Components.interfaces;
    const IPS = Ci.nsIPromptService;
    var ips = Cc["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(IPS);
    var bundle = document.getElementById("bundlePreferences");
    var btnPressed = ips.confirmEx(window,
                                   bundle.getString("phishEULATitle"),
                                   bundle.getString("phishEULAText"),
                                   IPS.BUTTON_POS_0 * IPS.BUTTON_TITLE_IS_STRING +
                                     IPS.BUTTON_POS_1 * IPS.BUTTON_TITLE_IS_STRING,
                                   bundle.getString("phishEULAOK"),
                                   bundle.getString("phishEULACancel"),
                                   "",
                                   "", {});
    return (btnPressed == 0);
  },

  /**
   * Turns off phishing protection and updates UI accordingly.
   */
  _disablePhishingProtection: function ()
  {
    var checkbox = document.getElementById("safe-active");
    var phishEnabled = document.getElementById("browser.safebrowsing.enabled");
    phishEnabled.value = false;
    this._pane.userChangedValue(checkbox);
  }

};
