/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Sample.cpp,v 1.4 2004/01/26 11:16:59 comix Exp $
 *
 */

#include "Sample.h"


//----------------------------------------------------------------------------
//	IMPLEMENTATION OF SAMPLE CLASS
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
/**
 * Constructor
 */
Sample::Sample(uint nFrames, string filename ) : Object( "Sample" )
{

//	infoLog("init " + name);

	this->nFrames = nFrames;
	this->filename = filename;
	dataL = NULL;
	dataR = NULL;
}




//----------------------------------------------------------------------------
/**
 * Destructor
 */
Sample::~Sample(){
	if( dataL != NULL){
		delete[] dataL;
		dataL = NULL;
	}
	if( dataR != NULL ){
		delete[] dataR;
		dataR = NULL;
	}
//	infoLog("destroy " + name);
}




//----------------------------------------------------------------------------
/**
 * Imposta i dati del sample audio.
 */
void Sample::setData_L(float *left) {
	dataL = left;
}




//----------------------------------------------------------------------------
/**
 * Imposta i dati del sample audio.
 */
void Sample::setData_R(float *right) {
	dataR = right;
}




//----------------------------------------------------------------------------
/**
 * Restituisce i dati del sample audio (Canale sinistro).
 */
float* Sample::getData_L(){
	return dataL;
}



//----------------------------------------------------------------------------
/**
 *Restituisce i dati del sample audio (Canale destro).
 */
float* Sample::getData_R(){
	return dataR;
}



//----------------------------------------------------------------------------
/**
 *
 */
Sample* Sample::load(string filename) {

	// file exists?
	std::ifstream verify(filename.c_str() , std::ios::in | std::ios::binary);
	if (verify == NULL){
		cerr << "[Sample::load] Load sample: File " + filename + " not found." << endl;
		return NULL;
	}

	// apro il file
	AFfilehandle samplefile = afOpenFile(filename.c_str(), "r", NULL);
	if (samplefile <= 0) {
		cerr << "Sample::load() Error opening file " << filename << endl;
		return NULL;
	}

	AFframecount framecount = afGetFrameCount(samplefile, AF_DEFAULT_TRACK);
	if (framecount <= 0) {
		cerr << "Sample::load() Error afGetFrameCount" << endl;
	}

	int channelcount = afGetChannels(samplefile, AF_DEFAULT_TRACK);
	if (channelcount <= 0) {
		cerr << "Sample::load() Error afGetChannels" << endl;
	}

	int sampleformat;
	int samplewidth;
	afGetSampleFormat(samplefile, AF_DEFAULT_TRACK, &sampleformat, &samplewidth);

#if defined(i386) || defined(alpha)
	afSetVirtualByteOrder(samplefile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN);
#else
	afSetVirtualByteOrder(samplefile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN);
#endif

	// set float 32 bit
	afSetVirtualSampleFormat (samplefile, AF_DEFAULT_TRACK, AF_SAMPFMT_FLOAT, 32);

//	float framesize= afGetFrameSize(samplefile, AF_DEFAULT_TRACK, 0);
//	double rate = afGetRate (samplefile, AF_DEFAULT_TRACK);


	if ( (channelcount != 1) && (channelcount != 2) ) {
		cerr << "Sample::load() Error. Wrong sample channels number" << endl;
	}

	if (samplewidth != 16) {
		cerr << "Sample::load() Error. Sample must be in 16 bit width" << endl;
	}
/*
	cout << "nFrames = " << framecount << endl;
	cout << "channels = " << channelcount << endl;
	cout << "sampleFormat = " << sampleformat << endl;
	cout << "samplewidth = " << samplewidth << endl;
	cout << "framesize = " << framesize << endl;
	cout << "sample rate = " << rate << endl;
*/


	float *loadBuffer = new float[framecount * channelcount];

	afReadFrames(samplefile, AF_DEFAULT_TRACK, loadBuffer, framecount);

	afCloseFile(samplefile);


	float *data_L = new float[framecount];
	float *data_R = new float[framecount];

	if (channelcount == 1) {	// MONO sample
		for (long int i = 0; i < framecount; i++) {
			data_L[i] = loadBuffer[i];
			data_R[i] = loadBuffer[i];
		}
	}
	else if (channelcount == 2) { // STEREO sample
		for (long int i = 0; i < framecount; i++) {
			data_L[i] = loadBuffer[i * 2];
			data_R[i] = loadBuffer[i * 2 + 1];
		}
	}

	if (loadBuffer) {
		delete[] loadBuffer;
	}

	Sample *sample = new Sample(framecount, filename);
	sample->setData_L(data_L);
	sample->setData_R(data_R);

	return sample;
}




//----------------------------------------------------------------------------
/**
 *
 */
void Sample::save(string filename) {
	infoLog( "saving " + filename );

	PreferencesMng *preferencesMng = PreferencesMng::getInstance();

	int bits = 16;
	int sampleRate = preferencesMng->getSampleRate();

	AFfilehandle outputFile;

	// File Open
	AFfilesetup outputSetup = afNewFileSetup();
	afInitFileFormat( outputSetup, AF_FILE_WAVE );
	afInitSampleFormat( outputSetup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, bits );
	afInitRate( outputSetup, AF_DEFAULT_TRACK, sampleRate );
	afInitChannels( outputSetup, AF_DEFAULT_TRACK, 2 );

	outputFile = afOpenFile( filename.c_str(), "w", outputSetup );

	afFreeFileSetup( outputSetup );

#if defined(i386) || defined(alpha)
	afSetVirtualByteOrder( outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN );
#else
	afSetVirtualByteOrder( outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN );
#endif

	int bufferSize = nFrames;

	short *saveBuffer = new short[bufferSize * 2];

	for (int i = 0; i < bufferSize; i++) {
//		saveBuffer[i * 2] = (short)(dataL[i] * 32768.0);
//		saveBuffer[i * 2 + 1] = (short)(dataR[i] * 32768.0);
		saveBuffer[i * 2] = (short)(dataL[i] * 32767.0);
		saveBuffer[i * 2 + 1] = (short)(dataR[i] * 32767.0);
	}

	afWriteFrames( outputFile, AF_DEFAULT_TRACK, saveBuffer, bufferSize );


	delete[] saveBuffer;
	saveBuffer = NULL;

	afCloseFile( outputFile );

}






