/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: PatternEditor.h,v 1.36 2004/02/10 11:07:30 comix Exp $
 *
 */


#ifndef PATTERN_EDITOR_H
#define PATTERN_EDITOR_H

#include "qwidget.h"
#include "qtimer.h"
#include "qpixmap.h"
#include "qpainter.h"
#include "qapplication.h"
#include "qpopupmenu.h"


#include "lib/EngineListener.h"
#include "lib/Object.h"

#include "Globals.h"
#include "config.h"
#include "HydrogenApp.h"
#include "PatternEditorPanel.h"

class PatternEditorInstrumentList;
class PatternEditorVelocityRuler;
class PatternEditorPanel;

/**
 * Pattern editor
 */
class PatternEditor : public QWidget, public EngineListener, public Object {
	Q_OBJECT

	public:
		PatternEditor(QWidget* parent, PatternEditorPanel *pPanel);
		~PatternEditor();

		void mousePressEvent(QMouseEvent *ev);
		void paintEvent(QPaintEvent *ev);
		void setResolution(uint res, bool bUseTriplets);
		uint getResolution() {	return m_nResolution;	}
		bool isUsingTriplets() {	return m_bUseTriplets;	}

		void showEvent ( QShowEvent *ev );
		void hideEvent ( QHideEvent *ev );

		void setPatternEditorInstrumentList( PatternEditorInstrumentList* editor ) {	m_pPatternEditorInstrumentList = editor;	}
		void setPatternEditorVelocityRuler( PatternEditorVelocityRuler* pVelocityRuler ) {	m_pVelocityRuler = pVelocityRuler;	}

	public slots:
		void updateEditor(bool forceRepaint = false);

	private:
		uint m_nEditorWidth;
		uint m_nEditorHeight;

		uint m_nGridWidth;
		uint m_nGridHeight;

		QPixmap background;

		bool changed;
		bool notesChanged;

		uint m_nResolution;
		bool m_bUseTriplets;

		Pattern *currentPattern;
		
		PatternEditorPanel *m_pPatternEditorPanel;
		PatternEditorInstrumentList *m_pPatternEditorInstrumentList;
		PatternEditorVelocityRuler *m_pVelocityRuler;

		void drawNote(Note* note, uint nSequence, QPixmap *pixmap);
		void drawPattern(QPixmap *pixmap);
		void createBackground(QPixmap *pixmap);

		virtual void patternChanged();
		void customEvent( QCustomEvent *ev );

};





/**
 *
 */
class PatternEditorRuler : public QWidget, public Object
{
	Q_OBJECT

	public:
		PatternEditorRuler(QWidget* parent);
		~PatternEditorRuler();

		void paintEvent(QPaintEvent *ev);
		void updateStart(bool start);

		void showEvent ( QShowEvent *ev );
		void hideEvent ( QHideEvent *ev );

	public slots:
		void updateEditor( bool bRedrawAll = false );

	private:
		uint m_nRulerWidth;
		uint m_nRulerHeight;
		uint m_nGridWidth;
		QPixmap background;
		QPixmap tickPosition;
		QPixmap temp;
		QTimer *timer;
		uint nTicks;
		bool changed;
};



/**
 *
 */
class PatternEditorInstrumentList : public QWidget, public EngineListener, public Object {
	Q_OBJECT

	public:
		PatternEditorInstrumentList( QWidget *parent, PatternEditor *pPatternEditor, PatternEditorPanel *pPanel );
		~PatternEditorInstrumentList();


	public slots:
		void updateEditor();

		void functionClearNotes();
		void functionFillNotes();
		void functionProperties();
		void functionMute();
		void functionSolo();
		void functionLoad();


	private:
		PatternEditorPanel *m_pPatternEditorPanel;
		PatternEditor *m_pPatternEditor;
		uint m_nGridHeight;
		uint m_nEditorWidth;
		uint m_nEditorHeight;
		bool changed;
		QPixmap background;
		QPixmap temp;

		QPixmap genericIcon;
		QPopupMenu *functionPopup;


		virtual void patternChanged();
		void customEvent( QCustomEvent *ev );
		void paintEvent(QPaintEvent *ev);
		void createBackground(QPixmap *pixmap);
		void mousePressEvent(QMouseEvent *ev);
};



/**
 *
 */
class PatternEditorVelocityRuler : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		PatternEditorVelocityRuler( QWidget *parent, PatternEditor *pPatternEditor, PatternEditorPanel *pPanel );
		~PatternEditorVelocityRuler();


	public slots:
		void updateEditor();


	private:
		PatternEditorPanel *m_pPatternEditorPanel;
		Pattern *m_pCurrentPattern;
		PatternEditor *m_pPatternEditor;
		uint m_nGridWidth;
		uint m_nEditorWidth;
		uint m_nEditorHeight;

		bool m_bChanged;
		QPixmap m_background;

		virtual void patternChanged();

		void customEvent( QCustomEvent *ev );
		void createBackground(QPixmap *pixmap);
		void paintEvent(QPaintEvent *ev);
		void mousePressEvent(QMouseEvent *ev);
		void mouseMoveEvent(QMouseEvent *ev);

};

#endif
