/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: HydrogenApp.h,v 1.32 2004/01/27 15:21:20 comix Exp $
 *
 */
#ifndef HYDROGEN_APP_H
#define HYDROGEN_APP_H


#include <iostream>
#include "qstatusbar.h"
#include "qfiledialog.h"
#include "qapplication.h"
#include "qmessagebox.h"

#include "lib/Song.h"
#include "lib/EngineListener.h"

#include "SongEditor.h"
#include "MainForm.h"
#include "Mixer.h"
#include "PatternEditorPanel.h"
#include "PreferencesDialog.h"
#include "AudioEngineInfoForm.h"
#include "HelpBrowser.h"
#include "DrumkitManager.h"
#include "LadspaFXProperties.h"

class MainForm;
class Mixer;
class SongEditor;
class SongEditorPanel;
class MixerLine;
class AudioEngineInfoForm;
class PatternEditor;
class PatternEditorPanel;
class HelpBrowser;
class DrumkitManager;
class LadspaFXProperties;

static const int H2_TEXT_EVENT = QEvent::User + 5780;
/**
 *
 */
class H2TextEvent : public QCustomEvent {
	private:
		QString text;

		/** Used in ENgineError event */
		QString errorMsg;

		/** Used in noteOn event */
		Note *note;

	public:
		H2TextEvent(QString newText) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
		}

		H2TextEvent(QString newText, QString errorMsg ) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
			this->errorMsg = errorMsg;
		}

		/** Used for noteOn event */
		H2TextEvent(QString newText, Note *newNote) : QCustomEvent( H2_TEXT_EVENT ) {
			text = newText;
			note = newNote;
		}

		QString getText() {	return text;	}

		/** Used in noteOn event */
		Note* getNote() {	return note;	}

		QString getErrorMsg() {	return errorMsg;	}
};



//----------------------------------------------------------------------------
/**
 *
 */
class HydrogenApp : public EngineListener {

	public:
		/** Constructor */
		HydrogenApp( MainForm* mainForm, Song *firstSong );

		/** Return an HydrogenApp instance */
		static HydrogenApp* getInstance();

		/** Destructor */
		virtual ~HydrogenApp();

		void setSong(Song* song);
		Song *getSong();

		void showPreferencesDialog();
		void showMixer(bool show);
		void showPatternEditor(bool show);
		void showAudioEngineInfoForm();

		Mixer* getMixer() {	return mixer;	}
		PatternEditorPanel* getPatternEditor() {	return patternEditorPanel;	}
		MainForm* getMainForm() {	return mainForm;	}
		SongEditorPanel* getSongEditorPanel() {	return songEditorPanel;	}
		AudioEngineInfoForm* getAudioEngineInfoForm() {	return audioEngineInfoForm;	}
		HelpBrowser* getHelpBrowser() {	return helpBrowser;	}
		DrumkitManager* getDrumkitManager() {	return drumkitManager;	}

		LadspaFXProperties* getLadspaFXProperties(uint nFX) {	return m_pLadspaFXProperties[nFX];	}

		void setStatusBarMessage(QString msg, int msec = 0);

		void loadNewInstrument(int instrNumber);

		vector<LadspaFXInfo*> getPluginList() {	return m_pluginList;	}
		LadspaFXGroup* getFXRootGroup() { return m_pFXRootGroup;	}

	private:
		/** HydrogenApp instance */
		static HydrogenApp *instance;

		QStatusBar *statusBar;
		MainForm *mainForm;
		Mixer *mixer;
		PatternEditorPanel *patternEditorPanel;
		AudioEngineInfoForm *audioEngineInfoForm;
		SongEditorPanel *songEditorPanel;
		HelpBrowser *helpBrowser;
		DrumkitManager *drumkitManager;
		vector<LadspaFXInfo*> m_pluginList;

		LadspaFXProperties *m_pLadspaFXProperties[MAX_FX];
		LadspaFXGroup *m_pFXRootGroup;

		// implement EngineListener interface
		void engineError(uint nErrorCode);

};



#endif
