/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: CpuLoadWidget.cpp,v 1.9 2004/02/11 10:00:34 comix Exp $
 *
 */


#include "CpuLoadWidget.h"
#include "HydrogenApp.h"
#include "lib/Hydrogen.h"

/**
 * Constructor
 */
CpuLoadWidget::CpuLoadWidget( QWidget * parent, const char * name ) : QWidget( parent, name )
{
	setMinimumSize( WIDTH, HEIGHT );
	setMaximumSize( WIDTH, HEIGHT );
	resize( WIDTH, HEIGHT );

	value = 0;
	nXRunValue = 0;
	changed = true;

	// Create temp image
	temp.resize( WIDTH, HEIGHT );

	// Background image
	string background_path = string( IMG_PATH ) + string( "/img/playerControlPanel/cpuLoad_back.png" );
	bool ok = back.load( background_path.c_str() );
	if( ok == false )
	{
		qWarning("CpuLoadWidget: Error loading pixmap");
	}

	// Leds image
	string leds_path = string( IMG_PATH ) + string( "/img/playerControlPanel/cpuLoad_leds.png" );
	ok = leds.load( leds_path.c_str() );
	if( ok == false )
	{
		qWarning( "CpuLoadWidget: Error loading pixmap" );
	}

	setErasePixmap( back );

	QTimer *timer = new QTimer(this);
	connect( timer, SIGNAL( timeout() ), this, SLOT( updateCpuLoadWidget() ) );

	timer->start(200);	// update player control at 5 fps

	(Hydrogen::getInstance())->addEngineListener( this );
}




/**
 * Destructor
 */
CpuLoadWidget::~CpuLoadWidget()
{
}




/**
 *
 */
void CpuLoadWidget::mousePressEvent(QMouseEvent *ev)
{
}




/**
 *
 */
void CpuLoadWidget::setValue(uint newValue)
{
	if (newValue > 97) {
		newValue = 97;
	}
	else if (newValue < 0) {
		newValue = 0;
	}

	if (this->value != newValue) {
		this->value = newValue;
		changed = true;
	}
}





/**
 *
 */
uint CpuLoadWidget::getValue()
{
	return value;
}








/**
 *
 */
void CpuLoadWidget::paintEvent( QPaintEvent*)
{
	if (!isVisible()) {
		return;
	}

	if (changed) {
		changed = false;

		// background
		bitBlt( &temp, 0, 0, &back, 0, 0, WIDTH, HEIGHT, CopyROP );

		// leds
		bitBlt( &temp, 0, 0, &leds, 0, 0, value, HEIGHT, CopyROP );

		if (nXRunValue > 0) {
			// xrun led
			bitBlt( &temp, 97, 0, &leds, 97, 0, WIDTH, HEIGHT, CopyROP );
		}


		setErasePixmap( temp );
	}
}





void CpuLoadWidget::updateCpuLoadWidget()
{
	// Process time
	Hydrogen *engine = Hydrogen::getInstance();
	int perc = 0;
	if ( engine->getMaxProcessTime() != 0.0 ) {
		perc = (int)( engine->getProcessTime() / ( engine->getMaxProcessTime() / 100.0 ) );
	}
	setValue( perc );

	if (nXRunValue > 0) {
		changed = true;
		nXRunValue -= 5;
	}

	update();
}



/**
 * This method is called from another thread (audio engine)
 */
void CpuLoadWidget::xRunEvent(float nTime, float nMaxTime)
{
	H2TextEvent *ev = new H2TextEvent("xRun");
	QApplication::postEvent( this, ev );
}




/**
 *
 */
void CpuLoadWidget::customEvent( QCustomEvent *ev ) {
	if ( ev->type() != H2_TEXT_EVENT ) {	// Must be a H2TextEvent
		return;
	}
	QString message = ((H2TextEvent*)ev)->getText();

	if (message == QString( "xRun" ) ) {
		nXRunValue = 100;
		changed = true;
		update();
	}

}


