---
 config/hwloc.m4               |    1 +
 hwloc/topology-freebsd.c      |    6 ++++++
 tests/hwloc/ports/Makefile.am |    5 +++--
 3 files changed, 10 insertions(+), 2 deletions(-)

--- a/config/hwloc.m4
+++ b/config/hwloc.m4
@@ -436,6 +436,7 @@ EOF])
     if test x$hwloc_freebsd = xyes; then
 
       AC_CHECK_HEADERS([sys/domainset.h])
+      AC_CHECK_HEADERS([sys/thr.h])
 
     fi
 
--- a/hwloc/topology-freebsd.c
+++ b/hwloc/topology-freebsd.c
@@ -16,7 +16,9 @@
 #include <pthread.h>
 #include <sys/cdefs.h>
 #include <stddef.h>
+#ifdef HAVE_SYS_THR_H
 #include <sys/thr.h>
+#endif
 #ifdef HAVE_PTHREAD_NP_H
 #include <pthread_np.h>
 #endif
@@ -345,6 +347,7 @@ hwloc_freebsd_get_proc_last_cpu_location
   return hwloc_freebsd_get_last_cpu_location(name, set, 0);
 }
 
+#ifdef HAVE_SYS_THR_H
 static int
 hwloc_freebsd_get_thisthread_last_cpu_location(hwloc_topology_t topology __hwloc_attribute_unused, hwloc_cpuset_t set, int flags __hwloc_attribute_unused) {
   long thr_id;
@@ -359,6 +362,7 @@ hwloc_freebsd_get_thisthread_last_cpu_lo
   name[3] = getpid();
   return hwloc_freebsd_get_last_cpu_location(name, set, thr_id);
 }
+#endif
 
 static int
 set_locality_info(hwloc_topology_t topology, int ndomains, hwloc_obj_t *nodes){
@@ -573,7 +577,9 @@ hwloc_set_freebsd_hooks(struct hwloc_bin
 #endif
   hooks->get_thisproc_last_cpu_location = hwloc_freebsd_get_thisproc_last_cpu_location;
   hooks->get_proc_last_cpu_location = hwloc_freebsd_get_proc_last_cpu_location;
+#ifdef HAVE_SYS_THR_H
   hooks->get_thisthread_last_cpu_location = hwloc_freebsd_get_thisthread_last_cpu_location;
+#endif
 }
 
 static struct hwloc_backend *
--- a/tests/hwloc/ports/Makefile.am
+++ b/tests/hwloc/ports/Makefile.am
@@ -1,5 +1,5 @@
 # Copyright © 2009-2020 Inria.  All rights reserved.
-# Copyright © 2009, 2011-2012 Université Bordeaux
+# Copyright © 2009, 2011-2012, 2020 Université Bordeaux
 # Copyright © 2009-2014 Cisco Systems, Inc.  All rights reserved.
 # See COPYING in top-level directory.
 
@@ -90,7 +90,8 @@ libhwloc_port_freebsd_la_CPPFLAGS = $(co
         -DHAVE_DECL_PTHREAD_SETAFFINITY_NP=1 \
         -DHAVE_DECL_PTHREAD_GETAFFINITY_NP=1 \
         -DHAVE_CPUSET_SETID \
-        -DHAVE_SYS_DOMAINSET_H
+        -DHAVE_SYS_DOMAINSET_H \
+        -DHAVE_SYS_THR_H
 
 nodist_libhwloc_port_hpux_la_SOURCES = topology-hpux.c
 libhwloc_port_hpux_la_SOURCES = \
