#include <cstdlib>
#include <cstring>
#include <cctype>
#include <cstdio>

#include "dictmgr.hxx"
#include "csutil.hxx"

#ifndef W32
using namespace std;
#endif


DictMgr::DictMgr(const char * dictpath, const char * etype) 
{
  // load list of dictionaries
  numdict = 0;
  pdentry = (dictentry *)malloc(MAXDICTIONARIES*sizeof(struct dictentry));
  if (pdentry) {
     if (parse_file(dictpath,etype)) {
        numdict = 0;
        fprintf(stderr,"Failure loading dictionary list\n");
        fflush(stderr);
     }
  } else {
     fprintf(stderr,"Error - Insufficient Memory\n");
     fflush(stderr);
  }
}


DictMgr::~DictMgr() 
{
  dictentry * pdict = NULL;
  if (pdentry) {
     pdict = pdentry;
     for (int i=0;i<numdict;i++) {
        if (pdict->lang) {
            free(pdict->lang);
            pdict->lang = NULL;
        }
        if (pdict->region) {
            free(pdict->region);
            pdict->region=NULL;
        }
        if (pdict->filename) {
            free(pdict->filename);
            pdict->filename = NULL;
        }
        pdict++;
     }
     free(pdentry);
     pdentry = NULL;
     pdict = NULL;
  }
  numdict = 0;
}


// read in list of dictionaries and build up structure to describe them
int  DictMgr::parse_file(const char * dictpath, const char * etype)
{

    int i;
    char line[MAXDICTENTRYLEN+1];
    dictentry * pdict = pdentry;

    // open the dictionary list file
    FILE * dictlst;
    dictlst = fopen(dictpath,"r");
    if (!dictlst) {
      fprintf(stderr,"Error - could not open dictionary description file\n");
      return 1;
    }

    // step one is to parse the dictionary list building up the 
    // descriptive structures

    // read in each line ignoring any that dont start with DICT
    while (fgets(line,MAXDICTENTRYLEN,dictlst)) {
       mychomp(line);

       /* parse in a dictionary entry */
       if (strncmp(line,etype,4) == 0) {
	  if (numdict < MAXDICTIONARIES) {
             char * tp = line;
             char * piece;
             i = 0;
             while ((piece=mystrsep(&tp,' '))) {
                if (*piece != '\0') {
                    switch(i) {
                       case 0: break;
		       case 1: { pdict->lang = mystrdup(piece); break; }
                       case 2: { pdict->region = mystrdup(piece); break; }
                       case 3: { pdict->filename = mystrdup(piece); break; }
		       default: break;
                    }
                    i++;
                }
                free(piece);
                if (i > 3) {
                    numdict++;
                    pdict++;
                }
	     }
	  }
       }
    }
    fclose(dictlst);
    return 0;
}

// return text encoding of dictionary
int DictMgr::get_list(dictentry ** ppentry)
{
  *ppentry = pdentry;
  return numdict;
}

