/*
 * If you change this file, please make sure that it gets changed in both
 * /src/templates/aurora/ and /src/templates/public
 */

//// Update selection when selected
function selectRow(selectbox)
{
    var currentrow = selectbox.parentNode.parentNode;
    if(selectbox.checked)
    {
        currentrow.className += ' selected';
    }
    else
    {
        currentrow.className = currentrow.className.replace(/ selected/g,'');
    }
}

// Select All / Clear All
function setChecked(val) {
    if (document.getElementsByName('MessageList').length > 0) {
        var elems = document.MessageList.elements;
        // var elems = document.getElementsByTagName('tr');

        for(i=0; i < elems.length; i++) {
            if (elems[i].name=='Item.ID') {
                elems[i].checked=val;
                selectRow(elems[i]);
            }
        }
    }
}

//// Make the checkbox work across page reloads
function checkChecked() {
    if (document.getElementsByName('MessageList').length > 0) {
        var elems = document.MessageList.elements;
        // var elems = document.getElementsByTagName('tr');

        for(i=0; i < elems.length; i++) {
            if (elems[i].name=='Item.ID') {
                selectRow(elems[i]);
            }
        }
    }
}

//// Toggle visibility of elements
function toggleVis(toggle) {
    var elem = document.getElementById(toggle);
    elem.style.display = (elem.style.display == "none")?"":"none";
}

//// Toggle visibility of elements
function toggleBold(elem) {
    elem.style.fontWeight = (elem.style.fontWeight == "strong")?"":"strong";
}

//// Handle form hiding/disabling
function onModeSelection(selectElement) {
    for(var index = 0; index < selectElement.options.length; index++) {
        var divToActivate = document.getElementById(selectElement.options[index].label);
        if (selectElement.options[index].selected) {
            divToActivate.style.display = 'block';
        } else {
            divToActivate.style.display = 'none'; 
        }
        var inputFields = divToActivate.getElementsByTagName("INPUT");
        for(var childIndex = 0; childIndex < inputFields .length; childIndex++) {
            if (selectElement.options[index].selected) {
                inputFields[childIndex].disabled = false;
            } else {
                inputFields[childIndex].disabled = true;
            }
        }
    }
}

//// Break out of frames
function noframes() {
    if (top.location != location) {
        top.location.href = document.location.href;
    }
}

//// Replace <input type="submit" value="Foo" name="Bar"> with <button name="Bar">Foo</button>
function replaceButtons() {
    var inputs = document.getElementsByTagName('input');
    for (var i = 0; i < inputs.length; i++) {
        if (inputs[i].getAttribute('type') == 'submit') {
            inputs[inputs.length] = inputs[i];

            var newbutton = document.createElement('button');

            // Add stuff to hook extra CSS style
            var tr,tl,br,bl = document.createElement('div');
            // tr.class='button-tr';
            // tl.class='button-tl';
            // br.class='button-br';
            // bl.class='button-bl';
            button_text = document.createTextNode(inputs[i].value);

            newbutton.value=inputs[i].value;
            newbutton.name=inputs[i].name;
            newbutton.appendChild(button_text);

            inputs[i].parentNode.appendChild(newbutton);
            inputs[i].parentNode.removeChild(inputs[i]);
        }
    }
    /*
    for (var i = 0; i < buttons.length; i++) {
        var orig = buttons[i];
        /// while (buttons[i].hasChildNodes()) {
            /// buttons[i].removeChild(buttons[i].lastChild);
            /// }
        var newbutton = document.createElement('button');
        newbutton.value = "Foo";
        buttons[i].parentNode.appendChild(newbutton);
    }
    */
}

//// Default functions on page load
window.onload=function() {
    noframes();
    //replaceButtons();
    checkChecked();
}
