/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <ctype.h>
#include <mdb.h>
#include <logger.h>

#include <mwmail.tok>
#include <mwmail.ary>
#include <modweb.ary>

#define	PRODUCT_SHORT_NAME						"mwmail.nlm"
#define	PRODUCT_NAME								"NetMail ModWeb Module"

#define	HOTMAIL_CHARSET_FIX

typedef struct {
	unsigned char	*Type;
	unsigned char	*Charset;
	unsigned char	*Encoding;
	unsigned char	*FileName;
	unsigned long	PartStart;
	unsigned long	PartSize;
	unsigned long	HeaderSize;
	unsigned long	Depth;
} MIMEStruct;

typedef struct {

	unsigned long	Error;

	/* Message State Images */
	unsigned long	ReadImage;
	unsigned long	ReadHighImage;
	unsigned long	ReadLowImage;
	unsigned long	UnreadImage;
	unsigned long	UnreadHighImage;
	unsigned long	UnreadLowImage;
	unsigned long	DeletedImage;

	/* Preferences */
	unsigned long	PurgeDefault;
	unsigned long	MaxRecipients;
	unsigned long	MaxSize;

	unsigned char	*SentFolder;
	unsigned long  *AttachPath;

	unsigned long	Attachments;					/* The number of files attached in compose	*/

	BOOL				InFileList;						/* TRUE while creating a list of attachments */
	unsigned long	CurrentFile;					/* The file # of the file being displayed		*/

	unsigned long	SearchScope;					/* Bitfield determining which AddrBooks to srch */
	unsigned char	*SearchString;					/* String used in all AddrBook searches      */
	unsigned char	InAddressList;					/* E-Personal Y-System U-Public 0-None       */

	unsigned long	Index;							/* Index to ValueStruct used for Address Lists*/
	unsigned char	ResultsPerPage;				/* The number of addrs listed per result page */
	unsigned long	FirstResultInList;			/* The index of first result on curent page   */

	/* Active Background */
	unsigned char	*CurrentColor;
	unsigned long	CurrentColorLen;

	/* Folder caching */
	unsigned long	CurrentFolder;					/* The currently selected folder					*/
	unsigned long	InFolderList;

	/* Messagelist caching */
	BOOL				MailboxSelected;				/* Have a mailbox selected in NMAP				*/
	BOOL				InMsgList;						/* Currently enumerating messages in list		*/

	unsigned long	CurrentMsgListMessage;		/* The currently displayed message				*/
	unsigned long	FirstMessageOnPage;			/* See below											*/
	unsigned long	LastMessageOnPage;			/* First on page - MsgPerPage = LastOnPage	*/
	unsigned long	*IDList;							/* ID -> NMAP ID translator						*/
	unsigned long	*UIDList;						/* UID -> ID translator								*/

	/* Message Caching */
	unsigned char	*CachedHeader;					/* Caching data for CachedMessageID				*/
	unsigned long	CachedMessageID;				/* ID of message described in cache				*/
	unsigned long	CachedMessageState;			/* Caching data for CachedMessageID				*/
	unsigned long	CachedMessageHeaderSize;	/* Caching data for CachedMessageID				*/
	unsigned long	CachedMessageBodySize;		/* Caching data for CachedMessageID				*/
	unsigned long	CachedMessageInternaldate;	/* Caching data for CachedMessageID				*/
	unsigned long	CachedSent;						/* Caching data for CachedMessageID				*/

	/* Message view caching */
	unsigned long	CurrentMsgViewMessage;		/* Message currently being displayed in view */
	unsigned long	CachedMIMEMessageID;			/* Message ID of message in MIME cache			*/
	unsigned long	MIMEUsed;						/* Number of elements used							*/
	unsigned long	MIMEAllocated;					/* Number of elements allocated					*/
	MIMEStruct		*MIME;							/* Cache structure									*/

	/* Body Part Caching */
	unsigned char	*CachedPartHeader;			/* Caching data for body part header			*/
	unsigned long	CachedPartID;					/* ID of Part described in cache					*/
	unsigned long	CachedPartState;				/* Caching data for CachedPartID					*/
	unsigned long	CachedPartInternaldate;		/* Caching data for CachedPartID					*/
	unsigned long	InAttachmentList;				/* Number of current displayed attachment		*/

	/* Message Body Chunking */
	unsigned long	NextChunkStart;				/* The offset into the next chunk				*/
	BOOL				MoreBodyText;					/* TRUE if not all the body has been read		*/ 

	/* Passing information between "connections" */
	unsigned long	ValueType;
	MDBValueStruct	*Value;

	/* Other flags for compose */
	unsigned long	Priority;
	unsigned long	DSNFlags;
	unsigned long	PrefixString;

	/* Stream Caching */
	StreamStruct	*MIMEParamStream;
} MailSessionStruct;

/* From mmsglist.c */
typedef struct {
	unsigned char	*FieldName;
	BOOL				ValueIsMsgID;
	unsigned long	CommandID;
} FormCommandStruct;


/* URL Request definitons */
#define	REQUEST_MSGLIST							4100
#define	REQUEST_MSGLIST_PREV						4101
#define	REQUEST_MSGLIST_NEXT						4102
#define	REQUEST_MSGLIST_LAST						4103
#define	REQUEST_MSGLIST_REFRESH					4104
#define	REQUEST_MSGLIST_PROCESS					4105
#define	REQUEST_REFRESH_FOLDERLIST				4106

#define	REQUEST_MESSAGE_DISPLAY					4150
#define	REQUEST_COMPOSE_ANSWER					4151
#define	REQUEST_COMPOSE_ANSWER_SIMPLE			4152
#define	REQUEST_COMPOSE_VIA_URL					4153
#define	REQUEST_MESSAGE_PART						4154
#define	REQUEST_MESSAGE_SETFLAG					4155
#define	REQUEST_MESSAGE_MOVE						4156
#define	REQUEST_MESSAGE_ACCEPT					4157
#define	REQUEST_MESSAGE_DECLINE					4158
#define	REQUEST_MESSAGE_DECLINE_COMMENT		4159
#define	REQUEST_MESSAGE_DELEGATE				4160
#define	REQUEST_MESSAGE_UNSETFLAG				4161

#define	REQUEST_FOLDER_MANAGE					4162
#define	REQUEST_FOLDER_MOVEMSG					4163

#define	COMPOSE_FORM								4200
#define  COMPOSE_CANCEL								4201

#define	ADDRESS_SEARCH_FORM						4400
#define	ADDRESS_SEARCH_CANCEL					4401
#define	ADDRESS_RESULT_FORM						4402
#define	ADDRESS_PERSONAL_VIEW					4403
#define	ADDRESS_PERSONAL_FORM					4404
#define	ADDRESS_SELECT_FORM						4405

/* Comes from MWCal - We just generate a URL for it here */
#define	REQUEST_DISPLAY_CALENDAR				1210

/* Types for SessionValueType */
#define	SESSION_VALUE_TYPE_MSGLIST				1
#define	SESSION_VALUE_TYPE_ADDRESSES			2


/* Compose defaults */
#define	DEFAULT_ATTACHMENT_CONTENT_TYPE		"application/octet-stream"
#define	DEFAULT_ATTACHMENT_NAME					"Unknown_File_Name"

/* mview.c constants */
#define	COMPOSE_FORWARD							1
#define	COMPOSE_REPLY								2
#define	COMPOSE_REPLYALL							3
#define	COMPOSE_REDIRECT							4
#define	COMPOSE_DELEGATE							5
#define	COMPOSE_DECLINE							6

#define	FLAG_DELETE									1
#define	FLAG_READ									2
#define	FLAG_HIPRIO									3
#define	FLAG_NORMPRIO								4
#define	FLAG_LOWPRIO								5
#define	FLAG_PRIVATE								6
#define	FLAG_RECENT									7

/* mfolder.c constants */
#define	FOLDER_CREATE								1
#define	FOLDER_DELETE								2
#define	FOLDER_RENAME								3

/* maddress.c constants */
#define	LDAP_PORT									389

/* These are the extensions for information we retrieve from the sender */
extern unsigned char	*COMPOSE_EXT_TO_LIST[];
#define	COMPOSE_TO									0
#define	COMPOSE_CC									1
#define	COMPOSE_BCC									2
#define	COMPOSE_EXT_SUBJECT						"sub"
#define	COMPOSE_EXT_BODY							"bdy"
#define	COMPOSE_EXT_LOCATION						"loc"
#define	COMPOSE_EXT_RRULE							"rul"
#define	COMPOSE_EXT_TEMP							"tmp"
#define	COMPOSE_EXT_ICAL							"ics"

/* Where we store our final message */
#define	COMPOSE_EXT_MESSAGE						"out"

#define	MAX_ERROR_LEN											256
#define	ERROR_NO_RECIPIENTS									1
#define	ERROR_TOO_MANY_RECIPIENTS							2
#define	ERROR_CONNECTING_TO_QUEUE							3
#define	ERROR_CREATING_MESSAGE__QCREA						4
#define	ERROR_CREATING_MESSAGE__FOPEN						5
#define	ERROR_CREATING_MESSAGE__LIST						6
#define	ERROR_CREATING_MESSAGE__QSTOR_FROM				7
#define	ERROR_CREATING_MESSAGE__QSTOR_RAW				8
#define	ERROR_CREATING_MESSAGE__QSTOR_TO					9
#define	ERROR_CREATING_MESSAGE__QSTOR_MESSAGE			10
#define	ERROR_CREATING_MESSAGE__QRUN						11
#define	ERROR_CREATING_MESSAGE__STAT						12
#define	ERROR_BUILDING_RECIP_LIST__FOPEN					13
#define	ERROR_BUILDING_RECIP_LIST__QSTOR_TO				14
#define	ERROR_NO_ENTRY_FOUND									15
#define	ERROR_SAVING_FORM_DATA__FOPEN						16
#define	ERROR_READING_FORM_DATA__FOPEN					17
#define	ERROR_NO_FOLDER_SELECTED							18
#define	ERROR_SELECTING_FOLDER__MBOX						19
#define	ERROR_CREATING_FOLDER__CREA						20
#define	ERROR_RENAMING_FOLDER__RNAM						21
#define	ERROR_REMOVING_FOLDER__RMOV						22
#define	ERROR_DELETING_MESSAGE__AFLG						23
#define	ERROR_COPYING_MESSAGE__COPY						24
#define	ERROR_STORING_ATTACHMENT__FOPEN					25
#define	ERROR_STORING_BODY__FOPEN							26
#define	ERROR_STORING_FORM_ELEMENT__FOPEN				27
#define	ERROR_ACCESSING_ORIGINAL_MESSAGE__MIME			28
#define	ERROR_ADDR_BOOK_ENTRY_EXCEEDED_SIZE_LIMIT		29
#define	ERROR_NOT_ENOUGH_MEMORY_TO_DISPLAY_ENTRY		30
#define	ERROR_MESSAGE_EXCEEDS_SIZE_LIMIT					31
#define ERROR_BAD_TO_ADDR 33
#define ERROR_BAD_CC_ADDR 34
#define ERROR_BAD_BCC_ADDR  34



/* Compose Actions */

#define	ACTION_SEARCH_TO							COMPOSE_TO
#define	ACTION_SEARCH_CC							COMPOSE_CC
#define	ACTION_SEARCH_BCC							COMPOSE_BCC
#define	ACTION_SEND_MESSAGE						4

/* Address Book Fields: Meta data  */
#define	ADDR_MAX_FIELD_PERSONAL					12
#define	ADDR_MAX_FIELD_SYSTEM					5
#define	ADDR_MAX_FIELD_PUBLIC					5
#define	ADDR_ENTRY_ID_LEN							8	

/* Address Book Search Form Switch Values and state variables for MailSession->InAddressList */
#define	NO												'\0'
#define	PERSONAL										'E'			/* T_ADDRESS_DISPLAY_START switches on the second character of Public, System, Private */
#define	SYSTEM										'Y'			/* T_ADDRESS_DISPLAY_START switches on the second character of Public, System, Private */
#define	PUBLIC										'U'			/* T_ADDRESS_DISPLAY_START switches on the second character of Public, System, Private */
#define	QUERY_STRING								'Q'			/* Q as in Query String */
#define	SEARCH_BUTTON								'S'			/* From button that triggers the Address Book Searches */
#define	LOAD_PAGE									'L'			/* Can be used for any button that needs to change pages after processing the form */

/* The original size of AddrPersonalForm Final String Buffer */
#define	ADDRBOOK_BLOCK_SIZE									1024			

#define	FILE_EXISTS									0

/* Temporary File Extenstions used in Result Form */
#define ADDRESS_FILE_EXTENSION					"ADR"
#define ID_FILE_EXTENSION							"IDS"

/* Bitfield for MailSession->SearchScope */	
#define	SEARCH_PERSONAL							(1 << 1)		/* Search and display Personal Address Book Stuff */
#define	SEARCH_SYSTEM								(1 << 2)		/* Search and display System Address Book Stuff */
#define	SEARCH_PUBLIC								(1 << 3)		/* Search and display Public Address Book Stuff */

/*  Bitfields needed to interpret DS Values */
#define	CFG_SHOW_GENERAL_SETTINGS_CONF		(1 << 8)		/* Show the General setting configuration */
#define	CFG_SHOW_APPEARANCE_CONF				(1 << 9)		/* Show the Appearance configuration */
#define	CFG_SHOW_COLORS_CONF						(1 << 10)	/* Show the Colors configuration */
#define	CFG_SHOW_FORWARDING_CONF				(1 << 11)	/* Show the Forwarding configuration */
#define	CFG_SHOW_AUTO_REPLY_CONF				(1 << 12)	/* Show the Auto-reply configuration */
#define	CFG_SHOW_FINGER_CONF						(1 << 13)	/* Show the Finger daemon configuration */
#define	CFG_SHOW_PROXY_CONFIG					(1 << 14)	/* Show the Proxy server configuration */
#define	CFG_REPLYTO_IS_FROM						(1 << 15)	/* Fake the from: field */


#define	PREFS_HS_SHIFT								0				/* Shift-left values for the MSGSRV_A_PREFERENCES */
#define	PREFS_BBAR_SHIFT							2				/* attribute on a user */
#define	PREFS_PURGE_SHIFT							4
#define	PREFS_EXCOMPOSE_SHIFT					5
#define	PREFS_HS										0x03			/* Bitmasks for the MSGSRV_A_PREFERENCES attribute */
#define	PREFS_BBAR									0x0C
#define	PREFS_PURGE									0x10
#define	PREFS_EXCOMPOSE							0x20

#define	ChopNL(String)		{ unsigned char *pTr; pTr=strchr((String), 0x0a);	if (pTr)	*pTr='\0'; pTr=strrchr((String), 0x0d); if (pTr) *pTr='\0'; }

typedef struct _MwMailGlobal {
    /* Paths */
    unsigned char WorkDir[XPL_MAX_PATH + 1];

    /* Handles */
    void *LogHandle;
    MDBHandle DirectoryHandle;

    /* System Settings */
    BOOL SortAddressBook;
    BOOL SortFirstName;
    BOOL DisplayTextAttachments;
    unsigned long AttachmentNameEncodingSend;
    unsigned long MaxMessageSize;
    unsigned long MaxRecipients;
    unsigned long NmapQAddress;

    /* Module State */	
    time_t TimeStamp;
    int Tgid;
    BOOL UnloadOK;
    XplSemaphore ShutdownSemaphore;
    XplAtomic LibraryUserCount;
   
} MwMailGlobal;

extern MwMailGlobal MwMail;

/* mwmail.c */
EXPORT BOOL MWMAILInit(MWAPIArg);
EXPORT BOOL MWMAILShutdown(void);
BOOL MWMAILInitSession(SessionStruct *Session, void **ModuleData);
BOOL MWMAILDestroySession(SessionStruct *Session, void *ModuleData);
BOOL MWMAILHandleTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long Page, TokenOverlayStruct *Token, unsigned long *GotoToken, void *ModuleData);
BOOL MWMAILHandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL, void *ModuleData);
void MWMAILShutdownSigHandler(int Signal);
int _NonAppCheckUnload(void);

/* mfolder.c */
BOOL MwMailProcessFolderManagementForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long Action);

/* mmsglist.c */
unsigned long	MwMailMakeRFC822Header(unsigned char *Header);
unsigned char	*MwMailParseRFC822Address(unsigned char *AddressLine, unsigned char *Name, unsigned int NameLen, unsigned char *Address, unsigned int AddressLen);
unsigned long	MwMailFindRFC822HeaderLine(unsigned char *Header, unsigned char *SearchFor, unsigned char **Result);
BOOL		MwMailFreeMessageSessionData(SessionStruct *Session, MailSessionStruct *MailSession);
BOOL		MwMailRefreshFolder(SessionStruct *Session, MailSessionStruct *MailSession);
BOOL		MwMailSelectFolder(unsigned long FolderID, SessionStruct *Session, MailSessionStruct *MailSession);
BOOL		MwMailLoadMessage(ConnectionStruct *Client, unsigned long MessageID, SessionStruct *Session, MailSessionStruct *MailSession);
BOOL		MwMailProcessMsgListForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long MsgListTemplate, unsigned long MoveTemplate, unsigned long CopyTemplate, unsigned long *NextTemplate);
BOOL		MwMailProcessFolderMessageMove(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, BOOL Move);

/* mcode.c */
int		MwMailFolderUTF7toUTF8(const unsigned char *UTF7, unsigned char *UTF8);
int		MwMailFolderUTF8toUTF7(const unsigned char *UTF8, int UTF8Len, unsigned char *UTF7, int UTF7Len);
unsigned long	MwMailProcessListForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long SessionValueType, FormCommandStruct *CommandList);

/* mcompose.c */
BOOL MwMailSessionUserIsICalOrganizer(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession);
BOOL MwMailComposeCleanUp(SessionStruct *Session, MailSessionStruct *MailSession);
BOOL MwMailSendAddressValues(ConnectionStruct *Client, SessionStruct *Session, unsigned char *FieldName);
BOOL MwMailProcessComposeForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long *CurrentPage, unsigned long NextPage);
BOOL MwMailPrepareComposeAnswer(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long AnswerType, unsigned long DropOriginalMessage);
BOOL MwMailHandleCalendarMessage(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long MessageID, BOOL Accept);

/* mview.c */
unsigned long MwMailPrintFormatted(unsigned long Number, unsigned char *Buffer, int bufLen);
BOOL MwMailSetMessageFlags(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long MessageID, unsigned long Flag);
BOOL MwMailUnSetMessageFlags(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long MessageID, unsigned long Flag);
BOOL MwMailClearMIMECache(MailSessionStruct *MailSession);
BOOL MwMailClearMIMECacheData(MailSessionStruct *MailSession);
BOOL MwMailLoadMIMECache(unsigned long MessageID, ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession);
BOOL MwMailSendBodyPart(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long MessageID, unsigned long Element);
BOOL MwMailDisplayBody(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long RFCTemplateID, unsigned long ComposeID, unsigned char *LinkTarget, unsigned long MessageID, unsigned long MIMEElement, unsigned long Depth);
BOOL MwMailDisplayBodySource(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long ComposeID, unsigned long MessageID);
BOOL MwMailDisplayBodyText(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long RFCTemplateID, unsigned long ComposeID, unsigned char *LinkTarget, unsigned long MessageID, unsigned long MIMEElement, unsigned long Depth, unsigned long *ChunkStart, unsigned long ChunkSize, BOOL *More);

/* maddress.c */
BOOL MwMailAddrBookSearch(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession);
BOOL MwMailGetPersonalAddressBookEntry(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long ListIdx, unsigned long PersonalEntryID);
BOOL MwMailProcessAddrPersonalForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long PersonalEntryID, unsigned long *CurrentPage, unsigned long NextPage);
BOOL MwMailProcessAddrResultForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long *NewPage, unsigned long Page1, unsigned long Page2, unsigned long Page3);
BOOL MwMailProcessAddrSearchForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long *NewPage, unsigned long ResultsPage);
BOOL MwMailProcessAddrSelectForm(ConnectionStruct *Client, SessionStruct *Session, MailSessionStruct *MailSession, unsigned long *NewPage);
BOOL MwMailAddrBookCleanUp(SessionStruct *Session, MailSessionStruct *MailSession);


/*
	This controls how UIDs and IDs are used

	If ABSOLUTE_ID is defined, mwmail will generate ID based templates; this behaviours 
   does not allow for users who work in multiple windows simultaneously

	if ABSOLUTE_ID is not defined, templates will contain UID references;
	FAST_UID will switch to a macros instead of a function for translating IDs to UIDs
*/

#define			FAST_UID		1

#define			NO_UID		((unsigned long)-1)

#ifdef ABSOLUTE_ID
#	define						UIDtoID(Session, MailSession, UID)		UID
#	define						IDtoUID(Session, MailSession, ID)		ID
#else
        unsigned long				MwMailUIDtoIDFunc(SessionStruct *Session, MailSessionStruct *MailSession, unsigned long UID);
	unsigned long				MwMailIDtoUIDFunc(SessionStruct *Session, MailSessionStruct *MailSession, unsigned long ID);
#	ifdef FAST_UID
#		define					IDtoUID(Session, MailSession, ID)	(ID>Session->NumOfMessages ? NO_UID : MailSession->UIDList[ID-1])
#	else
#		define					IDtoUID(Session, MailSession, ID)	MwMailIDtoUIDFunc(Session, MailSession, ID)
#	endif	/* FAST_UID */
#	define						UIDtoID(Session, MailSession, UID)	MwMailUIDtoIDFunc(Session, MailSession, UID)
#endif	/* ABSOLUTE_ID */
