/*
 *  (c) Copyright 2001-2002 Novell, Inc.
 */

typedef struct {
	unsigned char	*TZName;
	unsigned char	*FullTZ;
} ICalTZRuleStruct;

static ICalTZRuleStruct		ICalTZRules[] = {
	{	/*	TZ_UTC						*/		"UTC",																			"BEGIN:VTIMEZONE\r\nTZID:UTC\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																												},
	{	/*	TZ_GREENWICH				*/		"Casablanca, Monrovia",														"BEGIN:VTIMEZONE\r\nTZID:Casablanca, Monrovia\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_GMT						*/		"Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London",		"BEGIN:VTIMEZONE\r\nTZID:Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T010000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"	},
	{	/*	TZ_WEST_EUROPE				*/		"Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",				"BEGIN:VTIMEZONE\r\nTZID:Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"				},
	{	/*	TZ_CENTRAL_EUROPE			*/		"Belgrade, Bratislava, Budapest, Ljubljana, Prague",				"BEGIN:VTIMEZONE\r\nTZID:Belgrade, Bratislava, Budapest, Ljubljana, Prague\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"			},
	{	/*	TZ_ROMANCE					*/		"Brussels, Copenhagen, Madrid, Paris",									"BEGIN:VTIMEZONE\r\nTZID:Brussels, Copenhagen, Madrid, Paris\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"								},
	{	/*	TZ_CENTRAL_EUROPEAN		*/		"Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb",				"BEGIN:VTIMEZONE\r\nTZID:Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"			},
	{	/*	TZ_WEST_CENTRAL_AFRICA	*/		"West Central Africa",														"BEGIN:VTIMEZONE\r\nTZID:West Central Africa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_GBT						*/		"Athens, Istanbul, Minsk",													"BEGIN:VTIMEZONE\r\nTZID:Athens, Istanbul, Minsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"												},
	{	/*	TZ_EAST_EUROPE				*/		"Bucharest",																	"BEGIN:VTIMEZONE\r\nTZID:Bucharest\r\nBEGIN:STANDARD\r\nDTSTART:20000924T010000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=9\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																	},
	{	/*	TZ_EGYPT						*/		"Cairo",																			"BEGIN:VTIMEZONE\r\nTZID:Cairo\r\nBEGIN:STANDARD\r\nDTSTART:20000927T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1WE;BYMONTH=9\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010504T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1FR;BYMONTH=5\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																			},
	{	/*	TZ_SOUTH_AFRICA			*/		"Harare, Pretoria",															"BEGIN:VTIMEZONE\r\nTZID:Harare, Pretoria\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																								},
	{	/*	TZ_FLE						*/		"Helsinki, Riga, Tallinn",													"BEGIN:VTIMEZONE\r\nTZID:Helsinki, Riga, Tallinn\r\nBEGIN:STANDARD\r\nDTSTART:20001029T040000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"												},
	{	/*	TZ_ISRAEL					*/		"Jerusalem",																	"BEGIN:VTIMEZONE\r\nTZID:Jerusalem\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																										},
	{	/*	TZ_ARABIC					*/		"Baghdad",																		"BEGIN:VTIMEZONE\r\nTZID:Baghdad\r\nBEGIN:STANDARD\r\nDTSTART:20001001T040000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_ARAB						*/		"Kuwait, Riyadh",																"BEGIN:VTIMEZONE\r\nTZID:Kuwait, Riyadh\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																									},
	{	/*	TZ_RUSSIAN					*/		"Moscow, St. Petersburg, Volgograd",									"BEGIN:VTIMEZONE\r\nTZID:Moscow, St. Petersburg, Volgograd\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"									},
	{	/*	TZ_EAST_AFRICA				*/		"Nairobi",																		"BEGIN:VTIMEZONE\r\nTZID:Nairobi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_IRAN						*/		"Tehran",																		"BEGIN:VTIMEZONE\r\nTZID:Tehran\r\nBEGIN:STANDARD\r\nDTSTART:20000926T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=4TU;BYMONTH=9\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0330\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010304T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=3\r\nTZOFFSETFROM:+0330\r\nTZOFFSETTO:+0430\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE"																				},
	{	/*	TZ_ARABIAN					*/		"Abu Dhabi, Muscat",															"BEGIN:VTIMEZONE\r\nTZID:Abu Dhabi, Muscat\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																								},
	{	/*	TZ_CAUCASUS					*/		"Baku, Tbilisi, Yerevan",													"BEGIN:VTIMEZONE\r\nTZID:Baku, Tbilisi, Yerevan\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"												},
	{	/*	TZ_AFGHANISTAN				*/		"Kabul",																			"BEGIN:VTIMEZONE\r\nTZID:Kabul\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0430\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																												},
	{	/*	TZ_EKATERINENBURG			*/		"Ekaterinburg",																"BEGIN:VTIMEZONE\r\nTZID:Ekaterinburg\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0600\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_WEST_ASIA				*/		"Islamabad, Karachi, Tashkent",											"BEGIN:VTIMEZONE\r\nTZID:Islamabad, Karachi, Tashkent\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																				},
	{	/*	TZ_INDIA						*/		"Calcutta, Chennai, Mumbai, New Delhi",								"BEGIN:VTIMEZONE\r\nTZID:Calcutta, Chennai, Mumbai, New Delhi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0530\r\nTZOFFSETTO:+0530\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																	},
	{	/*	TZ_NEPAL						*/		"Kathmandu",																	"BEGIN:VTIMEZONE\r\nTZID:Kathmandu\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0545\r\nTZOFFSETTO:+0545\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																										},
	{	/*	TZ_NORTH_CENTRAL_ASIA	*/		"Almaty, Novosibirsk",														"BEGIN:VTIMEZONE\r\nTZID:Almaty, Novosibirsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0700\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"													},
	{	/*	TZ_CENTRAL_ASIA			*/		"Astana, Dhaka",																"BEGIN:VTIMEZONE\r\nTZID:Astana, Dhaka\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																									},
	{	/*	TZ_SRI_LANKA				*/		"Sri Jayawardenepura",														"BEGIN:VTIMEZONE\r\nTZID:Sri Jayawardenepura\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_MYANMAR					*/		"Rangoon",																		"BEGIN:VTIMEZONE\r\nTZID:Rangoon\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0630\r\nTZOFFSETTO:+0630\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_SOUTH_EAST_ASIA		*/		"Bangkok, Hanoi, Jakarta",													"BEGIN:VTIMEZONE\r\nTZID:Bangkok, Hanoi, Jakarta\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																						},
	{	/*	TZ_NORTH_EAST_ASIA		*/		"Krasnoyarsk",																	"BEGIN:VTIMEZONE\r\nTZID:Krasnoyarsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0800\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_CHINA						*/		"Beijing, Chongqing, Hong Kong, Urumqi",								"BEGIN:VTIMEZONE\r\nTZID:Beijing, Chongqing, Hong Kong, Urumqi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																	},
	{	/*	TZ_NORTH_ASIA_EAST		*/		"Irkutsk, Ulaan Bataar",													"BEGIN:VTIMEZONE\r\nTZID:Irkutsk, Ulaan Bataar\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0900\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"													},
	{	/*	TZ_SINGAPORE				*/		"Kuala Lumpur, Singapore",													"BEGIN:VTIMEZONE\r\nTZID:Kuala Lumpur, Singapore\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																						},
	{	/*	TZ_WEST_AUSTRALIA			*/		"Perth",																			"BEGIN:VTIMEZONE\r\nTZID:Perth\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																												},
	{	/*	TZ_TAIPEI					*/		"Taipei",																		"BEGIN:VTIMEZONE\r\nTZID:Taipei\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_TOKYO						*/		"Osaka, Sapporo, Tokyo",													"BEGIN:VTIMEZONE\r\nTZID:Osaka, Sapporo, Tokyo\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																						},
	{	/*	TZ_KOREA						*/		"Seoul",																			"BEGIN:VTIMEZONE\r\nTZID:Seoul\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																												},
	{	/*	TZ_YAKUTSK					*/		"Yakutsk",																		"BEGIN:VTIMEZONE\r\nTZID:Yakutsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+1000\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																	},
	{	/*	TZ_CENTRAL_AUSTRALIA		*/		"Adelaide",																		"BEGIN:VTIMEZONE\r\nTZID:Adelaide\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1030\r\nTZOFFSETTO:+0930\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+1030\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																	},
	{	/*	TZ_AUS_CENTRAL				*/		"Darwin",																		"BEGIN:VTIMEZONE\r\nTZID:Darwin\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+0930\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_EAST_AUSTRALIA			*/		"Brisbane",																		"BEGIN:VTIMEZONE\r\nTZID:Brisbane\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_AUS_EASTERN				*/		"Canberra, Melbourne, Sydney",											"BEGIN:VTIMEZONE\r\nTZID:Canberra, Melbourne, Sydney\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"											},
	{	/*	TZ_WEST_PACIFIC			*/		"Guam, Port Moresby",														"BEGIN:VTIMEZONE\r\nTZID:Guam, Port Moresby\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_TASMANIA					*/		"Hobart",																		"BEGIN:VTIMEZONE\r\nTZID:Hobart\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001001T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_VLADIVOSTOK				*/		"Vladivostok",																	"BEGIN:VTIMEZONE\r\nTZID:Vladivostok\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_CENTRAL_PACIFIC		*/		"Magadan, Solomon Is., New Caledonia",									"BEGIN:VTIMEZONE\r\nTZID:Magadan, Solomon Is., New Caledonia\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																		},
	{	/*	TZ_NEW_ZEALAND				*/		"Auckland, Wellington",														"BEGIN:VTIMEZONE\r\nTZID:Auckland, Wellington\r\nBEGIN:STANDARD\r\nDTSTART:20010318T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=3SU;BYMONTH=3\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001001T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"														},
	{	/*	TZ_FIJI						*/		"Fiji, Kamchatka, Marshall Is.",											"BEGIN:VTIMEZONE\r\nTZID:Fiji, Kamchatka, Marshall Is.\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																				},
	{	/*	TZ_TONGO						*/		"Nuku'alofa",																	"BEGIN:VTIMEZONE\r\nTZID:Nuku'alofa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																										},
	{	/*	TZ_AZORES					*/		"Azores",																		"BEGIN:VTIMEZONE\r\nTZID:Azores\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:-0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:+0000\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_CAPE_VERDE				*/		"Cape Verde Is.",																"BEGIN:VTIMEZONE\r\nTZID:Cape Verde Is.\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:-0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																									},
	{	/*	TZ_MID_ATLANTIC			*/		"Mid-Atlantic",																"BEGIN:VTIMEZONE\r\nTZID:Mid-Atlantic\r\nBEGIN:STANDARD\r\nDTSTART:20000924T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=9\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:-0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_EAST_SOUTH_AMERICA	*/		"Brasilia",																		"BEGIN:VTIMEZONE\r\nTZID:Brasilia\r\nBEGIN:STANDARD\r\nDTSTART:20010211T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SU;BYMONTH=2\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001015T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=3SU;BYMONTH=10\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_SA_EASTERN				*/		"Buenos Aires, Georgetown",												"BEGIN:VTIMEZONE\r\nTZID:Buenos Aires, Georgetown\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																					},
	{	/*	TZ_GREENLAND				*/		"Greenland",																	"BEGIN:VTIMEZONE\r\nTZID:Greenland\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																	},
	{	/*	TZ_NEWFOUNDLAND			*/		"Newfoundland",																"BEGIN:VTIMEZONE\r\nTZID:Newfoundland\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0230\r\nTZOFFSETTO:-0330\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0330\r\nTZOFFSETTO:-0230\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_ATLANTIC					*/		"Atlantic Time (Canada)",													"BEGIN:VTIMEZONE\r\nTZID:Atlantic Time (Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"													},
	{	/*	TZ_SA_WESTERN				*/		"Caracas, La Paz",															"BEGIN:VTIMEZONE\r\nTZID:Caracas, La Paz\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																								},
	{	/*	TZ_PACIFIC_SA				*/		"Santiago",																		"BEGIN:VTIMEZONE\r\nTZID:Santiago\r\nBEGIN:STANDARD\r\nDTSTART:20010310T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SA;BYMONTH=3\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001014T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SA;BYMONTH=10\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_SA_PACIFIC				*/		"Bogota, Lima, Quito",														"BEGIN:VTIMEZONE\r\nTZID:Bogota, Lima, Quito\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_EASTERN					*/		"Eastern Time (US & Canada)",												"BEGIN:VTIMEZONE\r\nTZID:Eastern Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"											},
	{	/*	TZ_US_EASTERN				*/		"Indiana (East)",																"BEGIN:VTIMEZONE\r\nTZID:Indiana (East)\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																									},
	{	/*	TZ_CENTRAL_AMERICA		*/		"Central America",															"BEGIN:VTIMEZONE\r\nTZID:Central America\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																								},
	{	/*	TZ_CENTRAL					*/		"Central Time (US & Canada)",												"BEGIN:VTIMEZONE\r\nTZID:Central Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"											},
	{	/*	TZ_MEXICO					*/		"Mexico City",																	"BEGIN:VTIMEZONE\r\nTZID:Mexico City\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																},
	{	/*	TZ_CANADA_CENTRAL			*/		"Saskatchewan",																"BEGIN:VTIMEZONE\r\nTZID:Saskatchewan\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																									},
	{	/*	TZ_US_MOUNTAIN				*/		"Arizona",																		"BEGIN:VTIMEZONE\r\nTZID:Arizona\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_MOUNTAIN					*/		"Mountain Time (US & Canada)",											"BEGIN:VTIMEZONE\r\nTZID:Mountain Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"											},
	{	/*	TZ_PACIFIC					*/		"Pacific Time (US & Canada); Tijuana",									"BEGIN:VTIMEZONE\r\nTZID:Pacific Time (US & Canada); Tijuana\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"								},
	{	/*	TZ_ALASKAN					*/		"Alaska",																		"BEGIN:VTIMEZONE\r\nTZID:Alaska\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"																		},
	{	/*	TZ_HAWAIIAN					*/		"Hawaii",																		"BEGIN:VTIMEZONE\r\nTZID:Hawaii\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																											},
	{	/*	TZ_SAMOA						*/		"Midway Island, Samoa",														"BEGIN:VTIMEZONE\r\nTZID:Midway Island, Samoa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1100\r\nTZOFFSETTO:-1100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							},
	{	/*	TZ_DATELINE					*/		"Eniwetok, Kwajalein",														"BEGIN:VTIMEZONE\r\nTZID:Eniwetok, Kwajalein\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1200\r\nTZOFFSETTO:-1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"																																																																																																							}
};

/* Recurrence rules defines */
#define	DAILY											0
#define	WEEKLY										1
#define	MONTHLY										2
#define	YEARLY										3

#define	NOEND											0
#define	DATEEND										1
#define	COUNTEND										2

