/****************************************************************************
 *
 * Copyright (c) 2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>

/* Definitions */
#define	PRODUCT_NAME "Hula Logging Library"
#define	PRODUCT_VERSION "$Revision:  $"

/* Includes */
#include "loggerp.h"

/* Globals */
LoggerConfiguration Logger;

/* Prototypes */


static BOOL
LoggerReadConfiguration(void)
{
    Logger.log = LoggerGetSyslog ();

    return(Logger.log != NULL);
}

EXPORT void
LoggerEvent(void *loggingHandle, const char *subsystem, unsigned long eventId, int level, int flags, const char *str1, const char *str2, int i1, int i2, void *p, int size)
{
    if (Logger.log && Logger.log->event) {
	Logger.log->event(loggingHandle, subsystem, eventId, level, flags, str1, str2, i1, i2, p, size);
    }
    
    return;
}

EXPORT void
LoggerClose(void *loggingHandle)
{
    if (Logger.log && Logger.log->close) {
	Logger.log->close(loggingHandle);
    }
    
    return;
}

EXPORT void *
LoggerOpen(const char *name)
{
    void *handle;
    
    if (Logger.State < LOGGER_STATE_INITIALIZING) {
	Logger.State = LOGGER_STATE_INITIALIZING;

	if (LoggerReadConfiguration()) {
	    Logger.State = LOGGER_STATE_RUNNING;
	} else {
	    Logger.State = LOGGER_STATE_ABORTING;
	}
    }

    if (Logger.log == NULL) {
        return NULL;
    }

    handle = Logger.log->open (name);

    while (Logger.State < LOGGER_STATE_RUNNING) {
	    XplDelay(250);
    }

    return handle;
}

#if defined(WIN32)
#if 0
BOOL WINAPI 
DllMain(HINSTANCE hInst, DWORD Reason, LPVOID Reserved)
{
    if (Reason == DLL_PROCESS_ATTACH) {
	DisableThreadLibraryCalls(hInst);
    }

    return(TRUE);
}
#endif
#elif defined(NETWARE) || defined(LIBC)
void
LoggerSignalHandler(int sigtype)
{
    static int	signaled = FALSE;

    if (!signaled && ((sigtype == SIGTERM) || (sigtype == SIGINT))) {
	XplSignalLocalSemaphore(Logger.Shutdown);
	XplWaitOnLocalSemaphore(Logger.Shutdown);

	XplCloseLocalSemaphore(Logger.Shutdown);
    }

    return;
}

int
main(int argc, char *argv[])
{
    int i;
    int	ccode;
    unsigned long semValue = 0;

    Logger.State = LOGGER_STATE_INITIALIZING;

    XplOpenLocalSemaphore(Logger.Shutdown, 0);

    XplSignalHandler(LoggerSignalHandler);

    if (LoggerReadConfiguration()) {
	Logger.State = LOGGER_STATE_RUNNING;
    } else {
	Logger.State = LOGGER_STATE_ABORTING;
    }

    XplSignalLocalSemaphore(Logger.Shutdown);

    return(0);
}
#endif
