/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

/*****************************************************************************
 Layout of the Template file. Since most every thing is variable length,
 offsets must be calculated based on LanguageCount/StringCount/ImageCount and
 TemplateCount.

 The above structure can be overlaid when the template is loaded, to make it
 easier to get to the variables required for calculating offsets to the fixup
 table.


[Name]
[LanguageCount] [StringCount] [ImageCount] [TemplateCount] [FixupCount]
[DraftTemplate] [SentItemTemplate] [InitialTemplate]
[Spare 1] ... [Spare 10]

[Language ID 0] [Language ID 1] [Language ID n]

[Pointer to Language 1 String array 1..n]
[Pointer to Language 1 Image array 1..n]

[Pointer to Language 2 String array 1..n]
[Pointer to Language 2 Image array 1..n]

[Pointer to Template 1 ]
[Pointer to Template 2 ]
[Pointer to Template n ]


[Language 1 string 1]
[Language 1 string 2]
[Language 1 string n]
[Language 1 image 1]
[Language 1 image 2]
[Language 1 image n]

[Language 2 string 1]
[Language 2 string 2]
[Language 2 string n]
[Language 2 image 1]
[Language 2 image 2]
[Language 2 image n]

[Named Template 1]
[Named Template 2]
[Named Template n]

[Template 1]
[Template 2]
[Template n]

*****************************************************************************/

