/****************************************************************************
 *
 * Copyright (c) 2004-2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef HULA_MGRP_H
#define HULA_MGRPP_H

#include <xpl.h>

#include <errno.h>
#include <openssl/ssl.h>
#include <openssl/md5.h>
#include <openssl/rand.h>
#include <openssl/err.h>

#include <connio.h>
#include <msgapi.h>
#include <mdb.h>
#include <logger.h>
#include <management.h>

#define MSGSRV_TRAP_SHUTDOWN             1
#define MSGSRV_TRAP_STARTUP              2

#define HULAMRG_AGENT_DMC_PRIORITY        0
#define HULAMRG_AGENT_NMAP_PRIORITY       1
#define HULAMRG_AGENT_SMTP_PRIORITY       2
#define HULAMRG_AGENT_MINIMUM_PRIORITY    10
#define HULAMRG_AGENT_DEFAULT_PRIORITY    65535

#if defined(PRODUCT_MAJOR_VERSION)
#undef PRODUCT_MAJOR_VERSION
#define PRODUCT_MAJOR_VERSION            3
#endif

#if defined(PRODUCT_MINOR_VERSION)
#undef PRODUCT_MINOR_VERSION
#define PRODUCT_MINOR_VERSION            52
#endif

#if defined(PRODUCT_LETTER_VERSION)
#undef PRODUCT_LETTER_VERSION
#define PRODUCT_LETTER_VERSION           3
#endif

typedef enum _HULA_MANAGER_STATES {
    HULAMRG_STATE_STARTING = 0, 
    HULAMRG_STATE_INITIALIZING, 
    HULAMRG_STATE_LOADING, 
    HULAMRG_STATE_RUNNING, 
    HULAMRG_STATE_RELOADING, 
    HULAMRG_STATE_UNLOADING, 
    HULAMRG_STATE_STOPPING, 
    HULAMRG_STATE_DONE, 

    HULAMRG_STATE_MAX_STATES
} HulaManagerStates;

typedef enum _HULA_MANAGER_FLAGS {
    HULAMRG_FLAG_FAILED_SHUTDOWN = (1 << 0), 
    HULAMRG_FLAG_MODULE_LOADED = (1 << 1), 
    HULAMRG_FLAG_MODULE_ENABLED = (1 << 2), 
    HULAMRG_FLAG_MODULE_DMC = (1 << 3), 
    HULAMRG_FLAG_MODULE_NMAP = (1 << 4), 
    HULAMRG_FLAG_MODULE_SMTP = (1 << 5), 
    HULAMRG_FLAG_VERBOSE = (1 << 6), 
    HULAMRG_FLAG_FALSIFY_LOAD = (1 << 7), 

    HULAMRG_FLAG_MAX_FLAGS = (1 << 31)
} HulaManagerFlags;

typedef struct _HULA_MANAGER_AGENT {
    struct _HULA_MANAGER_AGENT   *next;
    struct _HULA_MANAGER_AGENT   *previous;

    unsigned char               name[XPL_MAX_PATH + 1];

    HulaManagerFlags             flags;

    unsigned int                priority;

    unsigned int                load;

    void                        *data;
} HulaManagerAgent;

typedef struct _HULA_MANAGER_CONFIG_DATA {
    XplRWLock                   lock;

    HulaManagerFlags             flags;
    HulaManagerStates            state;

    unsigned long               version;

    struct {
        XplThreadID             main;
        XplThreadID             group;
    } id;

    struct {
        XplSemaphore            main;
        XplSemaphore            shutdown;
    } sem;

    struct {
        MDBHandle               handle;

        unsigned char           tree[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char           host[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char           dn[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char           webAdmin[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char           *rdn;
    } directory;

    struct {
        unsigned int            count;

        HulaManagerAgent         *head;
        HulaManagerAgent         *tail;
    } agents;

    struct {
        int                     reload;
    } times;

    struct {
        SSL_CTX                 *server;
        SSL_CTX                 *client;
    } ssl;

    struct {
        unsigned char           work[XPL_MAX_PATH + 1];
        unsigned char           bin[XPL_MAX_PATH + 1];
        unsigned char           dbf[XPL_MAX_PATH + 1];
        unsigned char           certificate[XPL_MAX_PATH + 1];
        unsigned char           privateKey[XPL_MAX_PATH + 1];
    } paths;

    void                        *logging;

    int                         signo;
} HulaManagerConfig;

/*
    hula-mgr.c
*/
extern HulaManagerConfig         HulaManager;

BOOL HulaManagerLoad(HulaManagerFlags Flags);
void HulaManagerUnload(void);

void HulaManagerStartAgents(void);
void HulaManagerStopAgents(void);

/*
    unix-mgr.c
    win32-mgr.c
    netware-mgr.c
*/
BOOL HulaManagerAgentPrep(HulaManagerAgent *Agent);
void HulaManagerAgentRelease(HulaManagerAgent *Agent);

BOOL HulaManagerLoadAgent(HulaManagerAgent *Agent);
BOOL HulaManagerUnloadAgent(HulaManagerAgent *Agent);

#endif    /*    HULA_MGRP_H    */
