/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _GENERIC_H
#define _GENERIC_H

#include <connio.h>
#include <mdb.h>
#include <management.h>
#include <msgapi.h>
#include <nmap.h>
#include <nmlib.h>

#define PRODUCT_SHORT_NAME "hulageneric.nlm"

#define CONNECTION_TIMEOUT (15 * 60)

typedef enum _GAgentStates {
    GAGENT_STATE_STARTING = 0, 
    GAGENT_STATE_INITIALIZING, 
    GAGENT_STATE_LOADING, 
    GAGENT_STATE_RUNNING, 
    GAGENT_STATE_RELOADING, 
    GAGENT_STATE_UNLOADING, 
    GAGENT_STATE_STOPPING, 
    GAGENT_STATE_DONE, 

    GAGENT_STATE_MAX_STATES
} GAgentStates;

typedef enum _GAgentFlags {
    GAGENT_FLAG_UNUSED = (1 << 0), 
} GAgentFlags;

typedef enum _GAgentClientFlags {
    GAGENT_CLIENT_FLAG_NEW = (1 << 0), 
    GAGENT_CLIENT_FLAG_WAITING = (1 << 1), 
    GAGENT_CLIENT_FLAG_EXITING = (1 << 2)
} GAgentClientFlags;

#pragma pack(push, 4)
typedef struct {
    GAgentClientFlags flags;

    Connection *conn;

    unsigned char *envelope;
    unsigned char line[CONN_BUFSIZE + 1];
    unsigned char command[CONN_BUFSIZE + 1];
    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
} GAgentClient;

typedef struct _GAgentGlobals {
    GAgentStates state;
    GAgentFlags flags;

    unsigned char officialName[MAXEMAILNAMESIZE + 1];

    struct {
        XplSemaphore semaphore;

        struct {
            XplSemaphore todo;

            XplAtomic maximum;
            XplAtomic active;
            XplAtomic idle;

            Connection *head;
            Connection *tail;
        } worker;

        struct {
            BOOL enable;

            ConnSSLConfiguration config;

            SSL_CTX *context;

            Connection *conn;
        } ssl;

        Connection *conn;

        void *pool;

        time_t sleepTime;

        unsigned long queue;

        unsigned char address[80];
        unsigned char hash[NMAP_HASH_SIZE];
    } nmap;

    struct {
        MDBHandle directory;

        void *logging;
    } handle;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    struct {
        XplSemaphore main;
        XplSemaphore shutdown;
    } sem;

    struct {
        XplAtomic active;
    } server;

    struct {
        XplAtomic called;
    } stats;
} GAgentGlobals;
#pragma pack(pop)

extern GAgentGlobals GAgent;

/* management.c */
ManagementVariables *GetGAgentManagementVariables(void);
int GetGAgentManagementVariablesCount(void);
ManagementCommands *GetGAgentManagementCommands(void);
int GetGAgentManagementCommandsCount(void);

#endif /* _GENERIC_H */
