/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef _MWTEMPL_H
#define _MWTEMPL_H

#define	TEMPLATE_NAME_SIZE	28

#define	ARG_UNKNOWN			0
#define	ARG_TEXT				1
#define	ARG_STRING			2
#define	ARG_URL				3
#define	ARG_PAGE				4
#define	ARG_PAGEID			5
#define	ARG_IMAGE			6
#define	ARG_NUM				7
#define	ARG_ASSOC			8
#define	ARG_STATIC			9

#define	TEMPLATE_CURRENT_VERSION	0x4d570004

typedef struct _TemplateStruct {
	unsigned long	VersionID;
	unsigned char	Name[TEMPLATE_NAME_SIZE];
	unsigned long	LanguageCount;
	unsigned long	StringCount;
	unsigned long	ImageCount;
	unsigned long	TemplateCount;
	unsigned long	NameCount;
	unsigned long	CommonStaticObjectCount;
	unsigned long	FixupCount;
	unsigned long	InitialTemplate;
	unsigned long	InitialWMLTemplate;
	unsigned long	TimeoutTemplate;
	unsigned long	ResumeTemplate;
	unsigned long	Colors[10][2];
	unsigned long	DescriptionString;	/* 0 based, -1 = No Description */
	unsigned long	Spare[9];
    unsigned char SourcePath[XPL_MAX_PATH + 1];
} TemplateStruct;

typedef struct _TokenOverlayStruct {
	unsigned long	TokenID;
	unsigned long	Length;
	unsigned long	PrevSize;
	unsigned long	ArgumentSize[5];
	unsigned long	ArgumentOffsetOrID[5];
	unsigned char	Data[0];
} TokenOverlayStruct;

typedef struct _TemplateObjectOverlay {
    time_t FileModTime;
    unsigned long FileNameLen;
    unsigned long ContentTypeLen;
    unsigned long ObjectLen;
    unsigned char *FileName;
    unsigned char *ContentType;
    unsigned char *Object;
} TemplateObjectOverlay;

typedef struct {
	unsigned long	PageID;
	unsigned char	Name[0];
} NameLookupStruct;

#endif /* _MWTEMPL_H */
