/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <stdio.h>

#include <xpl.h>
#include <connio.h>

#include <logger.h>

#include <mdb.h>
#include <msgapi.h>
#include <msgaddr.h>
#include <nmap.h>
#include <rulesrv.h>
#include <xplresolve.h>

#include <modweb.h>
#include <mwtempl.h>
#include "saveform.h"
#include <ctype.h>

#define	PRODUCT_SHORT_NAME		"saveform"

extern void			*LogHandle;
extern MDBHandle	ModuleDirectoryHandle;

BOOL
ParseProxyList(MDBValueStruct *V, ProxyListStruct *ProxyList)
{
	unsigned long				i, c=0;
	unsigned char				*ptr, *ptr2;

	/* Stored as: Title Host User Password UID IMAP KeepMail */

	for (i = 0; i < min(V->Used, MAX_PROXY_ENTRIES); i++) {
		ptr=V->Value[i];
		ptr2=strchr(ptr, 13);
		if (ptr2) {
			*ptr2='\0';
		} else {
			continue;
		}

		ProxyList[c].Title=ptr;
		ptr=ptr2+1;

		ptr2=strchr(ptr, 13);
		if (ptr2) {
			*ptr2='\0';
		} else {
			continue;
		}

		ProxyList[c].Host=ptr;
		ptr=ptr2+1;

		ptr2=strchr(ptr, 13);
		if (ptr2) {
			*ptr2='\0';
		} else {
			continue;
		}

		ProxyList[c].User=ptr;
		ptr=ptr2+1;

		ptr2=strchr(ptr, 13);
		if (ptr2) {
			*ptr2='\0';
		} else {
			continue;
		}

		ProxyList[c].Password=ptr;
		ptr=ptr2+1;

		ptr2=strchr(ptr, 13);
		if (ptr2) {
			*ptr2='\0';
		} else {
			continue;
		}

		ProxyList[c].UID=ptr;
		ptr=ptr2+1;

		if (*ptr=='1') {
			ProxyList[c].IMAP=TRUE;
		} else {
			ProxyList[c].IMAP=FALSE;
		}

		ptr++;
		if (*ptr!=13) {
			continue;
		}
		ptr++;
	
		if (*ptr=='1') {
			ProxyList[c].KeepMail=TRUE;
		} else {
			ProxyList[c].KeepMail=FALSE;
		}

		ptr++;
		if (*ptr==13) {
		    ptr++;
	    
		    if (*ptr=='1') {
			    ProxyList[c].SSL=TRUE;
		    } else {
			    ProxyList[c].SSL=FALSE;
		    }
		}

		c++;
	}
	return(TRUE);
}

BOOL 
ProcessRuleListForm(struct _ConnectionStruct *Client, unsigned char *User)
{
	MDBValueStruct	*V;
	unsigned long	ValueSize;
	unsigned char	FieldName[128];
	unsigned long	c;

	V = MDBCreateValueStruct(ModuleDirectoryHandle, NULL);

	MsgGetUserFeature(User, FEATURE_RULES, MSGSRV_A_RULE, V);
	if (V->Used == 0) {
		MDBDestroyValueStruct(V);
		return(FALSE);
	}

	for (c = 0; c < V->Used; c++) {
		V->Value[c][8] = RULE_INACTIVE;
	}

	while (MWGetFormName(Client, FieldName, 128)) {
		ValueSize=BUFSIZE;
		while(MWGetFormValue(Client, Client->Temp, &ValueSize) != FORMFIELD_NEXT) { /* I don't actually need the value, but it still needs to be read from the network */
			if (isdigit(FieldName[0])) {
				c = atol(FieldName);
				if (c < V->Used) {
					V->Value[c][8] = RULE_ACTIVE;
				}
			}
			ValueSize=BUFSIZE;
		}
	}
	MDBWrite(User, MSGSRV_A_RULE, V);
	MDBDestroyValueStruct(V);	
	return(TRUE);
}


RuleRecord 
ParseRule(char *Value)
{
	int			Len;
	char			*ptr, Number[4] = "000";
	RuleRecord	NewRule = {TRUE, RULE_NONE, RULE_ACTION_NONE, NULL, NULL, -1, 0};

	enum {
		GET_ID,
		GET_ACTIVE,
		GET_COND,
		GET_COND_VAL1,
		GET_COND_VAL2,
		GET_ACT,
		GET_ACT_VAL1,
		GET_ACT_VAL2,
		GET_STOP_VALUE,
		FINISHED,
	} State;

	NewRule.Stop = FALSE;

	for (ptr = Value, State = GET_ID; State != FINISHED && *ptr != '\0'; ptr++, State++) {
		switch (State) {
			case GET_ID: {
				char LocalID[9];

				strncpy(LocalID, ptr, 8);
				LocalID[8] = '\0';
				NewRule.ID = strtol(LocalID, NULL, 16);
				ptr += 7;

				break;
			}

			case GET_ACTIVE: {
				if (*ptr == 'A') {
					NewRule.Active = TRUE;
				} else {
					NewRule.Active = FALSE;
				}
				break;
			}

			case GET_COND: {
				NewRule.Type = *ptr;
				break;
			}

			case GET_COND_VAL1:
			case GET_COND_VAL2:
			case GET_ACT_VAL1:
			case GET_ACT_VAL2: {
				strncpy(Number, ptr, 3);
				Len = atoi(Number);
				ptr += 3;
				if (Len > 0) {
					switch (State) {
						case GET_COND_VAL1: {
							NewRule.ConditionData = ptr;
							break;
						}

						case GET_ACT_VAL1: {
							NewRule.ActionData = ptr;
							break;
						}

						case GET_COND_VAL2: {
							if (NewRule.Type == RULE_COND_HEADER) {
								NewRule.ConditionData = ptr;
							}
						}
						default:
							break;
					}
				}
				ptr += Len;
				*ptr = '\0';
				break;
			}

			case GET_ACT: {
				NewRule.Action = *ptr;
				break;
			}

			case GET_STOP_VALUE: {
				if (*ptr == RULE_ACT_STOP) {
					NewRule.Stop = TRUE;
				}
				break;
			}
			default:
				break;
		}
	}
	return(NewRule);
}

BOOL
CheckRuleString(ConnectionStruct *Client, unsigned char *CurrentRule, SessionStruct *Session)
{
	unsigned char		*Rule = CurrentRule + 9;
	unsigned char		*RuleEnd = CurrentRule + strlen(CurrentRule);
	BOOL					ConditionsDone = FALSE;

	while (!ConditionsDone) {
		switch (*Rule) {
			case RULE_COND_ANY:
			case RULE_COND_FROM:
			case RULE_COND_TO:
			case RULE_COND_SUBJECT:
			case RULE_COND_PRIORITY:
			case RULE_COND_HEADER:
			case RULE_COND_BODY:
			case RULE_COND_FROM_NOT:
			case RULE_COND_TO_NOT:
			case RULE_COND_SUBJECT_NOT:
			case RULE_COND_PRIORITY_NOT:
			case RULE_COND_HEADER_NOT:
			case RULE_COND_BODY_NOT:
			case RULE_COND_SIZE_MORE:
			case RULE_COND_SIZE_LESS:
			case RULE_COND_FREE:
			case RULE_COND_FREENOT:
			case RULE_COND_HASMIMETYPE:
			case RULE_COND_HASMIMETYPENOT: {
				/* We have a valid condition */
				break;
			}
			default: {
				ConditionsDone = TRUE;
			}
		}
		RuleInc(1);

		if (!ConditionsDone) {
			/* Argument 1 */
			RuleSendArgument(FALSE);

			/* Argument 2 */
			RuleSendArgument(FALSE);

			switch (*Rule) {
				case RULE_ACT_BOOL_AND:
				case RULE_ACT_BOOL_OR:
				case RULE_ACT_BOOL_NOT: {
					/* We're still good */
					RuleInc(1);
					break;
				}
				default: {
					ConditionsDone = TRUE;
				}
			}
		}
	}

	while (Rule < RuleEnd) {
		switch (*Rule) {
			case RULE_ACT_REPLY:
			case RULE_ACT_DELETE:
			case RULE_ACT_FORWARD:
			case RULE_ACT_COPY:
			case RULE_ACT_MOVE:
			case RULE_ACT_ACCEPT:
			case RULE_ACT_DECLINE:
			case RULE_ACT_STOP: {
				break;
			}
		}
		RuleInc(1);

		/* Argument 1 */
		RuleSendArgument(FALSE);

		/* Argument 2 */
		RuleSendArgument(FALSE);
	}
	return(TRUE);
}

BOOL
SendRuleString(ConnectionStruct *Client, unsigned char *CurrentRule, SessionStruct *Session)
{
	unsigned char		*Rule = CurrentRule + 9;
	unsigned char		*RuleEnd = CurrentRule + strlen(CurrentRule);
	unsigned char		*ptr = NULL;
	BOOL					ConditionsDone = FALSE;
	BOOL					First = TRUE;
	unsigned char		ConditionChar	= '\0';

	while (!ConditionsDone) {
		ConditionChar = *Rule;

		switch (*Rule) {
			case RULE_COND_ANY:					ptr = "for all messages";							break;
			case RULE_COND_FROM:					ptr = "if from contains";							break;
			case RULE_COND_TO:					ptr = "if to contains";								break;
			case RULE_COND_SUBJECT:				ptr = "if subject contains";						break;
			case RULE_COND_PRIORITY:			ptr = "if priority contains";						break;
			case RULE_COND_HEADER:				ptr = "if header field";							break;
			case RULE_COND_BODY:					ptr = "if body contains";							break;
			case RULE_COND_FROM_NOT:			ptr = "if from doesn't contain";					break;
			case RULE_COND_TO_NOT:				ptr = "if to doesn't contain";					break;
			case RULE_COND_SUBJECT_NOT:		ptr = "if subject doesn't contain";				break;
			case RULE_COND_PRIORITY_NOT:		ptr = "if priority doesn't contain";			break;
			case RULE_COND_HEADER_NOT:			ptr = "if header field";							break;
			case RULE_COND_BODY_NOT:			ptr = "if body doesn't contain";					break;
			case RULE_COND_SIZE_MORE:			ptr = "if size is more than";						break;
			case RULE_COND_SIZE_LESS:			ptr = "if size is less than";						break;
			case RULE_COND_FREE:					ptr = "if appointment does not conflict";		break;
			case RULE_COND_FREENOT:				ptr = "if appointment does conflict";			break;
			case RULE_COND_HASMIMETYPE:		ptr = "if has attachment of type";				break;
			case RULE_COND_HASMIMETYPENOT:	ptr = "if doesn't have attachment of type";	break;

			default: {
				ptr = NULL;
				ConditionsDone = TRUE;
			}
		}

		if (ptr) {
			if (First) {
				unsigned char		FirstLetter = toupper(*ptr);
				/*
					We want the first letter to be uppercase, and its a pain
				*/

				MWSendClient(Client, &FirstLetter, 1);
				MWSendClient(Client, ptr + 1, strlen(ptr + 1));
				First = FALSE;
			} else {
				MWSendClient(Client, ptr, strlen(ptr));
			}
		}

		RuleInc(1);

		MWSendClient(Client, " ", 1);
		if (!ConditionsDone) {
			/* Argument 1 */
			RuleSendArgument(TRUE);

			switch (ConditionChar) {
				case RULE_COND_SIZE_MORE:
				case RULE_COND_SIZE_LESS:
					MWSendClient(Client, "kb ",3);
					break;
				case RULE_COND_HEADER:
					MWSendClient(Client, " contains ", strlen(" contains "));
					break;
				case RULE_COND_HEADER_NOT:
					MWSendClient(Client, " doesn't contains ", strlen(" doesn't contains "));
					break;
				default:
					break;
			}

			/* Argument 2 */
			RuleSendArgument(TRUE);

			switch (*Rule) {
				case RULE_ACT_BOOL_AND:	ptr = "and";	break;
				case RULE_ACT_BOOL_OR:	ptr = "or";		break;
				case RULE_ACT_BOOL_NOT:	ptr = "not";	break;
				default: {
					ptr = NULL;
					ConditionsDone = TRUE;
				}
			}
			if (ptr) {
				MWSendClient(Client, ptr, strlen(ptr));
				RuleInc(1);
				MWSendClient(Client, " ", 1);
			}
		}
	}

	while (Rule < RuleEnd) {
		switch (*Rule) {
			case RULE_ACT_REPLY:		ptr = "then reply with";		break;
			case RULE_ACT_DELETE:	ptr = "then delete message";	break;
			case RULE_ACT_FORWARD:	ptr = "then forward to";		break;
			case RULE_ACT_COPY:		ptr = "then carbon copy to";	break;
			case RULE_ACT_MOVE:		ptr = "then move to";			break;
			case RULE_ACT_STOP:		ptr = "stop processing";		break;
			case RULE_ACT_ACCEPT:	ptr = "then accept";				break;
			case RULE_ACT_DECLINE:	ptr = "then decline";			break;
			default: {
				ptr = NULL;
			}
		}

		if (ptr) {
			MWSendClient(Client, ptr, strlen(ptr));
		}

		RuleInc(1);
		MWSendClient(Client, " ", 1);

		/* Argument 1 */
		RuleSendArgument(TRUE);

		/* Argument 2 */
		RuleSendArgument(TRUE);

		if (Rule < RuleEnd) {
			MWSendClient(Client, "and ", 4);
		}
	}
	return(TRUE);
}


#define	MIN_VALUE_SIZE		512
#define	TIMEOUT				(2*60)

#define	d			XplConsolePrintf("[%d]\r\n", __LINE__);

BOOL 
SocketReady(int s, unsigned long Timeout)
{
#ifdef LINUX
    int ret;
    struct pollfd pfd;

    pfd.fd = s;
    pfd.events = POLLIN;
    ret = poll(&pfd, 1, Timeout * 1000);
    if ((ret > 0) && !(pfd.revents & (POLLERR | POLLHUP | POLLNVAL))) {
        return(TRUE);
    }
    return FALSE;
#else
	int                  ret;
	fd_set               readfds;
	struct timeval       timeout;

	FD_ZERO(&readfds);
	FD_SET((s), &readfds);
	timeout.tv_usec = 0;
	timeout.tv_sec = (Timeout);
	ret = select(FD_SETSIZE, &readfds, NULL, NULL, &timeout);
	if (ret < 1) {
		return(FALSE);
	}
	return(TRUE);
#endif
}

unsigned long
ProcessSaveForm(ConnectionStruct *Client, SessionStruct *Session, MDBValueStruct *Users, BOOL SetSession)
{
	MDBValueStruct		*V;
	unsigned long		ValueSize;
	unsigned char		FieldName[1024];
	unsigned long		CurrentUser;
	unsigned long		c;
	ProxyListStruct	Proxy[MAX_PROXY_ENTRIES];
	BOOL					ProxySave					= FALSE;
	unsigned char		*OldPassword				= NULL;
	unsigned char		*Password					= NULL;
	BOOL					SkipOldPassword			= FALSE;
	BOOL					PasswordsMatch				= FALSE;
	unsigned long		Error							= SAVED_SETTINGS;
	unsigned char		*Value						= NULL;
	unsigned long		ValueAllocated				= MIN_VALUE_SIZE;
	unsigned long		ValueUsed					= 0;
	unsigned	long		RetVal						= 0;

	/* Shared folder stuff */
	unsigned char		*AddShareFolder			= NULL;
	unsigned char		*AddShareUser				= NULL;
	BOOL					HaveSubscribedFolders	= FALSE;
	MDBValueStruct		*SubscribedFolders		= NULL;
	MDBValueStruct		*SubscribedCalendars		= NULL;

	MDBValueStruct		*ShareRights				= NULL;

	/* Proxy stuff	*/
	unsigned char		*AddProxyUser				= NULL;

	if (Users->Used == 0 || Session->ReadOnly) {
		unsigned long		Offset = 0;

		/* We still have to read the form */

		while (MWGetFormName(Client, FieldName, sizeof(FieldName))) {
			ValueSize = BUFSIZE - Offset;

			while (MWGetFormValue(Client, Client->Temp + Offset, &ValueSize) != FORMFIELD_NEXT) {
				ValueSize = BUFSIZE - Offset;
			}

			Offset = 0;
		}

		return(0);
	}

	Value = MemMalloc(sizeof(unsigned char)*(ValueAllocated+1));				/* One extra for terminating NULL */
	if (!Value) {
		return(0);
	}

	V = MDBCreateValueStruct(ModuleDirectoryHandle, NULL);

	memset(&Proxy, 0, sizeof(Proxy));

	while (MWGetFormName(Client, FieldName, sizeof(FieldName))) {
		unsigned long		NameLength;

		/* Start over, new form field */
		ValueUsed = 0;
		if (tolower(FieldName[0]) == 's') {
			switch (tolower(FieldName[9])) {
				case 'm'	:	{	ValueUsed = 2;	Value[0] = 'S'; Value[1] = ':';	break;	}	/* Signature */
				case 's' :	{	ValueUsed = 2;	Value[0] = 'Q'; Value[1] = ':';	break;	}	/* Secret Question */
				case 'w' :	{	ValueUsed = 2;	Value[0] = 'A'; Value[1] = ':';	break;	}	/* Secret Answer */
			}
		}

		/* Read the form value, looping and growing the buffer if neccessary */
		do {
			unsigned char		*ptr;
			unsigned char		*EndPtr;

			/* Determine how much space is in the buffer */
			ValueSize = ValueAllocated-ValueUsed;

			/* Enough for us? */
			if (ValueSize < MIN_VALUE_SIZE) {
				Value = MemRealloc(Value, ValueAllocated + MIN_VALUE_SIZE+1);		/* One extra for terminating NULL */
				if (!Value) {
					/* Suck! */

					MDBDestroyValueStruct(V);
					if (Value) {
						MemFree(Value);
					}

					return(0);
				}

				ValueAllocated += MIN_VALUE_SIZE;
				ValueSize = ValueAllocated - ValueUsed;
			}

			/* Read the data from the form */
			ptr = Value + ValueUsed;
			RetVal = MWGetFormValue(Client, ptr, &ValueSize);
			ValueUsed += ValueSize;
			EndPtr = ptr + ValueSize;

			/* Check for garbage data */
			while (ptr < EndPtr) {
				if ((*ptr < 20) && (!isspace(*ptr))) {
					MDBDestroyValueStruct(V);
					if (Value) {
						MemFree(Value);
					}
					return(GARBAGE_DATA);
				}
				ptr++;
			}

			/* Make sure we don't get more than we allow */
			if (ValueUsed > MDB_MAX_ATTRIBUTE_VALUE_CHARS) {
				ValueUsed = 0;
			}
		} while (RetVal == FORMFIELD_PARTIAL);

		Value[ValueUsed] = '\0';

//XplConsolePrintf("[%s] %s\r\n", FieldName, Value);

		NameLength = strlen(FieldName);
		switch(tolower(FieldName[0])) {
			case 'a' :	{
				if (NameLength > 9) {
					switch(tolower(FieldName[9])) {
						case 'e' :	{	/* AutoReplyEnabled */
							MDBFreeValues(V);
							if (Value[0] == 'O' && Value[1] == 'N') {
								MDBAddValue("1", V);
							} else {
								MDBAddValue("0", V);
							}
							
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_AUTOREPLY_ENABLED, V);
							}
							MDBFreeValues(V);
							break;
						}
						case 'm' :	{	/* AutoReplyMessage */
							MDBFreeValues(V);
							MDBAddValue(Value, V);
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_AUTOREPLY_MESSAGE, V);
							}
							MDBFreeValues(V);
							break;
						}
						case 's' :	{	/* AddShareUser */
							if (strlen(Value) > 0) {
								switch(tolower(FieldName[3])) {
									case 's': {	/* AddShareUser */
										AddShareUser = MemStrdup(Value);
										break;
									}
									case 'p': {	/* AddProxyUser */
										AddProxyUser = MemStrdup(Value);
										break;
									}
								}
							}
							break;
						}
						case 'o' :	{	/* AddShareFolder */
							AddShareFolder = MemStrdup(Value);
							break;
						}
					}
				}
				break;
			}
			case 'c' :	{
				if (NameLength > 1) {
					switch(tolower(FieldName[1])) {
						case 'h' :	{	/* Charset */
							if (*Value != '\0') { /* Don't Set */
								MDBAddValue(Value, V);
								for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
									MDBWrite(Users->Value[CurrentUser], MSGSRV_A_DEFAULT_CHARSET, V);
								}
								MDBFreeValues(V);
								if (SetSession) {
									if (Session->Charset) {
										MemFree(Session->Charset);
									}
									Session->Charset = MemStrdup(Value);
								}
							}
							break;
						}
						case 'o' :	{	/* Color */
							if (Users->Used > 1) {
								break;  
							}

							if (NameLength > 7) {
								switch(tolower(FieldName[7])) {
									case 'd' :	{	/* Body */
										if (NameLength > 9 && tolower(FieldName[9]) == 'b') {
											strncpy(Session->Colors[COLOR_FIELDBODY_BG], Value, 6);
										} else {
											strncpy(Session->Colors[COLOR_FIELDBODY_FG], Value, 6);
										}
										break;
									}
									case 'r' :	{	/* Border */
										if (NameLength > 11 && tolower(FieldName[11]) == 'b') {
											strncpy(Session->Colors[COLOR_BORDER_BG], Value, 6);
										} else {
											strncpy(Session->Colors[COLOR_BORDER_FG], Value, 6);
										}
										break;
									}
									case 'm' :	{	/* Name */
										if (NameLength > 9 && tolower(FieldName[9]) == 'b') {
											strncpy(Session->Colors[COLOR_FIELDNAME_BG], Value, 6);
										} else {
											strncpy(Session->Colors[COLOR_FIELDNAME_FG], Value, 6);
										}
										break;
									}
									case 'g' :	{	/* Page */
										if (NameLength > 9 && tolower(FieldName[9]) == 'b') {
											strncpy(Session->Colors[COLOR_PAGE_BG], Value, 6);
										} else {
											strncpy(Session->Colors[COLOR_PAGE_FG], Value, 6);
										}
										break;
									}
									case 'c' :	{	/* Section */
										if (NameLength > 12 && tolower(FieldName[12]) == 'b') {
											strncpy(Session->Colors[COLOR_SECTION_BG], Value, 6);
										} else {
											strncpy(Session->Colors[COLOR_SECTION_FG], Value, 6);
										}
										break;
									}
								}
							}

							sprintf(Value, "Page: %s %s", Session->Colors[COLOR_PAGE_FG], Session->Colors[COLOR_PAGE_BG]);
							MDBAddValue(Value, V);

							sprintf(Value, "Border: %s %s", Session->Colors[COLOR_BORDER_FG], Session->Colors[COLOR_BORDER_BG]);
							MDBAddValue(Value, V);

							sprintf(Value, "Section: %s %s", Session->Colors[COLOR_SECTION_FG], Session->Colors[COLOR_SECTION_BG]);
							MDBAddValue(Value, V);

							sprintf(Value, "Fieldname: %s %s", Session->Colors[COLOR_FIELDNAME_FG], Session->Colors[COLOR_FIELDNAME_BG]);
							MDBAddValue(Value, V);

							sprintf(Value, "Fieldbody: %s %s", Session->Colors[COLOR_FIELDBODY_FG], Session->Colors[COLOR_FIELDBODY_BG]);
							MDBAddValue(Value, V);

							MDBWrite(Users->Value[0], MSGSRV_A_COLOR, V);
							MDBFreeValues(V);

							break;
						}
					}
				}
				break;
			}
			case 'd' :	{
				if (NameLength > 10) {	/* DateFormatLong && DateFormatShort */
					unsigned char		Buff[BUFSIZE];

					if (Value[0] == '\0') {
						break;
					}

					for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
						if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_LOCALE, V)) {
							for (c = 0; c < V->Used; c++) {
								if (MWQuickNCmp(V->Value[c], (tolower(FieldName[10]) == 'l') ? "DL:" : "DS:", 3)) {
									MDBFreeValue(c, V);
									c = 0;
								}
							}
						}
						if (SetSession) {
							if (tolower(FieldName[10]) == 'l') {
								if (Session->DateFormatLong) {
									MemFree(Session->DateFormatLong);
								}
								Session->DateFormatLong = MemStrdup(Value);
							} else {
								if (Session->DateFormatShort) {
									MemFree(Session->DateFormatShort);
								}
								Session->DateFormatShort = MemStrdup(Value);
							}
						}
						sprintf(Buff, (tolower(FieldName[10]) == 'l') ? "DL:%s" : "DS:%s", Value);
						MDBAddValue(Buff, V);
						MDBWrite(Users->Value[CurrentUser], MSGSRV_A_LOCALE, V);
						MDBFreeValues(V);
					}
				}
				break;
			}
			case 'f' :	{
				if (NameLength > 3) {
					switch(tolower(FieldName[3])) {
						case 's' :	{	/* FirstDayOfWeek */
							unsigned char		Buff[BUFSIZE];

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_LOCALE, V)) {
									for (c = 0; c < V->Used; c++) {
										if (MWQuickNCmp(V->Value[c], "WDS:", 4)) {
											MDBFreeValue(c, V);
										}
									}
								}
								if (SetSession) {
									Session->StartWeekday = atol(Value);
									Session->DateFormat.wDayStart=Session->StartWeekday;
								}
								sprintf(Buff, "WDS:%s", Value);
								MDBAddValue(Buff, V);
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_LOCALE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'd' :	{	/* FolderSent * FolderDefault * FolderDrafts */
							if (NameLength > 8) {
								unsigned char		*ptr;
								unsigned char		Buff[BUFSIZE+1];
								unsigned long		Len;

								if (Users->Used != 1) {
									break;
								}

								if (FieldName[8] == 'f') {
									ptr = "Webmail:AutoFolderName:";
									Len = 23;
								} else if (FieldName[8] == 'n') {
									ptr = "Webmail:SentFolderName:";
									Len = 23;
								} else {
									ptr = "Webmail:DraftFolderName:";
									Len = 24;
								}

								for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
									if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_PREFERENCES, V)) {
										for (c = 0; c < V->Used; c++) {
											if (MWQuickNCmp(V->Value[c], ptr, Len)) {
												MDBFreeValue(c, V);
											}
										}
									}

									for (c = 0; c < Session->FolderList->Used; c++) {
										unsigned char		*Folder = Session->FolderList->Value[c];

										if (*Folder == 'M' && MWQuickCmp(Value, Folder + 3)) {

											sprintf(Buff, "%s%s", ptr, Folder + 3);
											MDBAddValue(Buff, V);
										}
									}
									MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PREFERENCES, V);
									MDBFreeValues(V);
								}
							}
							break;
						}
						case 'w' :	{
							if (NameLength > 7) {
								switch(tolower(FieldName[7])) {
									case 'a' : {	/* ForwardAddress */
										unsigned char		*ptr, *ptr2;

										MDBFreeValues(V);
										ptr = Value;
										
										while (ptr) {
											ptr2 = strchr(ptr, '\r');
											if (!ptr2) {
												ptr2 = strchr(ptr, '\n');
											}
											if (!ptr2) {
												if (MsgIsAddress(ptr, strlen(ptr), "", NULL)) {
													MDBAddValue(ptr, V);
												} else {
													Error = ILLEGAL_USER_NAME;			/* (Bug Alert - This needs a better error) */
												}
												ptr = NULL;
											} else {
												*ptr2 = '\0';
												if (MsgIsAddress(ptr, ptr2 - ptr, "", NULL)) {
													MDBAddValue(ptr, V);
												} else {
													Error = ILLEGAL_USER_NAME;			/* (Bug Alert - This needs a better error) */
												}
												ptr = ptr2 + 1;
												if (*ptr == '\n') {
													ptr++;
												}
												if (*ptr == '\0') {
													ptr = NULL;
												}
											}
										}

										for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
											MDBWrite(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ADDRESS, V);
										}
										MDBFreeValues(V);
										break;
									}
									case 'e' : {	/* ForwardEnabled */
										if (*Value != '\0') { /* Don't Set */
											if (Value[0] == 'O' && Value[1] == 'N') {
												for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
													if (MDBRead(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ENABLED, V)) {
														if (V->Value[0][0] == '2') {
															MDBFreeValues(V);
															MDBAddValue("2", V);
														} else {
															MDBFreeValues(V);
															MDBAddValue("1", V);
														}
													} else {
														MDBAddValue("1", V);
													}
													MDBWrite(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ENABLED, V);
													MDBFreeValues(V);
												}
											} else {
												for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
													MDBAddValue("0", V);
													MDBWrite(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ENABLED, V);
													MDBFreeValues(V);
												}
											}
										}
										break;
									}
									case 'k' : {	/* ForwardKeepCopy */
										if (*Value != '\0') { /* Don't Set */
											for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
												if (MDBRead(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ENABLED, V)) {
													if (V->Value[0][0] != '0') {
														MDBFreeValues(V);
														if (Value[0] == 'O' && Value[1] == 'N') {
															MDBAddValue("2", V);
														} else {
															MDBAddValue("1", V);
														}
													}
												}
												MDBWrite(Users->Value[CurrentUser], MSGSRV_A_FORWARDING_ENABLED, V);
												MDBFreeValues(V);
											}
										}
										break;
									}
								}
							}
							break;
						}
					}
				}
				break;
			}
			case 'l' :	{
				if (NameLength > 1) {
					switch(tolower(FieldName[1])) {
						case 'a' : {	/* Language */
							if (*Value != '\0') { /* Don't Set */	
								MDBAddValue(Value, V);
								for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
									MDBWrite(Users->Value[CurrentUser], MSGSRV_A_LANGUAGE, V);
								}
								if (SetSession) {
									MWSetSessionTemplate(Session->TemplateID, atol(Value), Session);
								}
								MDBFreeValues(V);
							}
							break;
						}
						case 'd' : {	/* LDAPServer */
							MDBAddValue(Value, V);
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_ADDRESSBOOK_URL_PUBLIC, V);
							}
							MDBFreeValues(V);

							break;
						}
					}
				}
				break;
			}
			case 'm' :	{	/* MessagesPerPage */
				unsigned char		Buff[BUFSIZE];

				if (*Value != '\0') { /* Don't Set */
					for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
						if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_PREFERENCES, V)) {
							for (c = 0; c < V->Used; c++) {
								if (MWQuickNCmp(V->Value[c], "ModWeb:MsgPerPage=", 18)) {
									MDBFreeValue(c, V);
								}
							}
						}
						sprintf(Buff, "ModWeb:MsgPerPage=%d", (int)atol(Value));
						MDBAddValue(Buff, V);

						MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PREFERENCES, V);
						MDBFreeValues(V);
						if (SetSession) {
							Session->MessagesPerPage = atol(Value);
						}
					}
				}
				break;
			}
			case 'p' :	{
				if (NameLength > 2) {
					switch(tolower(FieldName[2])) {
						case 's' : {
							if (NameLength > 8) {
								switch(tolower(FieldName[8])) {
									case 'o' :	{	/* PasswordOld */
										if ((*Value == '\r') || (*Value == '\n')) {
											break;
										}
										ModDebug("Entered Old Pass\n");
										if (!OldPassword) {
											OldPassword = MemStrdup(Value);
										}

										break;
									}
									case 's' :	{	/* PasswordSkipOld */
										if (OldPassword) {
											MemFree(OldPassword);
										}
										SkipOldPassword = TRUE;
										/* no break */
									}
									case 'n' :		/* PasswordNew */
									case 'r' :	{	/* PasswordRepeat */
										if ((*Value == '\0') || (*Value == '\r') || (*Value == '\n')) {
											break;
										}
										ModDebug("Entered New Pass\n");
										if (!Password) {
											Password = MemStrdup(Value);
										} else if (MWQuickCmp(Password, Value)) {
											PasswordsMatch=TRUE;
										}
										break;
									}
								}
							}
							break;
						}
						case 'i' : {	/* Privacy */
							if (*Value != '\0') { /* Don't Set */
								switch (tolower(*Value)) {
									case 'l' : { /* Limited */
										MDBAddValue("1", V);
										break;
									}

									case 'u' : { /* Unlisted */
										MDBAddValue("2", V);
										break;
									}

									default:
									case 'n' : { /* None */
										MDBAddValue("0", V);
										break;
									}
								}

								for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
									MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PRIVACY, V);
								}
								MDBFreeValues(V);
							}
							break;
						}
						case 'o' : {	/* Proxy */
							c = (FieldName[5]) - '0';
							if (c > MAX_PROXY_ENTRIES || Users->Used > 1) {
								break;
							}
							ProxySave = TRUE;

							if (NameLength > 6) {
								switch(tolower(FieldName[6])) {
									case 'h' : {	/* hostname */
										if (Value[0] != '\0') {
											Proxy[c].Host = MemStrdup(Value);
										}
										break;
									}
									case 'l' :	{	/* leave */
										Proxy[c].KeepMail = TRUE; /* Its a checkbox so if I get any answer back it must be true */
										break;
									}
									case 'p' :	{	/* Password */
										if (Value[0] != '\0') {
											if (Proxy[c].GotPassword2) {
												if (strcmp(Proxy[c].Password, Value)!=0) {
													Error=WRONG_PASSWORD;
													MemFree(Proxy[c].Password);
													Proxy[c].Password = NULL;
												}
											} else {
												Proxy[c].Password = MemStrdup(Value);
												Proxy[c].GotPassword1=TRUE;
											}
										}
										break;
									}
									case 'r' :	{	/* RepeatPassword */
										if (Value[0] != '\0') {
											if (Proxy[c].GotPassword1) {
												if (strcmp(Proxy[c].Password, Value)!=0) {
													Error=WRONG_PASSWORD;
													MemFree(Proxy[c].Password);
													Proxy[c].Password = NULL;
												}
											} else {
												Proxy[c].Password = MemStrdup(Value);
												Proxy[c].GotPassword2=TRUE;
											}
										}
										break;
									}
                                    case 's': { /* SSL */
                                        Proxy[c].SSL = TRUE;
                                        break;
                                    }
									case 't' :	{	/* Type */
										if (Value[0] == 'I') {
											Proxy[c].IMAP = TRUE;
										}
										break;
									}
									case 'u' :	{	/* Username */
										if (Value[0] != '\0') {
											Proxy[c].User = MemStrdup(Value);
										}
										break;
									}
									case 'i' :	{	/* ID */
										Proxy[c].UID = MemStrdup(Value); /* Its a checkbox so if I get any answer back it must be true */
										break;
									}
								}
							}
							break;
						}
						case 'r' : {	/* Purge */
							unsigned char		Buff[BUFSIZE];
							BOOL					Checked;
							BOOL					Set = FALSE;
							unsigned long		WebmailOptions;

							if (Value[0] == '\0') { /* Don't Set */
								break;
							} else if (Value[0] == 'O' && Value[1] == 'N') {
								Checked = TRUE;
							} else {
								Checked = FALSE;
							}

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_PREFERENCES, V)) {
									for (c = 0; c < V->Used; c++) {
										if (MWQuickNCmp(V->Value[c], "Webmail:Options:", 16)) {
											WebmailOptions = atoi(V->Value[c] + 16);
											WebmailOptions &= ~(1 << PREFS_PURGE_SHIFT);
											WebmailOptions |= (Checked << PREFS_PURGE_SHIFT);
											sprintf(Buff, "Webmail:Options:%d", (int)WebmailOptions);
											MDBFreeValue(c, V);
											MDBAddValue(Buff, V);
											Set = TRUE;
											break;
										}
									}
								}
								if (!Set) {
									sprintf(Buff, "Webmail:Options:%d", (Checked << PREFS_PURGE_SHIFT));
									MDBAddValue(Buff, V);
								}

								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PREFERENCES, V);
								MDBFreeValues(V);
							}
							break;
						}
					}
				}

				break;
			}
			case 'r' :	{	/* ReplyTo */
				if (MsgIsAddress(Value, strlen(Value), "", NULL)) {
					MDBAddValue(Value, V);
				} else {
					Error = ILLEGAL_USER_NAME;			/* (Bug Alert - This needs a better error) */
				}
				for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
					MDBWrite(Users->Value[CurrentUser], MSGSRV_A_EMAIL_ADDRESS, V);
				}
				MDBFreeValues(V);

				break;
			}
			case 's' :	{
				if (NameLength > 9) {
					switch(tolower(FieldName[9])) {
						case 's' : {	/* SecretQuestion */
							if (Value[2] == '\0') {
								break;
							}

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBRead(Users->Value[CurrentUser], MSGSRV_A_PHRASE, V);

								for (c = 0; c < V->Used; c++) {
									if (V->Value[c][0] == 'Q' && V->Value[c][1] == ':') {
										LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_SECRET_CHANGE, LOG_ERROR, 0, Users->Value[CurrentUser], V->Value[c]+2, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
										MDBFreeValue(c, V);
									}
								}
								MDBAddValue(Value, V);
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PHRASE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'w' : {	/* SecretAnswer */
							if (Value[2] == '\0') {
								break;
							}

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBRead(Users->Value[CurrentUser], MSGSRV_A_PHRASE, V);

								for (c = 0; c < V->Used; c++) {
									if (V->Value[c][0] == 'A' && V->Value[c][1] == ':') {
										MDBFreeValue(c, V);
									}
								}
								MDBAddValue(Value, V);
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_PHRASE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'e' : {	/* SignatureEnabled */
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								if (MDBRead(Users->Value[CurrentUser], MSGSRV_A_SIGNATURE, V)) {
									for (c = 0; c < V->Used; c++) {
										if (V->Value[c][0] == 'E' && V->Value[c][1] == ':') {
											MDBFreeValue(c, V);
										}
									}
								}
								if (Value[0] == 'O' && Value[1] == 'N') {
									MDBAddValue("E:True", V);
								} else {
									MDBAddValue("E:False", V);
								}
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_SIGNATURE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'm' : {	/* SignatureMessage */
							BOOL					Enabled = FALSE;

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBRead(Users->Value[CurrentUser], MSGSRV_A_SIGNATURE, V);

								for (c = 0; c < V->Used; c++) {
									if (V->Value[c][0] == 'E' && V->Value[c][1] == ':' && V->Value[c][2] == 'T') {
										Enabled = TRUE;
									}
								}
								MDBFreeValues(V);
								if (Enabled) {
									MDBAddValue("E:True", V);
								} else {
									MDBAddValue("E:False", V);
								}
								MDBAddValue(Value, V);
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_SIGNATURE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'f' : {	/* SubscribeFolder */
							if (SubscribedFolders == NULL) {
								SubscribedFolders = MDBShareContext(V);
							}

							MDBAddValue(Value, SubscribedFolders);
							break;
						}
						case 'c' : {	/* SubscribeCalendar */
							if (SubscribedCalendars == NULL) {
								SubscribedCalendars = MDBShareContext(V);
							}

							MDBAddValue(Value, SubscribedCalendars);
							break;
						}
						case 'l' : {	/* SubscribeList */
							HaveSubscribedFolders = TRUE;
							break;
						}
						case 't' : {	/* ShareRights */
							unsigned char		*ptr;
							unsigned long		i;
							unsigned char		Buffer[BUFSIZE+1];

							if (ShareRights == FALSE) {

								/*
									Its our first time through, so we read our shares, and keep
									them around until we are done with the form.  For each share
									we find we update the rights in the value struct.
								*/
								ShareRights = MDBShareContext(V);

								MWSendNMAPServer(Session, "SHARE MBOX\r\n", 12);
								if (MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE) != 2002) {
									/* We got crap from NMAP.  Oops */
									break;
								}

								*Buffer = 'M';
								while (MWGetNMAPAnswer(Session, Buffer + 1, BUFSIZE, TRUE) != 1000) {
									ptr = strrchr(Buffer, ' ');
									if (ptr) {
										*(++ptr) = '1';
										*(++ptr) = '\0';
									}

									MDBAddValue(Buffer, ShareRights);
								}

								MWSendNMAPServer(Session, "SHARE CAL\r\n", 11);
								if (MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE) != 2002) {
									/* We got crap from NMAP.  Oops */
									break;
								}

								*Buffer = 'C';
								while (MWGetNMAPAnswer(Session, Buffer + 1, BUFSIZE, TRUE) != 1000) {
									ptr = strrchr(Buffer, ' ');
									if (ptr) {
										*(++ptr) = '1';
										*(++ptr) = '\0';
									}

									MDBAddValue(Buffer, ShareRights);
								}
							}

							/* Set the rights flag - We don't care about the value here.  We just care that we got here because its check boxes */
							ptr = strrchr(FieldName, ' ');
							if (ptr) {
								unsigned char		*name = FieldName + 12;
								unsigned long		newRights;
								unsigned long		oldRights;

								*(ptr++) = '\0';
								newRights = atol(ptr);

								/* Find the matching share */

								for (i = 0; i < ShareRights->Used; i++) {
									if (MWQuickNCmp(ShareRights->Value[i], name, strlen(name))) {
										oldRights = atol(ShareRights->Value[i] + strlen(name) + 1);

										MDBFreeValue(i, ShareRights);
										sprintf(Buffer, "%s %lu", name, newRights | oldRights);
										MDBAddValue(Buffer, ShareRights);

										continue;
									}
								}
							}

							break;
						}
					}
				}
				break;
			}
			case 't' :	{
				if (NameLength > 4) {
					switch(tolower(FieldName[4])) {
						case 'l' :	{	/* Template */
							long					UserTemplate = -1;
							unsigned char		*ptr;
							MDBValueStruct		*Config;

							Config = MDBCreateValueStruct(ModuleDirectoryHandle, NULL);
							/* Figure out which templates can be saved */
							if (MDBReadDN(Session->UserDN, MSGSRV_A_PARENT_OBJECT, Config)) {
								MDBReadDN(Config->Value[0], MSGSRV_A_TEMPLATE, V);
							}

							if (V->Used == 0) {  /* We didn't get anything from the parent object so we take them all */
								MDBFreeValues(V);
								MDBSetValueStructContext(MsgGetServerDN(NULL), V);
								MDBReadDN(MSGSRV_AGENT_MODWEB, MSGSRV_A_TEMPLATE, V);
								MDBSetValueStructContext(NULL, V);
							}
							MDBFreeValues(Config);

							/* Now we have the list stored in V */
							UserTemplate = MWFindTemplate(Value);
							for (c = 0; c < V->Used; c++) {
								ptr = strrchr(V->Value[c], '\\');
								if (ptr) {
									ptr++;
								} else {
									ptr = V->Value[c];
								}
								if (UserTemplate == MWFindTemplate(ptr)) {
									/* We have a winner */
									MDBAddValue(V->Value[c], Config);
									for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
										MDBWrite(Users->Value[CurrentUser], MSGSRV_A_TEMPLATE, Config);
									}
									continue;
								}
							}

							MDBFreeValues(V);
							MDBDestroyValueStruct(Config);			
							break;
						}
						case 'o' :	{	/* Timeout */
							c = atol(Value);

							if (c == 0) {
								c = 30;
							}
							sprintf(Value, "%d", (int)c);
							MDBAddValue(Value, V);
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_TIMEOUT, V);
							}
							MDBFreeValues(V);
							break;
						}
						case 'f' : {	/* TimeFormat */
							unsigned char		Buff[BUFSIZE];

							if (Value[0] == '\0') {
								break;
							}

							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								if (MsgGetUserFeature(Users->Value[CurrentUser], FEATURE_MODWEB, MSGSRV_A_LOCALE, V)) {
									for (c = 0; c < V->Used; c++) {
										if (MWQuickNCmp(V->Value[c], "T:", 2)) {
											MDBFreeValue(c, V);
											c = 0;
										}
									}
								}
								if (SetSession) {
									if (Session->TimeFormat) {
										MemFree(Session->TimeFormat);
									}
									Session->TimeFormat = MemStrdup(Value);
								}
								sprintf(Buff, "T:%s", Value);
								MDBAddValue(Buff, V);
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_LOCALE, V);
								MDBFreeValues(V);
							}
							break;
						}
						case 'z' : {	/* TimeZone */
							MDBAddValue(Value, V);
							for (CurrentUser = 0; CurrentUser < Users->Used; CurrentUser++) {
								MDBWrite(Users->Value[CurrentUser], MSGSRV_A_TIMEZONE, V);
							}
							if (SetSession) {
								Session->TimezoneID=atol(V->Value[0]);
								Session->TimezoneOffset = MsgGetUTCOffsetByDate(Session->TimezoneID, 0, 0, 0, 0);
								Session->DateFormat.timezoneOffset=Session->TimezoneOffset;
							}
							MDBFreeValues(V);
							break;
						}
					}
				}
				break;
			}
		}
	}

	if (Value) {
		MemFree(Value);
		Value = NULL;
	}

	/* Subscribe and unsubscribe folders */
	if (HaveSubscribedFolders ) {
		unsigned char		Buffer[BUFSIZE+1];
		unsigned long		i;
		BOOL FolderReset = FALSE;
		BOOL CalendarReset = FALSE;


		/* Set the current calendar to MAIN and the current folder to inbox. They can't be deleted */
		/* And NMAP calls to set them should not fail. */
		/* Set INBOX */

		/* Signal modwebd upper layer that folder list should be updated */
		Session->FolderListIsDirty = TRUE;

		/* Unsubscribe and subscribe folders based on list of subscribed checked folders */
		for (i = 0; i < Session->FolderList->Used; i++) {
			unsigned char		*Folder = Session->FolderList->Value[i];
			int j = 0;

			if (Folder[0] == 'M') { 
				if (Folder[2] == '0') {
					/* Folder is unsubscribed. Was check box set to subscribe ? */
					if (SubscribedFolders) {
						for (j=0; j < SubscribedFolders->Used; j++) {
							if (MWQuickCmp(&Folder[3], SubscribedFolders->Value[j]) == TRUE) {

								if ((FolderReset == FALSE) && (Session->CurrentFolder == i)) {
									/* We are subscribing the current folder */
									/* we can not have it selected */
									FolderReset = TRUE;
									MWSendNMAPServer(Session,"RSET MBOX\r\n",11);
									MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
								}

								Folder[2] = '1';
								MWSendNMAPServer(Session, "SUBS ", 5);		/* No CRLF */						
								MWSendNMAPServer(Session, Folder + 3, strlen(Folder + 3));
								MWSendNMAPServer(Session, "\r\n", 2);
								MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
								break;
							}
						}
					}
				}
				else if (Folder[2] == '1') {
					/* Folder is subscribed. Was check box unselected ? */
					if (SubscribedFolders) {
						for (j=0; j < SubscribedFolders->Used; j++) {
							if (MWQuickCmp(&Folder[3], SubscribedFolders->Value[j]) == TRUE) {
								break;
							}
						}
					}

					if (!SubscribedFolders || j == SubscribedFolders->Used) {

						if ((FolderReset == FALSE) && (Session->CurrentFolder == i)) {
							/* We are unsubscribing the current folder */
							/* we can not have it selected */
							FolderReset = TRUE;
							MWSendNMAPServer(Session,"RSET MBOX\r\n",11);
							MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
						}

						/* Folder was not in Subscribed List, implies we need to unsubscribe it */
						Folder[2] = '0';
						MWSendNMAPServer(Session, "UNSUBS ", 7);		/* No CRLF */						
						MWSendNMAPServer(Session, Folder + 3, strlen(Folder + 3));
						MWSendNMAPServer(Session, "\r\n", 2);
						MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
					}
				}
			}
			else if (Folder[0] == 'C') {
				if (Folder[2] == '0') {

					/* Calendar is unsubscribed. Was check box set to subscribe ? */
					if (SubscribedCalendars) {
						for (j=0; j < SubscribedCalendars->Used; j++) {
							if (MWQuickCmp(&Folder[3], SubscribedCalendars->Value[j]) == TRUE) {
								if ((CalendarReset == FALSE) && (Session->CurrentCalendar == i)) {
									/* We are subscribing the current calendar */
									/* we can not have it selected */
									CalendarReset = TRUE;
									MWSendNMAPServer(Session,"RSET CAL\r\n",10);
									MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
								}

								Folder[2] = '1';
								MWSendNMAPServer(Session, "CSSUBS ", 7);		/* No CRLF */						
								MWSendNMAPServer(Session, Folder + 3, strlen(Folder + 3));
								MWSendNMAPServer(Session, "\r\n", 2);
								MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
								break;
							}
						}
					}
				}
				else if (Folder[2] == '1') {
					/* Calendar is subscribed. Was check box unselected ? */
					if (SubscribedCalendars) {
						for (j=0; j < SubscribedCalendars->Used; j++) {
							if (MWQuickCmp(&Folder[3], SubscribedCalendars->Value[j]) == TRUE) {
								break;
							}
						}
					}

					if (!SubscribedCalendars || j == SubscribedCalendars->Used) {
						if ((CalendarReset == FALSE) && (Session->CurrentCalendar == i)) {
							/* We are unsubscribing the current calendar */
							/* we can not have it selected */
							CalendarReset = TRUE;
							MWSendNMAPServer(Session,"RSET CAL\r\n",10);
							MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
						}

						/* Folder was not in Subscribed List, implies we need to unsubscribe it */
						Folder[2] = '0';
						MWSendNMAPServer(Session, "CSUNSUBS ", 9);		/* No CRLF */						
						MWSendNMAPServer(Session, Folder + 3, strlen(Folder + 3));
						MWSendNMAPServer(Session, "\r\n", 2);
						MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
					}
				}
			}
		}


		/* restore back to correct folder here */
		if (FolderReset == TRUE) {
			int retCode;
			
			/*  See if we can restore to old folder otherwise set to INBOX */
			if (Session->FolderList->Value[Session->CurrentFolder][2] == '1') {
				retCode = sprintf(Buffer, "MBOX %s\r\n", Session->FolderList->Value[Session->CurrentFolder] + 3);
				MWSendNMAPServer(Session, Buffer, retCode);
				MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
			}
			else {
				MWSendNMAPServer(Session, "MBOX INBOX\r\n", 12);
				MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
			}
				
		}

		if (CalendarReset == TRUE) {
			int retCode;

			/*  See if we can restore to old calendar otherwise set to MAIN */
			if (Session->FolderList->Value[Session->CurrentCalendar][2] == '1') {
				retCode = sprintf(Buffer,"CAL %s\r\n", Session->FolderList->Value[Session->CurrentCalendar] + 3);
				MWSendNMAPServer(Session, Buffer, retCode);
				MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
			} else {
				MWSendNMAPServer(Session, "CAL MAIN\r\n", 10);
				MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), FALSE);
			}
		}

	}

	if (SubscribedFolders) {
		MDBDestroyValueStruct(SubscribedFolders);
	}

	if (SubscribedCalendars) {
		MDBDestroyValueStruct(SubscribedCalendars);
	}

	/* Add shares, Use MsgIsAddress to validate user name syntax */
	if (AddShareUser && MsgIsAddress(AddShareUser,strlen(AddShareUser), ",; ", NULL) && AddShareFolder) {
		unsigned char		Buffer[BUFSIZE+1];
		unsigned char		*Begin = AddShareUser;
		unsigned char		*End;


		/*
			AddShareUser can contain a comma seperated list of users, so we
			need to seperate them out.
		*/

		while (Begin) {

		  End = Begin;

		  while (TRUE) {
		    if (*End != '\0' && *End != ',' && *End != ';' && *End != ' ') {
		      End++;
		      continue;
		    }

		    if (*End == '\0') {
		      End = NULL; 
		    }

		    break;
		  }

		  
			if (toupper(*AddShareFolder) == 'M') {
				MWSendNMAPServer(Session, "SHARE MBOX ", 11);		/* No CRLF */
			} else if (toupper(*AddShareFolder) == 'C') {
				MWSendNMAPServer(Session, "SHARE CAL ", 10);			/* No CRLF */
			}
			MWSendNMAPServer(Session, AddShareFolder + 1, strlen(AddShareFolder + 1));

			MWSendNMAPServer(Session, " ", 1);
			if (End) {
				MWSendNMAPServer(Session, Begin, (End - Begin));
			} else {
				MWSendNMAPServer(Session, Begin, strlen(Begin));
			}

			/* Set the default rights to VISIBLE, SEEN, and READ */
			MWSendNMAPServer(Session, " 7\r\n", 4);
			RetVal = MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);

			switch(RetVal) {
				case 1000: /* OK */
					break;
				case 3010: /* Bad Arg */
					Error = GARBAGE_DATA;
					break;

				case 3014: /* Req not Allowed - Cannot share with self */
					Error = ILLEGAL_USER_NAME;
					break;

				case 4224: /* No MBOX or no User */
					Error = INVALID_USER;
					break;

				case 5001: /* No memory */
					Error = TOO_MANY_USERS;
					break;
				case 5004: /* Internal Error */
					Error = NETWORK_ERROR;
					break;
				case 5221: /* Space Low */
					Error = TOO_MANY_USERS;
					break;
				default:
					Error = NETWORK_ERROR;
					break;
			}

			Begin = End;

			if (Begin) {
				while (*Begin == ' ' || *Begin == ',' || *Begin == ';') {
					Begin++;
				}
			}
		}
	} else if (AddShareFolder) {
		/* set up error for blank user */
		Error = ILLEGAL_USER_NAME;
	}



	if (ShareRights) {
		unsigned char		Buffer[BUFSIZE+1];
		unsigned long		i;

		/* Walk through and re-assign all the rights */
		for (i = 0; i < ShareRights->Used; i++) {
			unsigned char		*value = ShareRights->Value[i];

			if (*value == 'M') {
				MWSendNMAPServer(Session, "SHARE MBOX ", 11);
			} else if (*value == 'C') {
				MWSendNMAPServer(Session, "SHARE CAL ", 10);
			} else {
				break;
			}

			MWSendNMAPServer(Session, value + 1, strlen(value) - 1);
			MWSendNMAPServer(Session, "\r\n", 2);
			RetVal = MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);
			switch(RetVal) {
				case 1000: /* OK */
					break;

				case 3010: /* Bad Arg */
					Error = GARBAGE_DATA;
					break;

				case 3014: /* Req not Allowed - Cannot share with self */
					Error = ILLEGAL_USER_NAME;
					break;

				case 4224: /* No MBOX or no User */
					Error = INVALID_USER;
					break;

				case 5004: /* Internal Error */
					Error = NETWORK_ERROR;
					break;

				default:
					Error = NETWORK_ERROR;
					break;
			}


		}

		MDBDestroyValueStruct(ShareRights);
	}

	if (AddProxyUser) {
		unsigned char		Buffer[BUFSIZE+1];
		unsigned char		*Begin = AddProxyUser;
		unsigned char		*End;

		/*
			AddProxyUser can contain a comma seperated list of users, so we
			need to seperate them out.
		*/

		while (Begin) {
			End = strchr(Begin, ',');

			MWSendNMAPServer(Session, "PROXY ", 6);
			if (End) {
				MWSendNMAPServer(Session, Begin, (End - Begin));
			} else {
				MWSendNMAPServer(Session, Begin, strlen(Begin));
			}
			MWSendNMAPServer(Session, " 1\r\n", 4);
			MWGetNMAPAnswer(Session, Buffer, sizeof(Buffer), TRUE);

			Begin = End;

			if (Begin) {
				while (*Begin == ' ' || *Begin == ',') {
					Begin++;
				}
			}
		}

		MemFree(AddProxyUser);
		AddProxyUser = NULL;
	}

	/* Set password */
	if (Password) {
		if (PasswordsMatch && (Users->Used == 1)) {
			if (!SkipOldPassword) {
				if (!MDBChangePassword(Users->Value[0], OldPassword ? (char *)OldPassword : "", Password, V)) {
					Error = WRONG_PASSWORD;
					LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_PASSWORD_CHANGE, LOG_ERROR, 0, Users->Value[0], NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
				} else {
					LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_PASSWORD_CHANGE, LOG_ERROR, 0, Users->Value[0], NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 1, NULL, 0);
				}
			} else {
				if (!MDBChangePasswordEx(Users->Value[0], OldPassword ? (char *)OldPassword : "", Password, V)) {
					LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_PASSWORD_CHANGE, LOG_ERROR, 0, Users->Value[0], NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
				} else {
					LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_PASSWORD_CHANGE, LOG_ERROR, 0, Users->Value[0], NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 1, NULL, 0);
				}
			}
			PasswordsMatch=FALSE;
		} else {
			Error = PASSWORDS_DONT_MATCH;
		}
	}

	if (OldPassword) {
		MemFree(OldPassword);
	}

	if (Password) {
		MemFree(Password);
	}

	Password = OldPassword = NULL;
	
	/* Store proxy info */
	if ((Users->Used == 1) && ProxySave && MsgGetUserFeature(Users->Value[0], FEATURE_PROXY, NULL, NULL)) {
		unsigned long	CurrentProxy = 0;

		for (c=0; c<MAX_PROXY_ENTRIES; c++) {
			if (Proxy[c].Host && Proxy[c].User && Proxy[c].Password && Proxy[c].UID) {
				int						s;							/* Socket */
				int						Result;
				struct sockaddr_in	cs;						/* Connection descriptor	*/
				XplDnsRecord				*DNSRecord = NULL;	/* Result of DNS lookup on POP3 server hostname */
				unsigned char			*ptr;
                unsigned char *port = NULL;
				unsigned long			len;
				unsigned char			Reply[BUFSIZE+1];
				unsigned char			Answer[BUFSIZE+1];

				/* Test the proxy settings before storing them */
				if (Proxy[c].IMAP) {
					/* Test IMAP settings */

					s = socket(AF_INET, SOCK_STREAM, 0);
					if(s < 0) {
						/* Error - Count not get socket */
						Error = NETWORK_ERROR;
					} else {
						if (Proxy[c].Host[strlen(Proxy[c].Host)-1]=='.') {
							Proxy[c].Host[strlen(Proxy[c].Host)-1]='\0';
						}

                        port = strchr(Proxy[c].Host, ':');
                        if (port) {
                            *port = '\0';
                        }

						cs.sin_addr.s_addr = inet_addr(Proxy[c].Host);
						if (cs.sin_addr.s_addr == -1) {							/* Not an IP address, must resolve */
							ptr = strchr(Proxy[c].Host, '@');
							if (!ptr) {
								ptr = Proxy[c].Host;
							} else {
								ptr++;
							}
							Result = XplDnsResolve(ptr, &DNSRecord, XPL_RR_A);
							switch(Result) {
								case XPL_DNS_SUCCESS: {
									cs.sin_addr = DNSRecord->A.addr;
									break;
								}

								default: {
									/* Error - Bad Hostname */
									Error = INVALID_HOST;
									break;
								}
							}
							MemFree(DNSRecord);
						}
					}
                    if (port) {
                        *port = ':';
                    }
					if (Error == SAVED_SETTINGS) {
						cs.sin_family = AF_INET;

                        if (!port) {
                            if (Proxy[c].SSL) {
						        cs.sin_port = htons(993);
                            } else {
						        cs.sin_port = htons(143);
                            }
                        } else {
						    cs.sin_port = htons(atoi(port + 1));
                        }
						if (MsgGetHostIPAddress() == cs.sin_addr.s_addr) {		/* We don't want to proxy ourselves... */
							/* Error - Can not proxy local system */
							Error = INVALID_HOST;
						}
					}
					if (Error == SAVED_SETTINGS) {
						Result = connect(s, (struct sockaddr*)&(cs), sizeof(struct sockaddr_in));
						if (Result < 0) {
							/* Error - Could not connect */
							Error = CONNECTION_FAILED;
						}
					}
#if 0
                    /* fixme - need more accurate tests for secure and unsecure hosts */
					if (Error == SAVED_SETTINGS) {
						/* Get greeting */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "* OK", 4) != 0) {
							/* Error - IMAP server returned error */
							Error = CONNECTION_FAILED;
						}
					}
					if ((Error == SAVED_SETTINGS) && Proxy[c].SSL) {
						len = sprintf(Answer, );
						IPsend(s, Answer, "0000 CAPABILITY\r\n", 17);

						/* Handle CAPABILITY response */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "0000 OK", 7) != 0) {
							/* Error - IMAP server returned error */
							Error = CONNECTION_FAILED;
						} else if (strstr(Reply, "STARTTLS") == NULL) {
							Error = INVALID_HOST;
                        }
                    }
					if (Error == SAVED_SETTINGS) {
						len = sprintf(Answer, "0001 LOGIN %s %s\r\n", Proxy[c].User, Proxy[c].Password);
						IPsend(s, Answer, len, 0);

						/* Handle LOGIN response */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "0001 OK", 7) != 0) {
							/* Error - IMAP server returned error */
							Error = WRONG_PASSWORD;
						}
						IPsend(s, "0002 LOGOUT\r\n", 13, 0);
					}
#endif
					IPclose(s);
				} else {
					/* Test POP3 settings */

					s = socket(AF_INET, SOCK_STREAM, 0);
					if(s < 0) {
						/* Error - Count not get socket */
						Error = NETWORK_ERROR;
					} else {
						if (Proxy[c].Host[strlen(Proxy[c].Host)-1]=='.') {
							Proxy[c].Host[strlen(Proxy[c].Host)-1]='\0';
						}

                        port = strchr(Proxy[c].Host, ':');
                        if (port) {
                            *port = '\0';
                        }

						cs.sin_addr.s_addr = inet_addr(Proxy[c].Host);
						if (cs.sin_addr.s_addr == -1) {							/* Not an IP address, must resolve */
							ptr = strchr(Proxy[c].Host, '@');
							if (!ptr) {
								ptr = Proxy[c].Host;
							} else {
								ptr++;
							}
							Result = XplDnsResolve(ptr, &DNSRecord, XPL_RR_A);
							switch(Result) {
								case XPL_DNS_SUCCESS: {
									cs.sin_addr = DNSRecord->A.addr;
									break;
								}

								default: {
									/* Error - Bad Hostname */
									Error = INVALID_HOST;
									break;
								}
							}
							MemFree(DNSRecord);
						}
					}
                    if (port) {
                        *port = ':';
                    }
					if (Error == SAVED_SETTINGS) {
						cs.sin_family = AF_INET;
                        if (!port) {
                            if (Proxy[c].SSL) {
						        cs.sin_port = htons(995);
                            } else {
						        cs.sin_port = htons(110);
                            }
                        } else {
						    cs.sin_port = htons(atoi(port + 1));
                        }
						if (MsgGetHostIPAddress() == cs.sin_addr.s_addr) {		/* We don't want to proxy ourselves... */
							/* Error - Can not proxy local system */
							Error = INVALID_HOST;
						}
					}
					if (Error == SAVED_SETTINGS) {
						Result = connect(s, (struct sockaddr*)&(cs), sizeof(struct sockaddr_in));
						if (Result < 0) {
							/* Error - Could not connect */
							Error = CONNECTION_FAILED;
						}
					}
#if 0
                    /* fixme - need more accurate test for secure and unsecure hosts */
					if (Error == SAVED_SETTINGS) {
						/* Get greeting */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
                        /* STLS */
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "+OK", 3) != 0) {
							/* Error - POP server returned error */
							Error = CONNECTION_FAILED;
						}
					}
					if (Error == SAVED_SETTINGS) {
						IPsend(s, "CAPA\r\n", 6, 0);

						/* Handle CAPA response */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "+OK", 3) != 0) {
							/* Error - POP server returned error */
							Error = CONNECTION_FAILED;
						} else if (strstr(Reply, "STLS") == NULL) {
							Error = INVALID_HOST;
                        }
					}
					if (Error == SAVED_SETTINGS) {
						len = sprintf(Answer, "USER %s\r\n", Proxy[c].User);
						IPsend(s, Answer, len, 0);

						/* Handle USER response */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "+OK", 3) != 0) {
							/* Error - POP server returned error */
							Error = INVALID_USER;
						}
					}
					if (Error == SAVED_SETTINGS) {
						len = sprintf(Answer, "PASS %s\r\n", Proxy[c].Password);
						IPsend(s, Answer, len, 0);

						/* Handle PASS response */
						if (SocketReady(s, TIMEOUT)) {
							Result = IPrecv(s, Reply, sizeof(Reply), 0);
						} else {
							Result = 0;
						}
						if ((Result <= 0) || XplStrNCaseCmp(Reply, "+OK", 3) != 0) {
							/* Error - POP server returned error */
							Error = WRONG_PASSWORD;
						}
						IPsend(s, "QUIT\r\n", 6, 0);
					}
#endif
					IPclose(s);
				}

				if (Error == SAVED_SETTINGS && Proxy[c].Host[0]!='\0') {
					sprintf(Client->Temp, "Entry %d\r%s\r%s\r%s\r%s\r%c\r%c\r%c", 
						(int)(++CurrentProxy),
						Proxy[c].Host,
						Proxy[c].User,
						Proxy[c].Password,
						Proxy[c].UID,
						Proxy[c].IMAP ? '1' : '0',
						Proxy[c].KeepMail ? '1' : '0', 
                        Proxy[c].SSL ? '1' : '0');
					MDBAddValue(Client->Temp, V);
				}
			}
			if (Proxy[c].Host) {
				MemFree(Proxy[c].Host);
			}
			if (Proxy[c].User) {
				MemFree(Proxy[c].User);
			}
			if (Proxy[c].Password) {
				MemFree(Proxy[c].Password);
			}
			if (Proxy[c].UID) {
				MemFree(Proxy[c].UID);
			}
		}
		MDBWrite(Users->Value[0], MSGSRV_A_PROXY_LIST, V);
		MDBFreeValues(V);
	}
	MDBDestroyValueStruct(V);

	if (AddShareUser) {
		MemFree(AddShareUser);
	}

	if (AddShareFolder) {
		MemFree(AddShareFolder);
	}

	return(Error);
}
